/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CBinaryTypeContext;
import at.dms.kjc.CBooleanType;
import at.dms.kjc.CByteType;
import at.dms.kjc.CCharType;
import at.dms.kjc.CClassNameType;
import at.dms.kjc.CDoubleType;
import at.dms.kjc.CFloatType;
import at.dms.kjc.CIntType;
import at.dms.kjc.CLongType;
import at.dms.kjc.CNullType;
import at.dms.kjc.CPrimitiveType;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CShortType;
import at.dms.kjc.CVoidType;
import at.dms.kjc.ClassReader;
import at.dms.kjc.Constants;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.Hashtable;

public class KjcTypeFactory
extends Utils
implements TypeFactory,
Constants {
    private CVoidType voidType;
    private CNullType nullType;
    private CPrimitiveType primitiveBoolean;
    private CPrimitiveType primitiveByte;
    private CPrimitiveType primitiveChar;
    private CPrimitiveType primitiveDouble;
    private CPrimitiveType primitiveFloat;
    private CPrimitiveType primitiveInt;
    private CPrimitiveType primitiveLong;
    private CPrimitiveType primitiveShort;
    private CReferenceType objectType;
    private CReferenceType classType;
    private CReferenceType stringType;
    private CReferenceType throwableType;
    private CReferenceType exceptionType;
    private CReferenceType errorType;
    private CReferenceType runtimeExceptionType;
    private CReferenceType kopiRuntimeType;
    private final boolean genericEnabled;
    private final Hashtable knownTypes;
    protected final CBinaryTypeContext context;

    public CVoidType getVoidType() {
        return this.voidType;
    }

    public CNullType getNullType() {
        return this.nullType;
    }

    public CPrimitiveType getPrimitiveType(int n) {
        switch (n) {
            case 0: {
                return this.primitiveBoolean;
            }
            case 1: {
                return this.primitiveByte;
            }
            case 2: {
                return this.primitiveChar;
            }
            case 3: {
                return this.primitiveDouble;
            }
            case 4: {
                return this.primitiveFloat;
            }
            case 5: {
                return this.primitiveInt;
            }
            case 6: {
                return this.primitiveLong;
            }
            case 7: {
                return this.primitiveShort;
            }
        }
        throw new InconsistencyException("Unknown typeID: " + n);
    }

    public CReferenceType createReferenceType(int n) {
        switch (n) {
            case 8: {
                return this.objectType;
            }
            case 9: {
                return this.classType;
            }
            case 10: {
                return this.stringType;
            }
            case 11: {
                return this.throwableType;
            }
            case 12: {
                return this.exceptionType;
            }
            case 13: {
                return this.errorType;
            }
            case 14: {
                return this.runtimeExceptionType;
            }
            case 15: {
                return this.kopiRuntimeType;
            }
        }
        throw new InconsistencyException("Unknown typeShortcut: " + n);
    }

    public boolean isGenericEnabled() {
        return this.genericEnabled;
    }

    public CReferenceType createType(String string, boolean bl) {
        CReferenceType cReferenceType = (CReferenceType)this.knownTypes.get(string);
        if (cReferenceType == null) {
            return new CClassNameType(string, bl);
        }
        return cReferenceType;
    }

    public CReferenceType createType(String string, CReferenceType[][] cReferenceTypeArray, boolean bl) {
        CReferenceType cReferenceType = (CReferenceType)this.knownTypes.get(string);
        if (cReferenceType == null) {
            return new CClassNameType(string, cReferenceTypeArray, bl);
        }
        return cReferenceType;
    }

    protected final void addKnownTypes(String string, CReferenceType cReferenceType) {
        this.knownTypes.put(string, cReferenceType);
    }

    public KjcTypeFactory(ClassReader classReader, boolean bl) {
        CReferenceType.init(null);
        this.genericEnabled = bl;
        this.context = new CBinaryTypeContext(classReader, this);
        this.knownTypes = new Hashtable(100);
        this.voidType = new CVoidType();
        this.nullType = new CNullType();
        this.primitiveBoolean = new CBooleanType();
        this.primitiveByte = new CByteType();
        this.primitiveChar = new CCharType();
        this.primitiveDouble = new CDoubleType();
        this.primitiveFloat = new CFloatType();
        this.primitiveInt = new CIntType();
        this.primitiveLong = new CLongType();
        this.primitiveShort = new CShortType();
        this.objectType = this.createType(Constants.JAV_OBJECT, true);
        this.classType = this.createType(Constants.JAV_CLASS, true);
        this.stringType = this.createType(Constants.JAV_STRING, true);
        this.throwableType = this.createType(Constants.JAV_THROWABLE, true);
        this.exceptionType = this.createType(Constants.JAV_EXCEPTION, true);
        this.errorType = this.createType(Constants.JAV_ERROR, true);
        this.runtimeExceptionType = this.createType(Constants.JAV_RUNTIME_EXCEPTION, true);
        this.kopiRuntimeType = this.createType("at/dms/assertion/AssertionRuntime", true);
        try {
            this.objectType = (CReferenceType)this.objectType.checkType(this.context);
            this.classType = (CReferenceType)this.classType.checkType(this.context);
            this.stringType = (CReferenceType)this.stringType.checkType(this.context);
            this.throwableType = (CReferenceType)this.throwableType.checkType(this.context);
            this.exceptionType = (CReferenceType)this.exceptionType.checkType(this.context);
            this.errorType = (CReferenceType)this.errorType.checkType(this.context);
            this.runtimeExceptionType = (CReferenceType)this.runtimeExceptionType.checkType(this.context);
            this.kopiRuntimeType = (CReferenceType)this.kopiRuntimeType.checkType(this.context);
        }
        catch (UnpositionedError unpositionedError) {
            throw new InconsistencyException("Failure while loading standard types.");
        }
        this.addKnownTypes(Constants.JAV_OBJECT, this.objectType);
        this.addKnownTypes(Constants.JAV_CLASS, this.classType);
        this.addKnownTypes(Constants.JAV_STRING, this.stringType);
        this.addKnownTypes(Constants.JAV_EXCEPTION, this.exceptionType);
        this.addKnownTypes(Constants.JAV_THROWABLE, this.throwableType);
        this.addKnownTypes(Constants.JAV_ERROR, this.errorType);
        this.addKnownTypes(Constants.JAV_RUNTIME_EXCEPTION, this.runtimeExceptionType);
        this.addKnownTypes("at/dms/assertion/AssertionRuntime", this.kopiRuntimeType);
    }
}

