/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBlockContext;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CLineError;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBlock;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.KopiReturnStatement;

public class KopiImplicitReturnBlock
extends JBlock {
    protected JStatement implicitReturn;

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        CBlockContext cBlockContext = new CBlockContext(cBodyContext, cBodyContext.getEnvironment());
        int n = 0;
        while (n < this.body.length) {
            if (!cBlockContext.isReachable()) {
                throw new CLineError(this.body[n].getTokenReference(), KjcMessages.STATEMENT_UNREACHABLE);
            }
            try {
                this.body[n].analyse(cBlockContext);
            }
            catch (CLineError cLineError) {
                cBlockContext.reportTrouble(cLineError);
            }
            ++n;
        }
        TokenReference tokenReference = this.getTokenReference();
        if (cBlockContext.isReachable()) {
            this.implicitReturn = new KopiReturnStatement(tokenReference, null, null);
            try {
                this.implicitReturn.analyse(cBlockContext);
            }
            catch (CLineError cLineError) {
                cBodyContext.reportTrouble(cLineError);
            }
        }
        cBlockContext.close(tokenReference);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBlockStatement(this, this.body, this.getComments());
        if (this.implicitReturn != null) {
            this.implicitReturn.accept(kjcVisitor);
        }
    }

    public void genCode(GenerationContext generationContext) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        codeSequence.setLineNumber(this.getTokenReference().getLine());
        int n = 0;
        while (n < this.body.length) {
            this.body[n].genCode(generationContext);
            ++n;
        }
        if (this.implicitReturn != null) {
            this.implicitReturn.genCode(generationContext);
        }
    }

    public KopiImplicitReturnBlock(TokenReference tokenReference, JStatement[] jStatementArray, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, jStatementArray, javaStyleCommentArray);
    }
}

