/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.ClassFileFormatException;
import at.dms.compiler.CWarning;
import at.dms.compiler.Compiler;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.compiler.WarningFilter;
import at.dms.compiler.tools.antlr.extra.InputBuffer;
import at.dms.compiler.tools.antlr.runtime.ParserException;
import at.dms.kjc.BytecodeOptimizer;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CStdType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.DefaultFilter;
import at.dms.kjc.JCompilationUnit;
import at.dms.kjc.KjcClassReader;
import at.dms.kjc.KjcEnvironment;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcOptions;
import at.dms.kjc.KjcParser;
import at.dms.kjc.KjcPrettyPrinter;
import at.dms.kjc.KjcSignatureParser;
import at.dms.kjc.KjcTypeFactory;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Main
extends Compiler {
    protected Vector infiles;
    protected boolean errorFound;
    protected KjcOptions options;
    private int version;
    private WarningFilter filter;
    private Vector classes;
    static /* synthetic */ Class class$at$dms$kjc$CSourceClass;

    public static void main(String[] stringArray) {
        int n = Main.compile(stringArray);
        System.exit(1 - n);
    }

    public static boolean compile(String[] stringArray) {
        return new Main(null, null).run(stringArray);
    }

    public void setSourceVersion(int n) {
        this.version = n;
    }

    public int getSourceVersion() {
        return this.version;
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        KjcEnvironment kjcEnvironment = this.createEnvironment(this.options);
        this.setSourceVersion(kjcEnvironment.getSourceVersion());
        this.initialize(kjcEnvironment);
        if (this.infiles.size() == 0) {
            this.options.usage();
            this.inform(CompilerMessages.NO_INPUT_FILE);
            return false;
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.COMPILATION_STARTED, new Integer(this.infiles.size()));
        }
        try {
            this.infiles = this.verifyFiles(this.infiles);
        }
        catch (UnpositionedError unpositionedError) {
            this.reportTrouble(unpositionedError);
            return false;
        }
        this.options.destination = this.checkDestination(this.options.destination);
        JCompilationUnit[] jCompilationUnitArray = new JCompilationUnit[this.infiles.size()];
        int n = 0;
        while (n < jCompilationUnitArray.length) {
            jCompilationUnitArray[n] = this.parseFile((File)this.infiles.elementAt(n), kjcEnvironment);
            ++n;
        }
        this.infiles = null;
        if (this.errorFound) {
            return false;
        }
        if (!this.options.beautify) {
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < jCompilationUnitArray.length) {
                this.join(jCompilationUnitArray[n2]);
                ++n2;
            }
            if (this.errorFound) {
                return false;
            }
            n2 = 0;
            while (n2 < jCompilationUnitArray.length) {
                this.checkInterface(jCompilationUnitArray[n2]);
                ++n2;
            }
            if (this.verboseMode()) {
                this.inform(CompilerMessages.INTERFACES_CHECKED, new Long(System.currentTimeMillis() - l));
            }
            if (this.errorFound) {
                return false;
            }
            n2 = 0;
            while (n2 < jCompilationUnitArray.length) {
                this.checkInitializers(jCompilationUnitArray[n2]);
                ++n2;
            }
            if (this.errorFound) {
                return false;
            }
            n2 = 0;
            while (n2 < jCompilationUnitArray.length) {
                this.checkBody(jCompilationUnitArray[n2]);
                if (!this.options.java && !this.options.beautify && kjcEnvironment.getAssertExtension() != 2) {
                    jCompilationUnitArray[n2] = null;
                }
                ++n2;
            }
            if (this.errorFound) {
                return false;
            }
            if (kjcEnvironment.getAssertExtension() == 2) {
                n2 = 0;
                while (n2 < jCompilationUnitArray.length) {
                    this.checkCondition(jCompilationUnitArray[n2]);
                    if (!this.options.java && !this.options.beautify) {
                        jCompilationUnitArray[n2] = null;
                    }
                    ++n2;
                }
                if (this.errorFound) {
                    return false;
                }
            }
        }
        if (!this.options.nowrite) {
            if (this.options.java || this.options.beautify) {
                int n3 = 0;
                while (n3 < jCompilationUnitArray.length) {
                    this.generateJavaCode(jCompilationUnitArray[n3], kjcEnvironment.getTypeFactory());
                    jCompilationUnitArray[n3] = null;
                    ++n3;
                }
            } else {
                this.genCode(kjcEnvironment.getTypeFactory());
            }
        }
        if (this.errorFound) {
            return false;
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.COMPILATION_ENDED);
        }
        CodeSequence.endSession();
        return true;
    }

    protected KjcEnvironment createEnvironment(KjcOptions kjcOptions) {
        KjcClassReader kjcClassReader = new KjcClassReader(kjcOptions.classpath, kjcOptions.extdirs, new KjcSignatureParser());
        return new KjcEnvironment(kjcClassReader, new KjcTypeFactory(kjcClassReader, kjcOptions.generic), kjcOptions);
    }

    public boolean parseArguments(String[] stringArray) {
        this.options = new KjcOptions();
        if (!this.options.parseCommandLine(stringArray)) {
            return false;
        }
        this.infiles = Utils.toVector(this.options.nonOptions);
        return true;
    }

    public void genCode(TypeFactory typeFactory) {
        CSourceClass[] cSourceClassArray = this.getClasses();
        BytecodeOptimizer bytecodeOptimizer = new BytecodeOptimizer(this.options.optimize);
        this.classes.setSize(0);
        try {
            int n = 0;
            while (n < cSourceClassArray.length) {
                long l = System.currentTimeMillis();
                cSourceClassArray[n].genCode(bytecodeOptimizer, this.options.destination, typeFactory);
                if (this.verboseMode() && !cSourceClassArray[n].isNested()) {
                    this.inform(CompilerMessages.CLASSFILE_GENERATED, cSourceClassArray[n].getQualifiedName().replace('/', '.'), new Long(System.currentTimeMillis() - l));
                }
                cSourceClassArray[n] = null;
                ++n;
            }
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
        catch (ClassFileFormatException classFileFormatException) {
            classFileFormatException.printStackTrace();
            this.reportTrouble(new UnpositionedError(CompilerMessages.FORMATTED_ERROR, classFileFormatException.getMessage()));
        }
        catch (IOException iOException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.IO_EXCEPTION, "classfile", iOException.getMessage()));
        }
    }

    protected void initialize(KjcEnvironment kjcEnvironment) {
        CStdType.init(this, kjcEnvironment);
    }

    public boolean verboseMode() {
        return this.options.verbose;
    }

    protected JCompilationUnit parseFile(File file, KjcEnvironment kjcEnvironment) {
        JCompilationUnit jCompilationUnit;
        InputBuffer inputBuffer;
        try {
            inputBuffer = new InputBuffer(file, this.options.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.UNSUPPORTED_ENCODING, this.options.encoding));
            return null;
        }
        catch (IOException iOException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.IO_EXCEPTION, file.getPath(), iOException.getMessage()));
            return null;
        }
        long l = System.currentTimeMillis();
        KjcParser kjcParser = new KjcParser((Compiler)this, inputBuffer, kjcEnvironment);
        try {
            jCompilationUnit = kjcParser.jCompilationUnit();
        }
        catch (ParserException parserException) {
            this.reportTrouble(kjcParser.beautifyParseError(parserException));
            jCompilationUnit = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorFound = true;
            jCompilationUnit = null;
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.FILE_PARSED, file.getPath(), new Long(System.currentTimeMillis() - l));
        }
        try {
            inputBuffer.close();
        }
        catch (IOException iOException) {
            this.reportTrouble(new UnpositionedError(CompilerMessages.IO_EXCEPTION, file.getPath(), iOException.getMessage()));
        }
        return jCompilationUnit;
    }

    protected void join(JCompilationUnit jCompilationUnit) {
        try {
            jCompilationUnit.join(this);
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
    }

    protected void checkInterface(JCompilationUnit jCompilationUnit) {
        try {
            jCompilationUnit.checkInterface(this);
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
    }

    protected void checkInitializers(JCompilationUnit jCompilationUnit) {
        try {
            jCompilationUnit.checkInitializers(this, this.classes);
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
    }

    protected void checkBody(JCompilationUnit jCompilationUnit) {
        long l = System.currentTimeMillis();
        try {
            jCompilationUnit.checkBody(this, this.classes);
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.BODY_CHECKED, jCompilationUnit.getFileName(), new Long(System.currentTimeMillis() - l));
        }
    }

    protected void checkCondition(JCompilationUnit jCompilationUnit) {
        long l = System.currentTimeMillis();
        try {
            jCompilationUnit.analyseConditions();
        }
        catch (PositionedError positionedError) {
            this.reportTrouble(positionedError);
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.CONDITION_CHECKED, jCompilationUnit.getFileName(), new Long(System.currentTimeMillis() - l));
        }
    }

    protected void generateJavaCode(JCompilationUnit jCompilationUnit, TypeFactory typeFactory) {
        long l = System.currentTimeMillis();
        String string = this.options.destination == null || this.options.destination.equals("") ? jCompilationUnit.getTokenReference().getName() + ".gen" : this.options.destination + File.separatorChar + jCompilationUnit.getTokenReference().getName();
        try {
            KjcPrettyPrinter kjcPrettyPrinter = this.getPrettyPrinter(string, typeFactory);
            jCompilationUnit.accept(kjcPrettyPrinter);
            kjcPrettyPrinter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("cannot write: " + string);
        }
        if (this.verboseMode()) {
            this.inform(CompilerMessages.JAVA_CODE_GENERATED, jCompilationUnit.getFileName(), new Long(System.currentTimeMillis() - l));
        }
    }

    public void reportTrouble(PositionedError positionedError) {
        if (positionedError instanceof CWarning) {
            if (this.options.warning != 0 && this.filterWarning((CWarning)positionedError)) {
                this.inform(positionedError);
            }
        } else if (positionedError.getTokenReference() != TokenReference.NO_REF) {
            this.inform(positionedError);
            this.errorFound = true;
        } else {
            this.inform(positionedError);
        }
    }

    public void reportTrouble(UnpositionedError unpositionedError) {
        this.inform(unpositionedError);
        this.errorFound = true;
    }

    protected boolean filterWarning(CWarning cWarning) {
        WarningFilter warningFilter = this.getFilter();
        int n = warningFilter.filter(cWarning);
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                boolean bl = false;
                if (cWarning.getSeverityLevel() <= this.options.warning) {
                    bl = true;
                }
                return bl;
            }
        }
        throw new InconsistencyException();
    }

    protected WarningFilter getFilter() {
        if (this.filter == null) {
            if (this.options.filter != null) {
                try {
                    this.filter = (WarningFilter)Class.forName(this.options.filter).newInstance();
                }
                catch (Exception exception) {
                    this.inform(KjcMessages.FILTER_NOT_FOUND, this.options.filter);
                }
            }
            if (this.filter == null) {
                this.filter = new DefaultFilter();
            }
        }
        return this.filter;
    }

    public boolean parseComments() {
        boolean bl = false;
        if (this.options.deprecation || this.options.beautify && !this.options.nowrite) {
            bl = true;
        }
        return bl;
    }

    public CSourceClass[] getClasses() {
        Class clazz = class$at$dms$kjc$CSourceClass;
        if (clazz == null) {
            clazz = class$at$dms$kjc$CSourceClass = Main.class$("[Lat.dms.kjc.CSourceClass;", false);
        }
        return (CSourceClass[])Utils.toArray(this.classes, clazz);
    }

    protected KjcPrettyPrinter getPrettyPrinter(String string, TypeFactory typeFactory) throws IOException {
        return new KjcPrettyPrinter(string, typeFactory);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.infiles = new Vector();
        this.version = 0;
        this.filter = null;
        this.classes = new Vector(100);
    }

    public Main(String string, PrintWriter printWriter) {
        super(string, printWriter);
        this.this();
    }
}

