/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ksm;

import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ClassInfo;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.compiler.tools.antlr.runtime.ParserException;
import at.dms.ksm.KsmError;
import at.dms.ksm.KsmLexer;
import at.dms.ksm.KsmMessages;
import at.dms.ksm.KsmParser;
import at.dms.optimize.Main;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Assembler {
    public void assemble(String string, String string2, int n) throws KsmError {
        ClassInfo classInfo = this.parseInput(string);
        if (n > 0) {
            try {
                Main.optimizeClass(classInfo, n, false);
            }
            catch (UnpositionedError unpositionedError) {
                throw new KsmError(null, unpositionedError.getFormattedMessage());
            }
        }
        try {
            classInfo.write(string2);
        }
        catch (ClassFileFormatException classFileFormatException) {
            throw new KsmError(null, KsmMessages.SEMANTIC_ERROR, classInfo.getName(), classFileFormatException.getMessage());
        }
        catch (IOException iOException) {
            throw new KsmError(null, CompilerMessages.IO_EXCEPTION, classInfo.getName(), iOException.getMessage());
        }
    }

    private final ClassInfo parseInput(String string) throws KsmError {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            KsmLexer ksmLexer = new KsmLexer(bufferedInputStream);
            KsmParser ksmParser = new KsmParser(ksmLexer);
            ClassInfo classInfo = ksmParser.aCompilationUnit();
            ((InputStream)bufferedInputStream).close();
            return classInfo;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KsmError(null, CompilerMessages.FILE_NOT_FOUND, string);
        }
        catch (IOException iOException) {
            throw new KsmError(null, CompilerMessages.IO_EXCEPTION, string, iOException.getMessage());
        }
        catch (KsmError ksmError) {
            throw ksmError;
        }
        catch (ParserException parserException) {
            throw new KsmError(new TokenReference(string, parserException.getLine()), CompilerMessages.SYNTAX_ERROR, parserException.getMessage());
        }
    }
}

