/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ksm;

import at.dms.compiler.CompilerMessages;
import at.dms.ksm.Assembler;
import at.dms.ksm.KsmError;
import at.dms.ksm.KsmMessages;
import at.dms.ksm.KsmOptions;
import at.dms.util.Message;
import at.dms.util.MessageDescription;

public class Main {
    private KsmOptions options;

    public static void main(String[] stringArray) {
        int n = new Main().run(stringArray);
        System.exit(1 - n);
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        String[] stringArray2 = this.options.nonOptions;
        if (stringArray2.length == 0) {
            this.options.usage();
            this.inform(CompilerMessages.NO_INPUT_FILE);
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray2.length) {
            if (this.options.verbose) {
                this.inform(KsmMessages.PROCESSING, new String[]{stringArray2[n]});
            }
            try {
                Assembler assembler = new Assembler();
                assembler.assemble(stringArray2[n], this.options.destination, this.options.optimize);
            }
            catch (KsmError ksmError) {
                this.inform(ksmError.getMessage());
                bl = true;
            }
            ++n;
        }
        return bl ^ true;
    }

    private final boolean parseArguments(String[] stringArray) {
        this.options = new KsmOptions();
        return this.options.parseCommandLine(stringArray);
    }

    public void inform(Message message) {
        this.inform(message.getMessage());
    }

    public void inform(MessageDescription messageDescription, Object[] objectArray) {
        this.inform(new Message(messageDescription, objectArray));
    }

    public void inform(MessageDescription messageDescription) {
        this.inform(messageDescription, null);
    }

    private final void inform(String string) {
        System.err.println(string);
        System.err.flush();
    }

    private Main() {
    }
}

