/*
 * Decompiled with CFR 0.152.
 */
package at.dms.memcnt;

import at.dms.classfile.ClassInfo;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.Constants;
import at.dms.classfile.FieldInfo;
import at.dms.classfile.FieldRefInstruction;
import at.dms.classfile.Instruction;
import at.dms.classfile.MethodInfo;
import at.dms.classfile.MethodRefInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.classfile.PushLiteralInstruction;

public class Instrumenter
implements Constants {
    private ClassInfo classInfo;

    public static ClassInfo instrument(ClassInfo classInfo) {
        Instrumenter instrumenter = new Instrumenter(classInfo);
        return instrumenter.addCounting() ? instrumenter.getClassInfo() : null;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public boolean addCounting() {
        System.err.print("Processing " + this.classInfo.getName() + " ... ");
        System.err.flush();
        System.err.print("checked ... ");
        System.err.flush();
        if ((this.classInfo.getModifiers() & 0x200) != 0) {
            System.err.println(" is an interface.");
            System.err.flush();
            return false;
        }
        if ((this.classInfo.getModifiers() & 1) == 0) {
            System.err.println(" is not public.");
            System.err.flush();
            return false;
        }
        if (this.findMethod("memcnt$incr") != null) {
            System.err.println(" is already instrumented.");
            System.err.flush();
            return false;
        }
        this.addCounterField();
        this.addIncrementMethod();
        this.instrumentInitializer();
        this.instrumentConstructors();
        System.err.println(" done!");
        System.err.flush();
        return true;
    }

    private final void addCounterField() {
        FieldInfo fieldInfo = new FieldInfo(9, "memcnt$totins", "I", null, null, false, false);
        this.addField(fieldInfo);
    }

    private final void addIncrementMethod() {
        Instruction[] instructionArray = new Instruction[]{new FieldRefInstruction(178, this.classInfo.getName() + "/memcnt$totins", "I"), new PushLiteralInstruction(1), new NoArgInstruction(96), new FieldRefInstruction(179, this.classInfo.getName() + "/memcnt$totins", "I"), new NoArgInstruction(177)};
        CodeInfo codeInfo = new CodeInfo(instructionArray, null, null, null);
        MethodInfo methodInfo = new MethodInfo(10, "memcnt$incr", "()V", null, null, codeInfo, false, false);
        this.addMethod(methodInfo);
    }

    private final void instrumentInitializer() {
        MethodInfo methodInfo = this.findMethod("<clinit>");
        if (methodInfo == null) {
            CodeInfo codeInfo = new CodeInfo(new Instruction[]{new NoArgInstruction(177)}, null, null, null);
            methodInfo = new MethodInfo(8, "<clinit>", "()V", null, null, codeInfo, false, false);
            this.addMethod(methodInfo);
        }
        Instruction[] instructionArray = new Instruction[]{new PushLiteralInstruction(this.classInfo.getName().replace('/', '.')), new MethodRefInstruction(184, "at/dms/memcnt/Registry/register", "(Ljava/lang/String;)V")};
        this.insertInstructions(methodInfo, instructionArray);
    }

    private final void instrumentConstructors() {
        MethodInfo[] methodInfoArray = this.classInfo.getMethods();
        if (methodInfoArray != null) {
            int n = 0;
            while (n < methodInfoArray.length) {
                if (methodInfoArray[n].getName().equals("<init>")) {
                    this.instrumentConstructor(methodInfoArray[n]);
                }
                ++n;
            }
        }
    }

    private final void instrumentConstructor(MethodInfo methodInfo) {
        if (this.constructorToInstrument(methodInfo)) {
            this.insertInstructions(methodInfo, new Instruction[]{new MethodRefInstruction(184, this.classInfo.getName() + "/memcnt$incr", "()V")});
        }
    }

    private final boolean constructorToInstrument(MethodInfo methodInfo) {
        if (methodInfo.getCodeInfo() == null) {
            return false;
        }
        Instruction[] instructionArray = methodInfo.getCodeInfo().getInstructions();
        return true;
    }

    private final FieldInfo findField(String string) {
        FieldInfo[] fieldInfoArray = this.classInfo.getFields();
        if (fieldInfoArray == null) {
            return null;
        }
        int n = 0;
        while (n < fieldInfoArray.length) {
            if (fieldInfoArray[n].getName().equals(string)) {
                return fieldInfoArray[n];
            }
            ++n;
        }
        return null;
    }

    private final void addField(FieldInfo fieldInfo) {
        FieldInfo[] fieldInfoArray;
        FieldInfo[] fieldInfoArray2 = this.classInfo.getFields();
        if (fieldInfoArray2 == null) {
            fieldInfoArray = new FieldInfo[1];
        } else {
            fieldInfoArray = new FieldInfo[fieldInfoArray2.length + 1];
            System.arraycopy(fieldInfoArray2, 0, fieldInfoArray, 0, fieldInfoArray2.length);
        }
        fieldInfoArray[fieldInfoArray.length - 1] = fieldInfo;
        this.classInfo.setFields(fieldInfoArray);
    }

    private final void addMethod(MethodInfo methodInfo) {
        MethodInfo[] methodInfoArray;
        MethodInfo[] methodInfoArray2 = this.classInfo.getMethods();
        if (methodInfoArray2 == null) {
            methodInfoArray = new MethodInfo[1];
        } else {
            methodInfoArray = new MethodInfo[methodInfoArray2.length + 1];
            System.arraycopy(methodInfoArray2, 0, methodInfoArray, 0, methodInfoArray2.length);
        }
        methodInfoArray[methodInfoArray.length - 1] = methodInfo;
        this.classInfo.setMethods(methodInfoArray);
    }

    private final MethodInfo findMethod(String string) {
        MethodInfo[] methodInfoArray = this.classInfo.getMethods();
        if (methodInfoArray == null) {
            return null;
        }
        int n = 0;
        while (n < methodInfoArray.length) {
            if (methodInfoArray[n].getName().equals(string)) {
                return methodInfoArray[n];
            }
            ++n;
        }
        return null;
    }

    private final void insertInstructions(MethodInfo methodInfo, Instruction[] instructionArray) {
        CodeInfo codeInfo = methodInfo.getCodeInfo();
        Instruction[] instructionArray2 = codeInfo.getInstructions();
        int n = instructionArray2.length;
        while (instructionArray2[n - 1] == null) {
            --n;
        }
        Instruction[] instructionArray3 = new Instruction[instructionArray.length + n];
        System.arraycopy(instructionArray, 0, instructionArray3, 0, instructionArray.length);
        System.arraycopy(instructionArray2, 0, instructionArray3, instructionArray.length, n);
        int n2 = 0;
        while (n2 < instructionArray3.length) {
            if (instructionArray3[n2] == null) {
                System.err.println("*** instruction " + n2 + " of " + instructionArray3.length + " is null");
            }
            ++n2;
        }
        methodInfo.setCodeInfo(new CodeInfo(instructionArray3, codeInfo.getHandlers(), codeInfo.getLineNumbers(), codeInfo.getLocalVariables()));
    }

    public Instrumenter(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }
}

