/*
 * Decompiled with CFR 0.152.
 */
package at.dms.memcnt;

import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ClassInfo;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.UnpositionedError;
import at.dms.memcnt.Instrumenter;
import at.dms.memcnt.MemcntMessages;
import at.dms.memcnt.MemcntOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Main {
    private MemcntOptions options;

    private final void instrumentClass(String string) throws UnpositionedError {
        ClassInfo classInfo = this.readClassFile(string);
        if ((classInfo = Instrumenter.instrument(classInfo)) != null) {
            this.writeClassFile(classInfo, string);
        }
    }

    private final ClassInfo readClassFile(String string) throws UnpositionedError {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 2048));
            ClassInfo classInfo = new ClassInfo(dataInputStream, false);
            dataInputStream.close();
            return classInfo;
        }
        catch (ClassFileFormatException classFileFormatException) {
            throw new UnpositionedError(MemcntMessages.SEMANTIC_ERROR, new Object[]{string, classFileFormatException.getMessage()});
        }
        catch (IOException iOException) {
            throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{string, iOException.getMessage()});
        }
    }

    private final void writeClassFile(ClassInfo classInfo, String string) throws UnpositionedError {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            classInfo.write(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (ClassFileFormatException classFileFormatException) {
            throw new UnpositionedError(MemcntMessages.SEMANTIC_ERROR, new Object[]{string, classFileFormatException.getMessage()});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{string, iOException.getMessage()});
        }
    }

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    private final boolean parseArguments(String[] stringArray) {
        this.options = new MemcntOptions();
        return this.options.parseCommandLine(stringArray);
    }

    private Main(String[] stringArray) {
        String[] stringArray2;
        if (!this.parseArguments(stringArray)) {
            System.exit(1);
        }
        if ((stringArray2 = this.options.nonOptions).length == 0) {
            this.options.usage();
            System.err.println(CompilerMessages.NO_INPUT_FILE);
            System.exit(1);
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (this.options.verbose) {
                    System.err.println("Processing " + stringArray2[n2] + '.');
                }
                try {
                    this.instrumentClass(stringArray2[n2]);
                }
                catch (UnpositionedError unpositionedError) {
                    System.err.println("Error: " + unpositionedError.getMessage());
                    n = 1;
                }
                ++n2;
            }
            System.exit(n);
        }
    }
}

