/*
 * Decompiled with CFR 0.152.
 */
package at.dms.optimize;

import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ClassInfo;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.MethodInfo;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.UnpositionedError;
import at.dms.optimize.OptimizeMessages;
import at.dms.optimize.OptimizeOptions;
import at.dms.optimize.Optimizer;
import at.dms.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Main {
    protected OptimizeOptions options;

    private final void optimizeClass(String string) throws UnpositionedError {
        ClassInfo classInfo = this.readClassFile(string);
        Main.optimizeClass(classInfo, this.options.optimize, this.options.verbose);
        this.writeClassFile(classInfo, this.options.destination == null ? string : this.options.destination + File.separatorChar + Utils.splitQualifiedName(classInfo.getName())[1] + ".class");
    }

    public static void optimizeClass(ClassInfo classInfo, int n, boolean bl) throws UnpositionedError {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        MethodInfo[] methodInfoArray = classInfo.getMethods();
        int n5 = 0;
        while (n5 < methodInfoArray.length) {
            if (methodInfoArray[n5].getCodeInfo() != null) {
                if (bl) {
                    n2 = methodInfoArray[n5].getCodeInfo().getInstructions().length;
                }
                Main.optimizeMethod(methodInfoArray[n5], n, bl);
                if (bl) {
                    CodeInfo codeInfo = methodInfoArray[n5].getCodeInfo();
                    System.err.println(methodInfoArray[n5].getName() + "\t[" + (double)codeInfo.getInstructions().length * 100.0 / (double)n2 + ']' + n2 + " / " + codeInfo.getInstructions().length);
                    n3 += n2;
                    n4 += codeInfo.getInstructions().length;
                }
            }
            ++n5;
        }
        if (bl) {
            System.err.println("TOTAL:\t[" + (double)n4 * 100.0 / (double)n3 + ']' + n4 + " / " + n3);
        }
    }

    private static final void optimizeMethod(MethodInfo methodInfo, int n, boolean bl) {
        CodeInfo codeInfo = methodInfo.getCodeInfo();
        if (codeInfo != null) {
            long l = codeInfo.getInstructions().length;
            codeInfo = Optimizer.optimize(codeInfo, n);
            methodInfo.setCodeInfo(codeInfo);
        }
    }

    private final ClassInfo readClassFile(String string) throws UnpositionedError {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 2048));
            ClassInfo classInfo = new ClassInfo(dataInputStream, false);
            dataInputStream.close();
            return classInfo;
        }
        catch (ClassFileFormatException classFileFormatException) {
            throw new UnpositionedError(OptimizeMessages.SEMANTIC_ERROR, new Object[]{string, classFileFormatException.getMessage()});
        }
        catch (IOException iOException) {
            throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{string, iOException.getMessage()});
        }
    }

    private final void writeClassFile(ClassInfo classInfo, String string) throws UnpositionedError {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            classInfo.write(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (ClassFileFormatException classFileFormatException) {
            throw new UnpositionedError(OptimizeMessages.SEMANTIC_ERROR, new Object[]{string, classFileFormatException.getMessage()});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{string, iOException.getMessage()});
        }
    }

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    private final boolean parseArguments(String[] stringArray) {
        this.options = new OptimizeOptions();
        return this.options.parseCommandLine(stringArray);
    }

    private Main(String[] stringArray) {
        String[] stringArray2;
        if (!this.parseArguments(stringArray)) {
            System.exit(1);
        }
        if ((stringArray2 = this.options.nonOptions).length == 0) {
            this.options.usage();
            System.err.println(CompilerMessages.NO_INPUT_FILE);
            System.exit(1);
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (this.options.verbose) {
                    System.err.println("Processing " + stringArray2[n2] + '.');
                }
                try {
                    this.optimizeClass(stringArray2[n2]);
                }
                catch (UnpositionedError unpositionedError) {
                    System.err.println("Error: " + unpositionedError.getMessage());
                    n = 1;
                }
                ++n2;
            }
            System.exit(n);
        }
    }
}

