/*
 * Decompiled with CFR 0.152.
 */
package at.dms.optimize;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.OpcodeNames;
import at.dms.optimize.HandleCreator;
import at.dms.optimize.InstructionHandle;
import at.dms.optimize.Patterns;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.Vector;

public class Optimizer
implements AccessorContainer {
    private InstructionHandle codeStart;
    private HandlerInfo[] handlers;
    private LocalVariableInfo[] localVariables;
    static /* synthetic */ Class class$at$dms$classfile$LineNumberInfo;

    public static CodeInfo optimize(CodeInfo codeInfo, int n) {
        Optimizer optimizer = new Optimizer(codeInfo);
        boolean bl = true;
        while (bl) {
            bl = optimizer.optimizeCodeSequence();
        }
        codeInfo = optimizer.getCodeInfo();
        return codeInfo;
    }

    public CodeInfo getCodeInfo() {
        CodeInfo codeInfo = new CodeInfo(this.buildInstructionArray(), this.handlers, this.buildLineNumberInfo(), this.localVariables);
        try {
            AccessorTransformer accessorTransformer = new AccessorTransformer(this){
                final /* synthetic */ Optimizer this$0;

                public final InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) {
                    return ((InstructionHandle)instructionAccessor).getInstruction();
                }
                {
                    this.this$0 = optimizer;
                }
            };
            codeInfo.transformAccessors(accessorTransformer);
        }
        catch (BadAccessorException badAccessorException) {
            throw new InconsistencyException(badAccessorException.getMessage());
        }
        return codeInfo;
    }

    private final void buildBasicBlocks(InstructionHandle instructionHandle) {
        InstructionHandle instructionHandle2 = this.codeStart;
        while (instructionHandle2 != null) {
            instructionHandle2.reset();
            instructionHandle2 = instructionHandle2.getNext();
        }
        int n = 0;
        while (n < this.handlers.length) {
            ((InstructionHandle)this.handlers[n].getHandler()).addAccessor(this.handlers[n]);
            ((InstructionHandle)this.handlers[n].getStart()).addAccessor(this.handlers[n]);
            ++n;
        }
    }

    private final boolean optimizeCodeSequence() {
        boolean bl = false;
        this.buildBasicBlocks(this.codeStart);
        InstructionHandle instructionHandle = this.codeStart;
        while (instructionHandle != null) {
            bl |= Patterns.optimize(instructionHandle);
            instructionHandle = instructionHandle.getNext();
        }
        return bl |= this.cleanCode();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean cleanCode() {
        var1_1 = false;
        var2_2 = 0;
        ** GOTO lbl8
        {
            this.handlers[var2_2].setEnd(((InstructionHandle)this.handlers[var2_2].getEnd()).getPrevious());
            do {
                if (!((InstructionHandle)this.handlers[var2_2].getEnd()).isReached()) continue block0;
                ++var2_2;
lbl8:
                // 2 sources

            } while (var2_2 < this.handlers.length);
        }
        var2_3 = this.codeStart;
        var3_4 = var2_3.getNext();
        while (var3_4 != null) {
            if (var3_4.isReached()) {
                var2_3.setNext(var3_4);
                var2_3 = var3_4;
            } else {
                var2_3.setNext(null);
                var1_1 = true;
            }
            var3_4.clean();
            var3_4 = var3_4.getNext();
        }
        if (var2_3 == this.codeStart) {
            this.codeStart.setNext(null);
        }
        return var1_1;
    }

    private final InstructionHandle installInstructionHandles(CodeInfo codeInfo) {
        Instruction[] instructionArray = codeInfo.getInstructions();
        InstructionHandle[] instructionHandleArray = new InstructionHandle[instructionArray.length];
        int n = 0;
        while (n < instructionHandleArray.length) {
            instructionHandleArray[n] = new InstructionHandle(instructionArray[n], n == 0 ? null : instructionHandleArray[n - 1]);
            ++n;
        }
        try {
            codeInfo.transformAccessors(new HandleCreator(instructionArray, instructionHandleArray));
        }
        catch (BadAccessorException badAccessorException) {
            this.dumpCode(instructionArray);
            throw new InconsistencyException(badAccessorException.getMessage());
        }
        return instructionHandleArray[0];
    }

    private final void dumpCode(Instruction[] instructionArray) {
        int n = 0;
        while (n < instructionArray.length) {
            instructionArray[n].dump();
            ++n;
        }
        System.err.flush();
    }

    private final void dumpCode() {
        int n = 0;
        InstructionHandle instructionHandle = this.codeStart;
        while (instructionHandle != null) {
            System.err.println(n++ + ":\t" + OpcodeNames.getName(instructionHandle.getInstruction().getOpcode()));
            instructionHandle = instructionHandle.getNext();
        }
        System.err.flush();
    }

    private final Instruction[] buildInstructionArray() {
        int n = 0;
        Instruction[] instructionArray = this.codeStart;
        while (instructionArray != null) {
            ++n;
            instructionArray = instructionArray.getNext();
        }
        instructionArray = new Instruction[n];
        n = 0;
        InstructionHandle instructionHandle = this.codeStart;
        while (instructionHandle != null) {
            instructionArray[n] = instructionHandle.getInstruction();
            ++n;
            instructionHandle = instructionHandle.getNext();
        }
        return instructionArray;
    }

    private final LineNumberInfo[] buildLineNumberInfo() {
        Vector vector = new Vector();
        InstructionHandle instructionHandle = this.codeStart;
        while (instructionHandle != null) {
            instructionHandle.addLineNumberInfo(vector);
            instructionHandle = instructionHandle.getNext();
        }
        Class clazz = class$at$dms$classfile$LineNumberInfo;
        if (clazz == null) {
            clazz = class$at$dms$classfile$LineNumberInfo = Optimizer.class$("[Lat.dms.classfile.LineNumberInfo;", false);
        }
        return (LineNumberInfo[])Utils.toArray(vector, clazz);
    }

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        this.codeStart = (InstructionHandle)this.codeStart.transform(accessorTransformer, this);
    }

    public void setCodeStart(InstructionHandle instructionHandle) {
        if (this.codeStart != null) {
            this.codeStart.removeAccessor(this);
        }
        this.codeStart = instructionHandle;
        this.codeStart.addAccessor(this);
    }

    public InstructionHandle getCodeStart() {
        return this.codeStart;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Optimizer(CodeInfo codeInfo) {
        this.setCodeStart(this.installInstructionHandles(codeInfo));
        this.handlers = codeInfo.getHandlers();
        this.localVariables = codeInfo.getLocalVariables();
    }
}

