/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.Instruction;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.SwitchInstruction;
import at.dms.ssa.CFGEdge;
import at.dms.ssa.CodeGeneratorBasicBlock;
import at.dms.ssa.CodeGeneratorMethod;
import at.dms.ssa.DoubleIterator;
import at.dms.ssa.Edge;
import at.dms.ssa.Graph;
import at.dms.ssa.Node;
import at.dms.ssa.QAbstractJumpInst;
import at.dms.ssa.QAssignment;
import at.dms.ssa.QInst;
import at.dms.ssa.QInstArray;
import at.dms.ssa.QJump;
import at.dms.ssa.QNew;
import at.dms.ssa.QNewInitialized;
import at.dms.ssa.QNop;
import at.dms.ssa.QOperand;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QPhi;
import at.dms.ssa.QVar;
import at.dms.ssa.QVoidMethodCall;
import at.dms.ssa.QuadrupleGenerator;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class BasicBlock
extends Node {
    protected Edge defaultNext;
    protected Edge conditionNext;
    protected QInstArray insts;
    protected QInstArray phis;
    protected int firstInst;
    protected int lastInst;
    protected int firstInstGen;
    protected int nbGen;
    protected BasicBlock previous;
    protected BasicBlock next;
    protected boolean firstBlockSubroutine;
    protected boolean catchBlock;
    protected QOperand[] entryStack;

    public void addInstruction(QInst qInst) {
        this.insts.addInstruction(qInst);
    }

    public Iterator getInstructions() {
        return this.insts.iterator();
    }

    public void addPhi(QPhi qPhi) {
        this.phis.addInstruction(qPhi);
    }

    public Iterator getPhis() {
        return this.phis.iterator();
    }

    public Iterator getAllSSAInstructions() {
        return new DoubleIterator(this.phis.iterator(), this.insts.iterator());
    }

    public QInst removeLastInstruction() {
        return this.insts.removeLastInstruction();
    }

    public QInstArray getInstructionsArray() {
        return this.insts;
    }

    public QInstArray getPhisArray() {
        return this.phis;
    }

    public Edge addDefaultNextBlock(BasicBlock basicBlock) {
        this.defaultNext = new CFGEdge(0);
        return this.addSuccessor(this.defaultNext, basicBlock);
    }

    public Edge addConditionNextBlock(BasicBlock basicBlock) {
        this.conditionNext = new CFGEdge(1);
        return this.addSuccessor(this.conditionNext, basicBlock);
    }

    public Edge addSwitchNextBlock(BasicBlock basicBlock) {
        CFGEdge cFGEdge = new CFGEdge(2);
        return this.addSuccessor(cFGEdge, basicBlock);
    }

    public Edge addExceptionNextBlock(BasicBlock basicBlock) {
        CFGEdge cFGEdge = new CFGEdge(3);
        return this.addSuccessor(cFGEdge, basicBlock);
    }

    public Edge addSubRoutineReturnNextBlock(BasicBlock basicBlock) {
        CFGEdge cFGEdge = new CFGEdge(4);
        return this.addSuccessor(cFGEdge, basicBlock);
    }

    public Edge addSubRoutineCallNextBlock(BasicBlock basicBlock) {
        this.defaultNext = new CFGEdge(4);
        return this.addSuccessor(this.defaultNext, basicBlock);
    }

    public Edge addCFGNextBlock(BasicBlock basicBlock) {
        CFGEdge cFGEdge = new CFGEdge(5);
        return this.addSuccessor(cFGEdge, basicBlock);
    }

    public BasicBlock[] getNextBasicBlocks() {
        Object object;
        Vector<BasicBlock> vector = new Vector<BasicBlock>();
        Iterator iterator = this.getOutEdges();
        while (iterator.hasNext()) {
            BasicBlock basicBlock;
            object = (CFGEdge)iterator.next();
            int n = ((CFGEdge)object).getType();
            if (n == 3 || n == 5 || n == 4 || (basicBlock = (BasicBlock)((CFGEdge)object).getTarget()) == null) continue;
            vector.addElement(basicBlock);
        }
        object = new BasicBlock[vector.size()];
        vector.toArray((T[])object);
        return object;
    }

    public Edge getDefaultNext() {
        return this.defaultNext;
    }

    public Edge getConditionNext() {
        return this.conditionNext;
    }

    public boolean isEmpty() {
        if (this.insts.size() == 0) {
            return true;
        }
        boolean bl = false;
        if (this.insts.size() == 1 && this.insts.getInstructionAt(0) instanceof QJump) {
            bl = true;
        }
        return bl;
    }

    public QJump getJump() {
        if (this.insts.size() == 0) {
            return null;
        }
        QInst qInst = this.insts.getLastInstruction();
        if (qInst instanceof QJump) {
            return (QJump)qInst;
        }
        return null;
    }

    public int getStartGen() {
        return this.firstInstGen;
    }

    public int getNbGen() {
        return this.nbGen;
    }

    public int getStart() {
        return this.firstInst;
    }

    void setStart(int n) {
        this.firstInst = n;
    }

    public int getEnd() {
        return this.lastInst;
    }

    public String toString() {
        String string = "";
        string = string + super.toString();
        return string;
    }

    public boolean isFirstBlockSubroutine() {
        return this.firstBlockSubroutine;
    }

    public boolean isCatchBlock() {
        return this.catchBlock;
    }

    public void setFirstBlockSubroutine(boolean bl) {
        this.firstBlockSubroutine = bl;
    }

    public void setCatchBlock(boolean bl) {
        this.catchBlock = bl;
    }

    public QOperand[] getEntryStack() {
        return this.entryStack;
    }

    public void setEntryStack(QOperand[] qOperandArray) {
        this.entryStack = qOperandArray;
    }

    public BasicBlock getPrevious() {
        return this.previous;
    }

    public BasicBlock getNext() {
        return this.next;
    }

    public boolean hasNext() {
        boolean bl = false;
        if (this.next != null) {
            bl = true;
        }
        return bl;
    }

    public void setPrevious(BasicBlock basicBlock) {
        if (basicBlock != null) {
            basicBlock.next = this;
        }
        this.previous = basicBlock;
    }

    public void setNext(BasicBlock basicBlock) {
        if (basicBlock != null) {
            basicBlock.previous = this;
        }
        this.next = basicBlock;
    }

    public void insertBefore(BasicBlock basicBlock) {
        if (this.previous == null) {
            this.setPrevious(basicBlock);
        }
        this.previous.next = basicBlock;
        basicBlock.previous = this.previous;
        this.previous = basicBlock;
        basicBlock.next = this;
    }

    public void insertAfter(BasicBlock basicBlock) {
        if (this.next == null) {
            this.setNext(basicBlock);
        }
        this.next.previous = basicBlock;
        basicBlock.next = this.next;
        this.next = basicBlock;
        basicBlock.previous = this;
    }

    public void removeFromList() {
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
    }

    void simplifyNewInstructions() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        while (n < this.insts.size()) {
            Object object;
            QOperandBox[] qOperandBoxArray;
            QInst qInst = this.insts.getInstructionAt(n);
            if (qInst instanceof QAssignment) {
                qOperandBoxArray = (QOperandBox[])qInst;
                Integer n2 = new Integer(((QVar)qOperandBoxArray.getDefined().getOperand()).getRegister());
                if (qOperandBoxArray.getExpression() instanceof QNew) {
                    hashMap.put(n2, new Integer(n));
                } else {
                    hashMap.remove(n2);
                }
            }
            qOperandBoxArray = qInst.getUses();
            int n3 = 0;
            if (qInst instanceof QVoidMethodCall && ((QVoidMethodCall)qInst).isInvokespecial()) {
                n3 = 1;
            }
            while (n3 < qOperandBoxArray.length) {
                if (qOperandBoxArray[n3].getOperand() instanceof QVar) {
                    object = new Integer(((QVar)qOperandBoxArray[n3].getOperand()).getRegister());
                    hashMap.remove(object);
                }
                ++n3;
            }
            if (qInst instanceof QVoidMethodCall && ((QVoidMethodCall)qInst).isInvokespecial()) {
                int n4;
                Integer n5;
                object = (QVoidMethodCall)qInst;
                if (qOperandBoxArray[0].getOperand() instanceof QVar && (n5 = (Integer)hashMap.get(new Integer(n4 = ((QVar)qOperandBoxArray[0].getOperand()).getRegister()))) != null && this.insts.getInstructionAt(n5) instanceof QAssignment) {
                    QVar qVar = (QVar)((QAssignment)this.insts.getInstructionAt(n5)).getDefined().getOperand();
                    QNew qNew = (QNew)((QAssignment)this.insts.getInstructionAt(n5)).getExpression();
                    this.insts.replaceInstruction(n5, new QNop());
                    this.insts.replaceInstruction(n, new QAssignment(qVar, new QNewInitialized(qNew.getClassConstant(), ((QVoidMethodCall)object).getReferenceConstant(), ((QVoidMethodCall)object).getUses())));
                }
            }
            ++n;
        }
    }

    void simplifyJumps() {
        if (this.insts.size() == 0) {
            return;
        }
        QInst qInst = this.insts.getLastInstruction();
        if (qInst instanceof QAbstractJumpInst) {
            ((QAbstractJumpInst)qInst).simplifyAllJumps();
        }
    }

    public void generate(CodeGeneratorMethod codeGeneratorMethod, BitSet bitSet, int n) {
        CodeGeneratorBasicBlock codeGeneratorBasicBlock = new CodeGeneratorBasicBlock(bitSet, n);
        codeGeneratorBasicBlock.setCurrentBasicBlock(this);
        Iterator iterator = this.getInstructions();
        while (iterator.hasNext()) {
            QInst qInst = (QInst)iterator.next();
            qInst.generateInstructions(codeGeneratorBasicBlock);
        }
        codeGeneratorBasicBlock.stackSchedule();
        codeGeneratorMethod.setCurrentBasicBlock(this);
        this.firstInstGen = codeGeneratorMethod.currentIndex();
        codeGeneratorBasicBlock.generateInstructions(codeGeneratorMethod);
        this.nbGen = codeGeneratorMethod.currentIndex() - this.firstInstGen;
    }

    public void constructQuadruple(Instruction[] instructionArray, QuadrupleGenerator quadrupleGenerator) {
        Object object;
        quadrupleGenerator.setStack(this.entryStack);
        if (this.catchBlock && this.firstInst < 0) {
            quadrupleGenerator.addInitException(this);
        }
        boolean bl = false;
        if (this.firstBlockSubroutine) {
            Instruction instruction = instructionArray[this.firstInst];
            boolean bl2 = false;
            if (instruction instanceof LocalVarInstruction && ((LocalVarInstruction)instruction).isStore()) {
                bl2 = true;
            }
            if (!(bl = bl2)) {
                quadrupleGenerator.addInitSubroutine(this);
            }
        }
        if (this.firstInst >= 0) {
            int n = this.firstInst;
            if (this.catchBlock) {
                quadrupleGenerator.addInitException(this, instructionArray[n++]);
            }
            if (bl) {
                quadrupleGenerator.addInitSubroutine(this, instructionArray[n++]);
            }
            while (n < this.lastInst) {
                if (quadrupleGenerator.generate(instructionArray[n], instructionArray[n + 1], this)) {
                    ++n;
                }
                ++n;
            }
            if (n <= this.lastInst) {
                quadrupleGenerator.generate(instructionArray[this.lastInst], null, this);
                object = instructionArray[this.lastInst];
                if (((Instruction)object).canComplete() && !(object instanceof JumpInstruction) && !(object instanceof SwitchInstruction)) {
                    quadrupleGenerator.addJump(this);
                }
            } else {
                quadrupleGenerator.addJump(this);
            }
        } else {
            quadrupleGenerator.addJump(this);
        }
        QInst qInst = this.removeLastInstruction();
        object = quadrupleGenerator.getStack();
        BasicBlock[] basicBlockArray = this.getNextBasicBlocks();
        int n = 0;
        while (n < basicBlockArray.length) {
            if (basicBlockArray[n].entryStack == null) {
                quadrupleGenerator.initEntryStack(basicBlockArray[n], (QOperand[])object);
            }
            quadrupleGenerator.addVariableConversionInstruction(this, (QOperand[])object, basicBlockArray[n].entryStack);
            ++n;
        }
        this.addInstruction(qInst);
    }

    public BasicBlock(Graph graph) {
        this(-1, -1, graph);
    }

    public BasicBlock(int n, int n2, Graph graph) {
        this.firstInst = n;
        this.lastInst = n2;
        this.entryStack = null;
        this.insts = new QInstArray(this);
        this.phis = new QInstArray(this);
        graph.addNode(this);
    }
}

