/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.IincInstruction;
import at.dms.classfile.Instruction;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.ssa.CodeGenerator;
import java.util.BitSet;
import java.util.Stack;

public class CodeGeneratorBasicBlock
extends CodeGenerator {
    private static final byte NON_USED = 0;
    private static final byte LAST_LOAD = 1;
    private static final byte LAST_STORE = 2;
    protected BitSet out;
    protected int nbLocalVars;
    protected Stack stack;
    protected Inst first;
    protected Inst last;

    public void addInstruction(Instruction instruction) {
        Object object;
        if (instruction instanceof LocalVarInstruction) {
            object = (LocalVarInstruction)instruction;
            if (((LocalVarInstruction)object).isLoad()) {
                Inst inst = new Inst((Instruction)object, (StackElement)this.stack.peek(), this.stack.size());
                this.last.setNext(inst);
                this.last = inst;
                StackElement stackElement = new StackElement(((LocalVarInstruction)object).getIndex(), ((LocalVarInstruction)object).getPushedOnStack());
                this.stack.push(stackElement);
                return;
            }
            if (((LocalVarInstruction)object).isStore()) {
                StackElement stackElement = (StackElement)this.stack.pop();
                stackElement.setRegister(((LocalVarInstruction)object).getIndex());
                Inst inst = new Inst((Instruction)object, stackElement, this.stack.size() + 1);
                this.last.setNext(inst);
                this.last = inst;
                return;
            }
        }
        object = new Inst(instruction, (StackElement)this.stack.peek(), this.stack.size());
        this.last.setNext((Inst)object);
        this.last = object;
        int n = instruction.getPoppedFromStack();
        if (instruction.getOpcode() == 168) {
            n = 0;
        }
        ((Inst)object).minStackHeight = ((Inst)object).stackHeight - n;
        while (n > 0) {
            StackElement stackElement = (StackElement)this.stack.pop();
            n -= stackElement.getSize();
        }
        int n2 = instruction.getPushedOnStack();
        if (n2 > 0) {
            this.stack.push(new StackElement(-1, n2));
        }
    }

    public void generateInstructions(CodeGenerator codeGenerator) {
        Inst inst = this.first;
        while (inst.hasNext()) {
            inst = inst.getNext();
            Instruction instruction = inst.inst;
            if (instruction.getOpcode() == 0) continue;
            if (inst.dead && inst.isStore()) {
                if (inst.stackTop.getSize() == 2) {
                    codeGenerator.addInstruction(new NoArgInstruction(88));
                    continue;
                }
                codeGenerator.addInstruction(new NoArgInstruction(87));
                continue;
            }
            if (inst.inst.getOpcode() == 89 && inst.hasNext() && inst.getNext().dead && inst.getNext().isStore()) {
                inst = inst.getNext();
                continue;
            }
            codeGenerator.addInstruction(instruction);
        }
    }

    public void stackSchedule() {
        Inst inst;
        if (this.first == this.last) {
            return;
        }
        ListUseReuse listUseReuse = new ListUseReuse();
        Object object = this.first.getNext();
        while (object != this.last) {
            if (((Inst)object).isLoad()) {
                int n = ((Inst)object).getIndex();
                int n2 = 1;
                inst = ((Inst)object).getPrev();
                while (inst != this.first) {
                    if (inst.stackTop.sameVariable(n)) {
                        listUseReuse.insertUseReuse(inst, (Inst)object, n2);
                        break;
                    }
                    inst = inst.getPrev();
                    ++n2;
                }
            }
            object = ((Inst)object).getNext();
        }
        object = listUseReuse.getFirst();
        UseReuse useReuse = listUseReuse.getLast();
        while (object != useReuse) {
            int n;
            Inst inst2 = ((UseReuse)object).use;
            inst = ((UseReuse)object).reuse;
            if (inst.isLoad() && inst2.stackTop.sameVariable(n = inst.getIndex()) && inst2.stackHeight == inst.stackHeight + 1) {
                Inst inst3 = inst2;
                if (!(inst3.minStackHeight < inst.stackHeight || inst3.inst instanceof IincInstruction && ((IincInstruction)inst3.inst).getVariable() == n)) {
                    inst3 = inst3.getNext();
                    while (inst3 != inst) {
                        if (inst3.minStackHeight < inst.stackHeight || inst3.isStore() && inst3.getIndex() == n || inst3.inst instanceof IincInstruction && ((IincInstruction)inst3.inst).getVariable() == n || inst3.minStackHeight == inst.stackHeight && inst3.isDup()) break;
                        inst3 = inst3.getNext();
                    }
                }
                if (inst3 == inst) {
                    int n3 = inst2.stackTop.getSize();
                    NoArgInstruction noArgInstruction = n3 == 1 ? new NoArgInstruction(89) : new NoArgInstruction(92);
                    Inst inst4 = new Inst(inst2.inst, inst2.stackTop, inst2.stackHeight + 1);
                    inst2.insertAfter(inst4);
                    inst2.inst = noArgInstruction;
                    inst.inst = new NoArgInstruction(0);
                    inst3 = inst4;
                    while (inst3 != inst) {
                        ++inst3.stackHeight;
                        ++inst3.minStackHeight;
                        inst3 = inst3.getNext();
                    }
                    ++inst.stackHeight;
                    ++inst.minStackHeight;
                    inst.stackTop = inst2.stackTop;
                }
            }
            object = ((UseReuse)object).next;
        }
        this.markDeadInstructions();
    }

    protected void markDeadInstructions() {
        byte[] byArray = new byte[this.nbLocalVars * 2];
        int n = 0;
        while (n < byArray.length) {
            if (this.out.get(n)) {
                byArray[n] = 1;
            }
            ++n;
        }
        Inst inst = this.last;
        while (inst != this.first) {
            int n2;
            if (inst.isLoad()) {
                n2 = inst.getIndex();
                if (byArray[n2] == 0) {
                    inst.dead = true;
                }
                byArray[n2] = 1;
            } else if (inst.isStore()) {
                n2 = inst.getIndex();
                if (byArray[n2] == 2 || byArray[n2] == 0) {
                    inst.dead = true;
                }
            } else if (inst.isRet()) {
                n2 = inst.getIndex();
                byArray[n2] = 1;
            } else if (inst.inst instanceof IincInstruction) {
                n2 = ((IincInstruction)inst.inst).getVariable();
                byArray[n2] = 1;
            }
            inst = inst.getPrev();
        }
    }

    public CodeGeneratorBasicBlock(BitSet bitSet, int n) {
        this.nbLocalVars = n;
        this.out = bitSet;
        this.last = this.first = new Inst(null, new StackElement(-1, 0), 0);
        this.stack = new Stack();
        this.stack.push(new StackElement(-1, 0));
        this.stack.push(new StackElement(-1, 1));
    }

    protected class Inst {
        public Instruction inst;
        public StackElement stackTop;
        public int stackHeight;
        public int minStackHeight;
        public boolean dead;
        protected Inst prev;
        protected Inst next;

        public void setNext(Inst inst) {
            if (inst != null) {
                inst.prev = this;
            }
            this.next = inst;
        }

        public Inst getNext() {
            return this.next;
        }

        public Inst getPrev() {
            return this.prev;
        }

        public void insertBefore(Inst inst) {
            inst.prev = this.prev;
            inst.next = this;
            this.prev.next = inst;
            this.prev = inst;
        }

        public void insertAfter(Inst inst) {
            inst.prev = this;
            inst.next = this.next;
            this.next.prev = inst;
            this.next = inst;
        }

        public boolean hasNext() {
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public boolean isDup() {
            boolean bl = false;
            if (this.inst.getOpcode() == 89 || this.inst.getOpcode() == 92) {
                bl = true;
            }
            return bl;
        }

        public boolean isLoad() {
            boolean bl = false;
            if (this.inst instanceof LocalVarInstruction && ((LocalVarInstruction)this.inst).isLoad()) {
                bl = true;
            }
            return bl;
        }

        public boolean isStore() {
            boolean bl = false;
            if (this.inst instanceof LocalVarInstruction && ((LocalVarInstruction)this.inst).isStore()) {
                bl = true;
            }
            return bl;
        }

        public boolean isRet() {
            boolean bl = false;
            if (this.inst.getOpcode() == 169) {
                bl = true;
            }
            return bl;
        }

        public int getIndex() {
            return ((LocalVarInstruction)this.inst).getIndex();
        }

        public Inst(Instruction instruction, StackElement stackElement, int n) {
            this.inst = instruction;
            this.stackTop = stackElement;
            this.stackHeight = n;
            this.dead = false;
            this.minStackHeight = n;
        }
    }

    protected class StackElement {
        protected int register;
        protected int size;

        public void setRegister(int n) {
            this.register = n;
        }

        public int getRegister() {
            return this.register;
        }

        public int getSize() {
            return this.size;
        }

        public boolean sameVariable(int n) {
            if (this.register == -1) {
                return false;
            }
            boolean bl = false;
            if (n == this.register) {
                bl = true;
            }
            return bl;
        }

        public StackElement(int n, int n2) {
            this.register = n;
            this.size = n2;
        }
    }

    protected class ListUseReuse {
        protected UseReuse first;
        protected UseReuse last;

        public void insertUseReuse(Inst inst, Inst inst2, int n) {
            UseReuse useReuse = this.first;
            while (useReuse.dist < n) {
                useReuse = useReuse.next;
            }
            UseReuse useReuse2 = new UseReuse(inst, inst2, n);
            useReuse.insertBefore(useReuse2);
            if (useReuse == this.first) {
                this.first = useReuse2;
            }
        }

        public UseReuse getFirst() {
            return this.first;
        }

        public UseReuse getLast() {
            return this.last;
        }

        public ListUseReuse() {
            this.last = this.first = new UseReuse();
        }
    }

    protected class UseReuse {
        public Inst use;
        public Inst reuse;
        public int dist;
        public UseReuse prev;
        public UseReuse next;

        public void insertBefore(UseReuse useReuse) {
            useReuse.prev = this.prev;
            useReuse.next = this;
            if (this.prev != null) {
                this.prev.next = useReuse;
            }
            this.prev = useReuse;
        }

        public UseReuse() {
            this(null, null, Integer.MAX_VALUE);
        }

        public UseReuse(Inst inst, Inst inst2, int n) {
            this.use = inst;
            this.reuse = inst2;
            this.dist = n;
        }
    }
}

