/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.InterferenceGraph;
import at.dms.ssa.QVar;
import at.dms.ssa.SSAVar;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Vector;

public class ColorComputer {
    protected InterferenceGraph interference;
    protected Vector ssaVars;
    protected BitSet[] interferenceVarColors;
    protected QVar[] variables;

    public void color() {
        SSAVar sSAVar;
        Iterator iterator = this.ssaVars.iterator();
        while (iterator.hasNext()) {
            sSAVar = (SSAVar)iterator.next();
            if (!sSAVar.isColored()) continue;
            this.setColor(sSAVar, sSAVar.getColor());
        }
        iterator = this.ssaVars.iterator();
        while (iterator.hasNext()) {
            sSAVar = (SSAVar)iterator.next();
            if (sSAVar.isColored()) continue;
            this.setColor(sSAVar, this.findEmptySpace(sSAVar.getUniqueIndex(), sSAVar.getSize()));
        }
        int n = 0;
        while (n < this.ssaVars.size()) {
            SSAVar sSAVar2 = (SSAVar)this.ssaVars.elementAt(n);
            ++n;
        }
    }

    public void setColor(SSAVar sSAVar, int n) {
        sSAVar.setColor(n);
        int n2 = sSAVar.getUniqueIndex();
        if (sSAVar.getSize() == 1) {
            Iterator iterator = this.interference.interfereFor(n2);
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                this.interferenceVarColors[n3].set(n);
            }
        } else {
            Iterator iterator = this.interference.interfereFor(n2);
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                this.interferenceVarColors[n4].set(n);
                this.interferenceVarColors[n4].set(n + 1);
            }
        }
    }

    protected int findEmptySpace(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        BitSet bitSet = this.interferenceVarColors[n];
        int n5 = 0;
        while (n5 < bitSet.size()) {
            if (bitSet.get(n5)) {
                n3 = 0;
            } else {
                if (n3 == 0) {
                    n4 = n5;
                }
                if (++n3 == n2) {
                    return n4;
                }
            }
            ++n5;
        }
        return bitSet.size() - n3;
    }

    public QVar getVariable(SSAVar sSAVar) {
        int n = sSAVar.getUniqueIndex();
        if (this.variables[n] == null || this.variables[n].getType() != sSAVar.getType()) {
            this.variables[n] = new QVar(sSAVar.getColor(), sSAVar.getType());
        }
        return this.variables[n];
    }

    public ColorComputer(InterferenceGraph interferenceGraph) {
        this.interference = interferenceGraph;
        this.ssaVars = SSAVar.getAllSSAVariables();
        this.interferenceVarColors = new BitSet[this.ssaVars.size()];
        int n = 0;
        while (n < this.interferenceVarColors.length) {
            this.interferenceVarColors[n] = new BitSet();
            ++n;
        }
        this.variables = new QVar[this.interferenceVarColors.length];
    }
}

