/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.MethodInfo;
import at.dms.classfile.SwitchInstruction;
import at.dms.ssa.BasicBlock;
import at.dms.ssa.CodeGeneratorMethod;
import at.dms.ssa.ColorComputer;
import at.dms.ssa.CopyPropagation;
import at.dms.ssa.Edge;
import at.dms.ssa.EdgeLabel;
import at.dms.ssa.ExceptionHandler;
import at.dms.ssa.Graph;
import at.dms.ssa.InterferenceGraph;
import at.dms.ssa.LivenessComputer;
import at.dms.ssa.Node;
import at.dms.ssa.NodeVisitor;
import at.dms.ssa.Propagator;
import at.dms.ssa.QDeclareInitialised;
import at.dms.ssa.QInst;
import at.dms.ssa.QOperand;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QSSAVar;
import at.dms.ssa.QVar;
import at.dms.ssa.QuadrupleGenerator;
import at.dms.ssa.SSAConstructor;
import at.dms.ssa.SSADestructor;
import at.dms.ssa.SSAVar;
import at.dms.ssa.SubRoutine;
import at.dms.ssa.UnusedComputer;
import at.dms.util.InconsistencyException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ControlFlowGraph {
    public static final boolean DEBUG = false;
    protected CodeInfo info;
    protected ExceptionHandler[] exceptionHandlers;
    protected Map subroutines;
    protected BasicBlock firstBB;
    protected Graph graph;
    protected BasicBlock start;
    protected BasicBlock end;
    protected int nbVar;

    public void optimize() {
        this.performCopyPropagation();
    }

    public void removeUnusedVariables() {
        UnusedComputer unusedComputer = new UnusedComputer(this.graph.getNodes());
        unusedComputer.removeUnusedVariables();
        unusedComputer.removeUnusefullPhis();
    }

    public void performCopyPropagation() {
        CopyPropagation copyPropagation = new CopyPropagation(this.graph.getNodes());
        copyPropagation.propagate();
    }

    public BitSet findNonLocals() {
        BitSet bitSet = new BitSet(this.nbVar);
        BitSet bitSet2 = new BitSet(this.nbVar);
        BitSet bitSet3 = new BitSet(this.nbVar);
        BasicBlock basicBlock = this.firstBB;
        while (basicBlock != null) {
            bitSet2.and(bitSet3);
            Iterator iterator = basicBlock.getInstructions();
            while (iterator.hasNext()) {
                QOperand qOperand;
                QInst qInst = (QInst)iterator.next();
                QOperandBox[] qOperandBoxArray = qInst.getUses();
                int n = 0;
                while (n < qOperandBoxArray.length) {
                    int n2;
                    QOperand qOperand2 = qOperandBoxArray[n].getOperand();
                    if (qOperand2 instanceof QVar && !bitSet2.get(n2 = ((QVar)qOperand2).getRegister())) {
                        bitSet.set(n2);
                    }
                    ++n;
                }
                if (!qInst.defVar() || !((qOperand = qInst.getDefined().getOperand()) instanceof QVar)) continue;
                int n3 = ((QVar)qOperand).getRegister();
                bitSet2.set(n3);
            }
            basicBlock = basicBlock.getNext();
        }
        return bitSet;
    }

    public Instruction[] getInstructions() {
        LivenessComputer livenessComputer = new LivenessComputer(this.graph, this.start, this.exceptionHandlers);
        InterferenceGraph interferenceGraph = livenessComputer.computeInterferenceGraph();
        ColorComputer colorComputer = new ColorComputer(interferenceGraph);
        colorComputer.color();
        SSADestructor.removeSSAForm(this.graph, this.start, this.exceptionHandlers, colorComputer);
        BasicBlock basicBlock = this.end;
        this.graph.visitGraphFromNode(this.start, new NodeVisitor(this, basicBlock){
            final /* synthetic */ ControlFlowGraph this$0;
            final /* synthetic */ Node val$end;

            public final boolean visit(Node node) {
                if (node != this.val$end) {
                    ((BasicBlock)node).simplifyJumps();
                }
                return true;
            }
            {
                this.this$0 = controlFlowGraph;
                this.val$end = node;
            }
        });
        HashSet hashSet = new HashSet();
        this.graph.visitGraphFromNode(this.start, new NodeVisitor(this, hashSet){
            final /* synthetic */ ControlFlowGraph this$0;
            final /* synthetic */ HashSet val$accessibleBlocks;

            public final boolean visit(Node node) {
                this.val$accessibleBlocks.add(node);
                return true;
            }
            {
                this.this$0 = controlFlowGraph;
                this.val$accessibleBlocks = hashSet;
            }
        });
        BitSet[] bitSetArray = this.firstBB;
        while (bitSetArray != null) {
            if (!hashSet.contains(bitSetArray)) {
                bitSetArray.removeFromList();
            }
            bitSetArray = bitSetArray.getNext();
        }
        this.graph.setNodesIndex();
        livenessComputer = new LivenessComputer(this.graph, this.start, this.exceptionHandlers);
        bitSetArray = new BitSet[this.graph.size()];
        BitSet[] bitSetArray2 = new BitSet[bitSetArray.length];
        int n = 0;
        while (n < bitSetArray.length) {
            bitSetArray[n] = new BitSet();
            bitSetArray2[n] = new BitSet();
            ++n;
        }
        livenessComputer.computeNonSSALivenessAnalysis(bitSetArray, bitSetArray2);
        bitSetArray = null;
        Propagator.propagate(this.firstBB, bitSetArray2);
        CodeGeneratorMethod codeGeneratorMethod = new CodeGeneratorMethod();
        this.start.setNext(this.firstBB);
        this.start.generate(codeGeneratorMethod, bitSetArray2[this.start.getIndex()], this.nbVar);
        this.start.removeFromList();
        Object object = this.firstBB;
        while (object != null) {
            object.generate(codeGeneratorMethod, bitSetArray2[object.getIndex()], this.nbVar);
            object = object.getNext();
        }
        object = codeGeneratorMethod.getInstructions();
        this.findLabelAdresses((Instruction[])object);
        return object;
    }

    public HandlerInfo[] getHandlerInfos(Instruction[] instructionArray) {
        HandlerInfo[] handlerInfoArray = this.info.getHandlers();
        int n = 0;
        while (n < handlerInfoArray.length) {
            HandlerInfo handlerInfo = handlerInfoArray[n];
            ExceptionHandler exceptionHandler = this.exceptionHandlers[n];
            exceptionHandler.searchIndex();
            handlerInfo.setStart(instructionArray[exceptionHandler.getStart()]);
            handlerInfo.setEnd(instructionArray[exceptionHandler.getEnd()]);
            handlerInfo.setHandler(instructionArray[exceptionHandler.getHandle()]);
            ++n;
        }
        return handlerInfoArray;
    }

    private final void findLabelAdresses(Instruction[] instructionArray) {
        AccessorTransformer accessorTransformer = new AccessorTransformer(this, instructionArray){
            final /* synthetic */ ControlFlowGraph this$0;
            final /* synthetic */ Instruction[] val$insts;

            public final InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) {
                Edge edge = ((EdgeLabel)instructionAccessor).getEdge();
                return this.val$insts[((BasicBlock)edge.getTarget()).getStartGen()];
            }
            {
                this.this$0 = controlFlowGraph;
                this.val$insts = instructionArray;
            }
        };
        try {
            int n = 0;
            while (n < instructionArray.length) {
                if (instructionArray[n] instanceof AccessorContainer) {
                    ((AccessorContainer)((Object)instructionArray[n])).transformAccessors(accessorTransformer);
                }
                ++n;
            }
        }
        catch (BadAccessorException badAccessorException) {
            throw new RuntimeException("INTERNAL ERROR");
        }
    }

    private final void constructSSAForm() {
        SSAConstructor sSAConstructor = new SSAConstructor(this.graph, this.start, this.end, this.findNonLocals(), this.exceptionHandlers, this.subroutines.values());
        sSAConstructor.constructSSAForm();
        this.precolorInitVariables();
        this.removeUnusedVariables();
    }

    private final void generateQInsts(Instruction[] instructionArray, MethodInfo methodInfo) {
        this.addInitMethodInstruction(methodInfo);
        QuadrupleGenerator quadrupleGenerator = new QuadrupleGenerator(this.info.getMaxLocals());
        this.graph.visitGraph(this.start, new NodeVisitor(this, instructionArray, quadrupleGenerator){
            final /* synthetic */ ControlFlowGraph this$0;
            final /* synthetic */ Instruction[] val$insts;
            final /* synthetic */ QuadrupleGenerator val$genQ;

            public final boolean visit(Node node) {
                ((BasicBlock)node).constructQuadruple(this.val$insts, this.val$genQ);
                ((BasicBlock)node).simplifyNewInstructions();
                return true;
            }
            {
                this.this$0 = controlFlowGraph;
                this.val$insts = instructionArray;
                this.val$genQ = quadrupleGenerator;
            }
        });
        this.nbVar = quadrupleGenerator.getVarNumber();
    }

    private final void findBasicBlocks() {
        Instruction[] instructionArray = this.info.getInstructions();
        HandlerInfo[] handlerInfoArray = this.info.getHandlers();
        this.initExceptionHandlers(handlerInfoArray, instructionArray);
        short[] sArray = this.markStartblock(instructionArray);
        int n = this.numberBlock(sArray, instructionArray);
        BasicBlock[] basicBlockArray = this.createBB(n, sArray, instructionArray);
        this.firstBB = basicBlockArray[0];
        this.findCFGEdges(instructionArray, sArray, basicBlockArray);
        this.findSubRoutines(sArray, instructionArray, basicBlockArray);
        this.findExceptionBlocks(sArray, instructionArray, basicBlockArray);
        basicBlockArray = null;
        this.addStartEndBlocks();
        this.removeCriticalEdges();
    }

    private final void removeCriticalEdges() {
        BasicBlock basicBlock;
        Object object;
        Object object2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object3 = this.firstBB;
        while (object3 != null) {
            if (((Node)object3).getOutEdgesNumber() > 1) {
                object2 = ((Node)object3).getOutEdges();
                while (object2.hasNext()) {
                    object = (Edge)object2.next();
                    basicBlock = (BasicBlock)object.getTarget();
                    if (basicBlock.getInEdgesNumber() <= 1 || basicBlock.isFirstBlockSubroutine() || basicBlock.isCatchBlock()) continue;
                    linkedList.addLast(object);
                }
            }
            object3 = ((BasicBlock)object3).getNext();
        }
        while (!linkedList.isEmpty()) {
            object3 = (Edge)linkedList.removeFirst();
            object2 = (BasicBlock)object3.getSource();
            object = (BasicBlock)object3.getTarget();
            if (((Node)object2).getOutEdgesNumber() <= 1 || ((Node)object).getInEdgesNumber() <= 1) continue;
            basicBlock = new BasicBlock(this.graph);
            object3.getSource().changeEdgeTarget((Edge)object3, basicBlock);
            basicBlock.addDefaultNextBlock((BasicBlock)object);
            ((BasicBlock)object).insertBefore(basicBlock);
            int n = 0;
            while (n < this.exceptionHandlers.length) {
                if (this.exceptionHandlers[n].contains((BasicBlock)object)) {
                    this.exceptionHandlers[n].addProtectedBlock(basicBlock);
                    basicBlock.addExceptionNextBlock((BasicBlock)object);
                }
                ++n;
            }
        }
    }

    private final void addStartEndBlocks() {
        this.start = new BasicBlock(this.graph);
        this.end = new BasicBlock(this.graph);
        this.start.addDefaultNextBlock(this.firstBB);
        this.start.addCFGNextBlock(this.end);
        int n = 0;
        BasicBlock basicBlock = this.firstBB;
        while (basicBlock != null) {
            if (!basicBlock.hasSuccessor()) {
                ++n;
                basicBlock.addCFGNextBlock(this.end);
            }
            basicBlock = basicBlock.getNext();
        }
    }

    private final void initExceptionHandlers(HandlerInfo[] handlerInfoArray, Instruction[] instructionArray) {
        this.exceptionHandlers = new ExceptionHandler[handlerInfoArray.length];
        int n = 0;
        while (n < handlerInfoArray.length) {
            int n2 = this.getInstructionLine(instructionArray, handlerInfoArray[n].getStart());
            int n3 = this.getInstructionLine(instructionArray, handlerInfoArray[n].getEnd());
            int n4 = this.getInstructionLine(instructionArray, handlerInfoArray[n].getHandler());
            this.exceptionHandlers[n] = new ExceptionHandler(n2, n3, n4);
            ++n;
        }
    }

    private final int getInstructionLine(Instruction[] instructionArray, InstructionAccessor instructionAccessor) {
        int n = 0;
        while (n < instructionArray.length && instructionAccessor != instructionArray[n]) {
            ++n;
        }
        return n;
    }

    private final short[] markStartblock(Instruction[] instructionArray) {
        int n = instructionArray.length;
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            Instruction instruction;
            if (instructionArray[n2] instanceof JumpInstruction) {
                if (n2 + 1 < n) {
                    sArray[n2 + 1] = 1;
                }
                instruction = (JumpInstruction)instructionArray[n2];
                sArray[this.getInstructionLine((Instruction[])instructionArray, (InstructionAccessor)((JumpInstruction)instruction).getTarget())] = 1;
            }
            if (instructionArray[n2] instanceof SwitchInstruction) {
                instruction = (SwitchInstruction)instructionArray[n2];
                int n3 = -1;
                while (n3 < ((SwitchInstruction)instruction).getSwitchCount()) {
                    sArray[this.getInstructionLine((Instruction[])instructionArray, (InstructionAccessor)((SwitchInstruction)instruction).getTarget((int)n3))] = 1;
                    ++n3;
                }
            }
            if (!instructionArray[n2].canComplete() && n2 + 1 < n) {
                sArray[n2 + 1] = 1;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.exceptionHandlers.length) {
            sArray[this.exceptionHandlers[n2].getStart()] = 1;
            int n4 = this.exceptionHandlers[n2].getEnd() + 1;
            if (n4 < n) {
                sArray[n4] = 1;
            }
            sArray[this.exceptionHandlers[n2].getHandle()] = 1;
            ++n2;
        }
        return sArray;
    }

    private final int numberBlock(short[] sArray, Instruction[] instructionArray) {
        short s = 0;
        if (sArray.length == 0) {
            return 0;
        }
        sArray[0] = s;
        int n = 1;
        while (n < instructionArray.length) {
            if (sArray[n] == 1) {
                s = (short)(s + 1);
            }
            sArray[n] = s;
            ++n;
        }
        return s + 1;
    }

    private final BasicBlock[] createBB(int n, short[] sArray, Instruction[] instructionArray) {
        BasicBlock[] basicBlockArray = new BasicBlock[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2;
            while (n2 < sArray.length && sArray[n2] == n3) {
                ++n2;
            }
            int n5 = n2 - 1;
            basicBlockArray[n3] = new BasicBlock(n4, n5, this.graph);
            if (n3 > 0) {
                basicBlockArray[n3 - 1].setNext(basicBlockArray[n3]);
            }
            ++n3;
        }
        return basicBlockArray;
    }

    private final void findCFGEdges(Instruction[] instructionArray, short[] sArray, BasicBlock[] basicBlockArray) {
        int n = 0;
        while (n < basicBlockArray.length) {
            Object object;
            BasicBlock basicBlock = basicBlockArray[n];
            Instruction instruction = instructionArray[basicBlock.getEnd()];
            if (instruction.canComplete() && n != basicBlockArray.length - 1) {
                basicBlock.addDefaultNextBlock(basicBlockArray[n + 1]);
            }
            if (instruction instanceof JumpInstruction) {
                JumpInstruction jumpInstruction = (JumpInstruction)instruction;
                if (instruction.getOpcode() == 167) {
                    object = basicBlock.addDefaultNextBlock(basicBlockArray[sArray[this.getInstructionLine(instructionArray, jumpInstruction.getTarget())]]);
                    jumpInstruction.setTarget(new EdgeLabel((Edge)object));
                } else if (instruction.getOpcode() != 168) {
                    object = basicBlock.addConditionNextBlock(basicBlockArray[sArray[this.getInstructionLine(instructionArray, jumpInstruction.getTarget())]]);
                    jumpInstruction.setTarget(new EdgeLabel((Edge)object));
                }
            }
            if (instruction instanceof SwitchInstruction) {
                object = (SwitchInstruction)instruction;
                int n2 = -1;
                while (n2 < ((SwitchInstruction)object).getSwitchCount()) {
                    Edge edge = basicBlock.addSwitchNextBlock(basicBlockArray[sArray[this.getInstructionLine(instructionArray, ((SwitchInstruction)object).getTarget(n2))]]);
                    ((SwitchInstruction)object).setTarget(n2, new EdgeLabel(edge));
                    ++n2;
                }
            }
            ++n;
        }
    }

    private final void findExceptionBlocks(short[] sArray, Instruction[] instructionArray, BasicBlock[] basicBlockArray) {
        ExceptionHandler exceptionHandler;
        boolean[] blArray = new boolean[basicBlockArray.length];
        int n = 0;
        while (n < this.exceptionHandlers.length) {
            exceptionHandler = this.exceptionHandlers[n];
            short s = sArray[exceptionHandler.getHandle()];
            BasicBlock basicBlock = basicBlockArray[s];
            if (!blArray[s]) {
                BasicBlock basicBlock2;
                Instruction instruction = instructionArray[basicBlock.getStart()];
                if (instruction instanceof LocalVarInstruction && ((LocalVarInstruction)instruction).isStore()) {
                    int n2 = basicBlock.getStart();
                    basicBlock2 = new BasicBlock(n2, n2, this.graph);
                    basicBlock.setStart(n2 + 1);
                } else {
                    basicBlock2 = new BasicBlock(this.graph);
                }
                basicBlock2.setCatchBlock(true);
                basicBlock.insertBefore(basicBlock2);
                basicBlock2.addDefaultNextBlock(basicBlock);
                basicBlockArray[s] = basicBlock2;
                basicBlock = basicBlock2;
                blArray[s] = true;
            }
            exceptionHandler.setHandlerBlock(basicBlock);
            ++n;
        }
        n = 0;
        while (n < this.exceptionHandlers.length) {
            Object object;
            BasicBlock basicBlock;
            exceptionHandler = this.exceptionHandlers[n];
            BasicBlock basicBlock3 = exceptionHandler.getHandlerBlock();
            int n3 = exceptionHandler.getStart();
            int n4 = exceptionHandler.getEnd();
            short s = -1;
            if (n3 <= n4 && basicBlock3 != (basicBlock = basicBlockArray[sArray[n3]])) {
                object = basicBlock.getPredecessors();
                while (object.hasNext()) {
                    BasicBlock basicBlock4 = (BasicBlock)object.next();
                    basicBlock4.addExceptionNextBlock(basicBlock3);
                }
            }
            s = -1;
            while (n3 <= n4) {
                if (sArray[n3] != s) {
                    s = sArray[n3];
                    BasicBlock basicBlock5 = basicBlockArray[s];
                    exceptionHandler.addProtectedBlock(basicBlock5);
                    basicBlock5.addExceptionNextBlock(basicBlock3);
                    if (blArray[s]) {
                        object = basicBlock5.getNext();
                        exceptionHandler.addProtectedBlock((BasicBlock)object);
                        ((BasicBlock)object).addExceptionNextBlock(basicBlock3);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public void findSubRoutines(short[] sArray, Instruction[] instructionArray, BasicBlock[] basicBlockArray) {
        BasicBlock basicBlock;
        Object object;
        Instruction instruction;
        int n = 0;
        while (n < basicBlockArray.length) {
            instruction = instructionArray[basicBlockArray[n].getEnd()];
            if (instruction.getOpcode() == 168) {
                Object object2;
                Object object3;
                object = (JumpInstruction)instruction;
                basicBlock = basicBlockArray[n];
                BasicBlock basicBlock2 = basicBlockArray[n + 1];
                BasicBlock basicBlock3 = basicBlockArray[sArray[this.getInstructionLine(instructionArray, ((JumpInstruction)object).getTarget())]];
                SubRoutine subRoutine = (SubRoutine)this.subroutines.get(basicBlock3);
                if (subRoutine == null) {
                    basicBlock3.setFirstBlockSubroutine(true);
                    object3 = this.subroutines;
                    object2 = basicBlock3;
                    this.graph.visitGraphFromNode((Node)object2, new NodeVisitor(this, instructionArray, basicBlock3, (BasicBlock)object2, (Map)object3){
                        final /* synthetic */ ControlFlowGraph this$0;
                        final /* synthetic */ Instruction[] val$insts;
                        final /* synthetic */ BasicBlock val$startSubroutine;
                        final /* synthetic */ BasicBlock val$currentBB;
                        final /* synthetic */ Map val$subs;

                        public final boolean visit(Node node) {
                            BasicBlock basicBlock = (BasicBlock)node;
                            Instruction instruction = this.val$insts[basicBlock.getEnd()];
                            if (instruction.getOpcode() == 169) {
                                SubRoutine subRoutine = new SubRoutine(this.val$startSubroutine, this.val$currentBB);
                                this.val$subs.put(this.val$startSubroutine, subRoutine);
                                return false;
                            }
                            return true;
                        }
                        {
                            this.this$0 = controlFlowGraph;
                            this.val$insts = instructionArray;
                            this.val$startSubroutine = basicBlock;
                            this.val$currentBB = basicBlock2;
                            this.val$subs = map;
                        }
                    });
                    subRoutine = (SubRoutine)this.subroutines.get(basicBlock3);
                    if (subRoutine == null) {
                        throw new RuntimeException("NO RETURN TO SUBROUTINE");
                    }
                }
                object3 = basicBlock.addSubRoutineCallNextBlock(basicBlock3);
                ((JumpInstruction)object).setTarget(new EdgeLabel((Edge)object3));
                object2 = subRoutine.getEnd().addSubRoutineReturnNextBlock(basicBlock2);
                subRoutine.addCall((Edge)object3, (Edge)object2);
            }
            ++n;
        }
        n = 0;
        while (n < basicBlockArray.length) {
            instruction = instructionArray[basicBlockArray[n].getEnd()];
            if (instruction.getOpcode() == 168) {
                object = basicBlockArray[n];
                basicBlock = basicBlockArray[n + 1];
                ((Node)object).removeSuccessor(basicBlock);
            }
            ++n;
        }
    }

    private final void addInitMethodInstruction(MethodInfo methodInfo) {
        String string = methodInfo.getSignature();
        int n = 0;
        if ((methodInfo.getModifiers() & 8) == 0) {
            this.start.addInstruction(new QDeclareInitialised(new QVar(n, 6), false));
            ++n;
        }
        if (string.charAt(0) != '(') {
            throw new InconsistencyException("invalid signature " + string);
        }
        int n2 = 1;
        block9: while (true) {
            switch (string.charAt(n2++)) {
                case ')': {
                    break block9;
                }
                case '[': {
                    while (string.charAt(n2) == '[') {
                        ++n2;
                    }
                    if (string.charAt(n2) == 'L') {
                        while (string.charAt(n2) != ';') {
                            ++n2;
                        }
                    }
                    ++n2;
                    this.start.addInstruction(new QDeclareInitialised(new QVar(n, 6), false));
                    ++n;
                    break;
                }
                case 'L': {
                    while (string.charAt(n2) != ';') {
                        ++n2;
                    }
                    ++n2;
                    this.start.addInstruction(new QDeclareInitialised(new QVar(n, 6), false));
                    ++n;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.start.addInstruction(new QDeclareInitialised(new QVar(n, 4), false));
                    ++n;
                    break;
                }
                case 'F': {
                    this.start.addInstruction(new QDeclareInitialised(new QVar(n, 3), false));
                    ++n;
                    break;
                }
                case 'D': {
                    this.start.addInstruction(new QDeclareInitialised(new QVar(n, 2), false));
                    n += 2;
                    break;
                }
                case 'J': {
                    this.start.addInstruction(new QDeclareInitialised(new QVar(n, 5), false));
                    n += 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid signature " + string);
                }
            }
        }
    }

    protected void precolorInitVariables() {
        Iterator iterator = this.start.getInstructions();
        while (iterator.hasNext()) {
            QOperand qOperand;
            QInst qInst = (QInst)iterator.next();
            if (!(qInst instanceof QDeclareInitialised) || !((qOperand = qInst.getDefined().getOperand()) instanceof QSSAVar)) continue;
            SSAVar sSAVar = ((QSSAVar)qOperand).getSSAVar();
            sSAVar.setColor(sSAVar.getSourceIndex());
        }
    }

    public ControlFlowGraph(MethodInfo methodInfo, CodeInfo codeInfo) {
        this.info = codeInfo;
        this.graph = new Graph();
        this.subroutines = new HashMap();
        this.findBasicBlocks();
        this.generateQInsts(codeInfo.getInstructions(), methodInfo);
        this.constructSSAForm();
        this.optimize();
    }
}

