/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.DominatorTreeNode;
import at.dms.ssa.Node;
import at.dms.ssa.TreeEdge;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DominatorComputer {
    protected Node[] nodes;
    protected HashMap map;
    protected int[] label;
    protected int[] parent;
    protected int[] ancestor;
    protected int[] child;
    protected int[] ndfs;
    protected int[] sdno;
    protected int[] size;
    protected int n0;
    protected int n;
    protected Set[] bucket;
    protected int[] idom;
    protected DominatorTreeNode treeRoot;
    protected DominatorTreeNode[] treeNodes;
    protected Set[] domFront;

    public int[] getIDom() {
        return this.idom;
    }

    public int[] postOrder() {
        this.n = 0;
        int[] nArray = new int[this.nodes.length];
        this.depthFirstDominatorTree(this.treeRoot, nArray, true);
        return nArray;
    }

    public int[] preOrder() {
        this.n = 0;
        int[] nArray = new int[this.nodes.length];
        this.depthFirstDominatorTree(this.treeRoot, nArray, false);
        return nArray;
    }

    public Set getDF(int n) {
        return this.domFront[n];
    }

    public Set getDFPlus(Set set) {
        boolean bl = true;
        Set set2 = this.getDFSet(set);
        while (bl) {
            bl = false;
            HashSet hashSet = new HashSet();
            hashSet.addAll(set);
            hashSet.addAll(set2);
            Set set3 = this.getDFSet(hashSet);
            if (set3.equals(set2)) continue;
            set2 = set3;
            bl = true;
        }
        return set2;
    }

    public DominatorTreeNode getTreeRoot() {
        return this.treeRoot;
    }

    private final void computeDomFront() {
        this.domFront = new HashSet[this.nodes.length];
        int n = 0;
        while (n < this.domFront.length) {
            this.domFront[n] = new HashSet();
            ++n;
        }
        int[] nArray = this.postOrder();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            int n4 = nArray[n2];
            Iterator iterator = this.nodes[n4].getSuccessors();
            while (iterator.hasNext()) {
                n3 = this.getNodeIndex((Node)iterator.next());
                if (this.treeNodes[n4].hasChildIndex(n3)) continue;
                this.domFront[n4].add(new Integer(n3));
            }
            iterator = this.treeNodes[n4].getSuccessors();
            while (iterator.hasNext()) {
                n3 = ((DominatorTreeNode)iterator.next()).getIndex();
                Iterator iterator2 = this.domFront[n3].iterator();
                while (iterator2.hasNext()) {
                    int n5 = (Integer)iterator2.next();
                    if (this.treeNodes[n4].hasChildIndex(n5)) continue;
                    this.domFront[n4].add(new Integer(n5));
                }
            }
            ++n2;
        }
    }

    private final Set getDFSet(Set set) {
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            hashSet.addAll(this.domFront[n]);
        }
        return hashSet;
    }

    private final void depthFirstSearchDom(int n) {
        this.sdno[n] = ++this.n;
        this.ndfs[this.n] = n;
        this.label[n] = n;
        this.ancestor[n] = this.n0;
        this.child[n] = this.n0;
        this.size[n] = 1;
        Iterator iterator = this.nodes[n].getSuccessors();
        while (iterator.hasNext()) {
            int n2 = this.getNodeIndex((Node)iterator.next());
            if (this.sdno[n2] != 0) continue;
            this.parent[n2] = n;
            this.depthFirstSearchDom(n2);
        }
    }

    private final void depthFirstDominatorTree(DominatorTreeNode dominatorTreeNode, int[] nArray, boolean bl) {
        if (!bl) {
            nArray[this.n++] = dominatorTreeNode.getIndex();
        }
        Iterator iterator = dominatorTreeNode.getSuccessors();
        while (iterator.hasNext()) {
            DominatorTreeNode dominatorTreeNode2 = (DominatorTreeNode)iterator.next();
            this.depthFirstDominatorTree(dominatorTreeNode2, nArray, bl);
        }
        if (bl) {
            nArray[this.n++] = dominatorTreeNode.getIndex();
        }
    }

    private final int eval(int n) {
        if (this.ancestor[n] == this.n0) {
            return this.label[n];
        }
        this.compress(n);
        if (this.sdno[this.label[this.ancestor[n]]] >= this.sdno[this.label[n]]) {
            return this.label[n];
        }
        return this.label[this.ancestor[n]];
    }

    private final void compress(int n) {
        if (this.ancestor[this.ancestor[n]] != this.n0) {
            this.compress(this.ancestor[n]);
            if (this.sdno[this.label[this.ancestor[n]]] < this.sdno[this.label[n]]) {
                this.label[n] = this.label[this.ancestor[n]];
            }
            this.ancestor[n] = this.ancestor[this.ancestor[n]];
        }
    }

    private final int getNodeIndex(Node node) {
        return node.getIndex();
    }

    private final void link(int n, int n2) {
        int n3 = n2;
        while (this.sdno[this.label[n2]] < this.sdno[this.label[this.child[n3]]]) {
            if (this.size[n3] + this.size[this.child[this.child[n3]]] >= 2 * this.size[this.child[n3]]) {
                this.ancestor[this.child[n3]] = n3;
                this.child[n3] = this.child[this.child[n3]];
                continue;
            }
            this.size[this.child[n3]] = this.size[n3];
            n3 = this.ancestor[n3] = this.child[n3];
        }
        this.label[n3] = this.label[n2];
        int n4 = n;
        this.size[n4] = this.size[n4] + this.size[n2];
        if (this.size[n] < 2 * this.size[n2]) {
            int n5 = n3;
            n3 = this.child[n];
            this.child[n] = n5;
        }
        while (n3 != this.n0) {
            this.ancestor[n3] = n;
            n3 = this.child[n3];
        }
    }

    public DominatorComputer(Node[] nodeArray, Node node) {
        int n;
        this.nodes = nodeArray;
        this.n0 = nodeArray.length;
        this.label = new int[this.n0 + 1];
        this.parent = new int[this.n0 + 1];
        this.ancestor = new int[this.n0 + 1];
        this.child = new int[this.n0 + 1];
        this.ndfs = new int[this.n0 + 1];
        this.sdno = new int[this.n0 + 1];
        this.size = new int[this.n0 + 1];
        this.bucket = new Set[this.n0 + 1];
        this.idom = new int[this.n0 + 1];
        int n2 = 0;
        while (n2 < this.n0 + 1) {
            this.bucket[n2] = new HashSet();
            ++n2;
        }
        this.ancestor[this.n0] = this.n0;
        this.label[this.n0] = this.n0;
        this.n = 0;
        this.depthFirstSearchDom(this.getNodeIndex(node));
        n2 = this.n;
        while (n2 >= 1) {
            int n3;
            n = this.ndfs[n2];
            Iterator iterator = nodeArray[n].getPredecessors();
            while (iterator.hasNext()) {
                int n4 = this.getNodeIndex((Node)iterator.next());
                n3 = this.eval(n4);
                if (this.sdno[n3] >= this.sdno[n]) continue;
                this.sdno[n] = this.sdno[n3];
            }
            this.bucket[this.ndfs[this.sdno[n]]].add(new Integer(n));
            this.link(this.parent[n], n);
            Iterator iterator2 = this.bucket[this.parent[n]].iterator();
            while (iterator2.hasNext()) {
                n3 = (Integer)iterator2.next();
                iterator2.remove();
                int n5 = this.eval(n3);
                this.idom[n3] = this.sdno[n5] < this.sdno[n3] ? n5 : this.parent[n];
            }
            --n2;
        }
        n2 = 1;
        while (n2 <= this.n) {
            n = this.ndfs[n2];
            if (this.idom[n] != this.ndfs[this.sdno[n]]) {
                this.idom[n] = this.idom[this.idom[n]];
            }
            ++n2;
        }
        this.label = null;
        this.parent = null;
        this.ancestor = null;
        this.child = null;
        this.ndfs = null;
        this.sdno = null;
        this.size = null;
        this.bucket = null;
        this.treeNodes = new DominatorTreeNode[nodeArray.length];
        n2 = 0;
        while (n2 < this.treeNodes.length) {
            this.treeNodes[n2] = new DominatorTreeNode(n2, nodeArray[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.idom.length - 1) {
            if (this.idom[n2] != this.n0 && this.idom[n2] != n2) {
                this.treeNodes[this.idom[n2]].addSuccessor(new TreeEdge(), this.treeNodes[n2]);
            }
            ++n2;
        }
        this.treeRoot = this.treeNodes[this.getNodeIndex(node)];
        this.computeDomFront();
    }
}

