/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.Node;
import at.dms.ssa.NodeVisitor;
import java.util.Iterator;
import java.util.Vector;

public class Graph {
    protected Vector nodes = new Vector();

    public void addNode(Node node) {
        this.nodes.addElement(node);
    }

    public void removeNode(Node node) {
        this.nodes.removeElement(node);
    }

    public Node[] getNodes() {
        Node[] nodeArray = new Node[this.nodes.size()];
        this.nodes.toArray(nodeArray);
        return nodeArray;
    }

    public void setNodesIndex() {
        int n = 0;
        while (n < this.nodes.size()) {
            ((Node)this.nodes.elementAt(n)).setIndex(n);
            ++n;
        }
    }

    public void visitGraph(Node node, NodeVisitor nodeVisitor) {
        Node node2;
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            node2.setMarked(false);
        }
        this.visitNode(node, nodeVisitor);
        iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            if (node2.getMarked()) continue;
            this.visitNode(node2, nodeVisitor);
        }
    }

    public void visitGraphFromNode(Node node, NodeVisitor nodeVisitor) {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            node2.setMarked(false);
        }
        this.visitNode(node, nodeVisitor);
    }

    private final boolean visitNode(Node node, NodeVisitor nodeVisitor) {
        node.setMarked(true);
        if (!nodeVisitor.visit(node)) {
            return false;
        }
        Iterator iterator = node.getSuccessors();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node2.getMarked() || this.visitNode(node2, nodeVisitor)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.nodes.size();
    }
}

