/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.BasicBlock;
import at.dms.ssa.ExceptionHandler;
import at.dms.ssa.Graph;
import at.dms.ssa.InterferenceGraph;
import at.dms.ssa.Node;
import at.dms.ssa.QAssignment;
import at.dms.ssa.QInst;
import at.dms.ssa.QInstArray;
import at.dms.ssa.QOperand;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QPhi;
import at.dms.ssa.QPhiCatch;
import at.dms.ssa.QPhiJoin;
import at.dms.ssa.QSSAVar;
import at.dms.ssa.QSimpleExpression;
import at.dms.ssa.QVar;
import at.dms.ssa.SSAVar;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Vector;

public class LivenessComputer {
    protected Graph graph;
    protected int num;
    protected BasicBlock start;
    protected Node[] nodes;
    protected int[] topologicalOrder;
    protected ExceptionHandler[] exceptionHandlers;

    public InterferenceGraph computeInterferenceGraph() {
        Object object;
        Object object2;
        QOperandBox[] qOperandBoxArray;
        int n = this.nodes.length;
        BitSet[] bitSetArray = new BitSet[n];
        BitSet[] bitSetArray2 = new BitSet[n];
        int n2 = 0;
        while (n2 < n) {
            bitSetArray[n2] = new BitSet();
            bitSetArray2[n2] = new BitSet();
            ++n2;
        }
        this.computeSSALivenessAnalysis(bitSetArray, bitSetArray2);
        InterferenceGraph interferenceGraph = new InterferenceGraph(SSAVar.getSSAVariableNumber());
        BitSet bitSet = new BitSet();
        int n3 = 0;
        while (n3 < n) {
            int n4;
            QOperand qOperand;
            Object object3;
            Object object4;
            QOperandBox[] qOperandBoxArray2;
            Object object5;
            BasicBlock basicBlock = (BasicBlock)this.nodes[n3];
            Object object6 = bitSetArray2[n3];
            qOperandBoxArray = new Vector();
            this.addPhiCatch(basicBlock, (Vector)qOperandBoxArray);
            object2 = object6;
            Iterator iterator = basicBlock.getSuccessors();
            while (iterator.hasNext()) {
                object5 = (BasicBlock)iterator.next();
                object = ((BasicBlock)object5).getPhisArray();
                int n5 = ((QInstArray)object).size() - 1;
                while (n5 >= 0) {
                    qOperandBoxArray2 = (QOperandBox[])((QInstArray)object).getInstructionAt(n5);
                    if (qOperandBoxArray2 instanceof QPhiJoin && ((QPhiJoin)(object4 = (QPhiJoin)qOperandBoxArray2)).hasOperandForBlock(basicBlock)) {
                        object3 = ((QPhiJoin)object4).getOperandForBlock(basicBlock).getOperand();
                        qOperand = ((QPhi)object4).getTarget();
                        if (qOperand instanceof QSSAVar && object3 instanceof QSSAVar) {
                            int n6 = ((QSSAVar)qOperand).getUniqueIndex();
                            n4 = ((QSSAVar)object3).getUniqueIndex();
                            object6 = object2;
                            object2 = (BitSet)((BitSet)object6).clone();
                            ((BitSet)object2).clear(n6);
                            ((BitSet)object2).set(n4);
                            boolean bl = false;
                            if (((BitSet)object6).get(n4)) {
                                bl = true;
                                ((BitSet)object6).clear(n4);
                            }
                            interferenceGraph.addInterference(n6, (BitSet)object6);
                            if (bl) {
                                ((BitSet)object6).set(n4);
                            }
                        }
                    }
                    --n5;
                }
            }
            object5 = basicBlock.getInstructionsArray();
            int n7 = ((QInstArray)object5).size() - 1;
            while (n7 >= 0) {
                QInst qInst = ((QInstArray)object5).getInstructionAt(n7);
                object6 = object2;
                object2 = (BitSet)((BitSet)object6).clone();
                if (qInst.defVar() && qInst.getDefined().getOperand() instanceof QSSAVar) {
                    ((BitSet)object2).clear(((QSSAVar)qInst.getDefined().getOperand()).getUniqueIndex());
                }
                qOperandBoxArray2 = qInst.getUses();
                int n8 = 0;
                while (n8 < qOperandBoxArray2.length) {
                    if (qOperandBoxArray2[n8].getOperand() instanceof QSSAVar) {
                        ((BitSet)object2).set(((QSSAVar)qOperandBoxArray2[n8].getOperand()).getUniqueIndex());
                    }
                    ++n8;
                }
                n8 = 0;
                int n9 = 0;
                int n10 = 0;
                if (qInst.defVar() && qInst.getDefined().getOperand() instanceof QSSAVar) {
                    n10 = ((QSSAVar)qInst.getDefined().getOperand()).getUniqueIndex();
                    if (qInst instanceof QAssignment && ((QAssignment)qInst).getExpression() instanceof QSimpleExpression && qInst.getUses()[0].getOperand() instanceof QSSAVar && ((BitSet)object6).get(n9 = ((QSSAVar)qInst.getUses()[0].getOperand()).getUniqueIndex())) {
                        n8 = 1;
                        ((BitSet)object6).clear(n9);
                    }
                    interferenceGraph.addInterference(n10, (BitSet)object6);
                    if (n8 != 0) {
                        ((BitSet)object6).set(n9);
                    }
                    Iterator iterator2 = qOperandBoxArray.iterator();
                    block6: while (iterator2.hasNext()) {
                        QPhiCatch qPhiCatch = (QPhiCatch)iterator2.next();
                        if (!(qPhiCatch.getTarget() instanceof QSSAVar)) continue;
                        QSSAVar qSSAVar = (QSSAVar)qPhiCatch.getTarget();
                        qOperandBoxArray2 = qPhiCatch.getUses();
                        int n11 = 0;
                        while (n11 < qOperandBoxArray2.length) {
                            if (qOperandBoxArray2[n11].getOperand() instanceof QSSAVar && ((QSSAVar)qOperandBoxArray2[n11].getOperand()).getUniqueIndex() == n10) continue block6;
                            ++n11;
                        }
                        interferenceGraph.addInterference(n10, qSSAVar.getUniqueIndex());
                    }
                }
                --n7;
            }
            object6 = object2;
            object = basicBlock.getPhis();
            while (object.hasNext()) {
                QPhi qPhi = (QPhi)object.next();
                if (!(qPhi instanceof QPhiCatch) || !(qPhi.getTarget() instanceof QSSAVar)) continue;
                int n12 = ((QSSAVar)qPhi.getTarget()).getUniqueIndex();
                interferenceGraph.addInterference(n12, (BitSet)object6);
                object4 = qOperandBoxArray.iterator();
                block9: while (object4.hasNext()) {
                    object3 = (QPhiCatch)object4.next();
                    if (!(((QPhi)object3).getTarget() instanceof QSSAVar)) continue;
                    qOperand = (QSSAVar)((QPhi)object3).getTarget();
                    QOperandBox[] qOperandBoxArray3 = ((QPhiCatch)object3).getUses();
                    n4 = 0;
                    while (n4 < qOperandBoxArray3.length) {
                        if (qOperandBoxArray3[n4].getOperand() instanceof QSSAVar && ((QSSAVar)qOperandBoxArray3[n4].getOperand()).getUniqueIndex() == n12) continue block9;
                        ++n4;
                    }
                    interferenceGraph.addInterference(n12, ((QSSAVar)qOperand).getUniqueIndex());
                }
            }
            ++n3;
        }
        Vector vector = new Vector();
        int n13 = 0;
        while (n13 < n) {
            object2 = (BasicBlock)this.nodes[n13];
            this.addPhiCatchFrom((BasicBlock)object2, vector);
            ++n13;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object2 = (QPhiCatch)iterator.next();
            if (!(((QPhi)object2).getTarget() instanceof QSSAVar)) continue;
            int n14 = ((QSSAVar)((QPhi)object2).getTarget()).getUniqueIndex();
            qOperandBoxArray = ((QPhiCatch)object2).getUses();
            int n15 = 0;
            while (n15 < qOperandBoxArray.length) {
                if (qOperandBoxArray[n15].getOperand() instanceof QSSAVar) {
                    int n16 = ((QSSAVar)qOperandBoxArray[n15].getOperand()).getUniqueIndex();
                    object = interferenceGraph.interfereFor(n16);
                    while (object.hasNext()) {
                        int n17 = (Integer)object.next();
                        if (n17 == n16) continue;
                        interferenceGraph.addInterference(n14, n17);
                    }
                }
                ++n15;
            }
        }
        return interferenceGraph;
    }

    protected void computeSSALivenessAnalysis(BitSet[] bitSetArray, BitSet[] bitSetArray2) {
        Object object;
        Object object2;
        Object object3;
        BitSet bitSet;
        BitSet bitSet2;
        int n = this.nodes.length;
        BitSet[] bitSetArray3 = new BitSet[n];
        BitSet[] bitSetArray4 = new BitSet[n];
        int n2 = 0;
        while (n2 < n) {
            bitSetArray3[n2] = new BitSet();
            bitSetArray4[n2] = new BitSet();
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3;
            BasicBlock basicBlock = (BasicBlock)this.nodes[n2];
            BitSet bitSet3 = bitSetArray3[n2];
            bitSet2 = bitSetArray4[n2];
            bitSet = new BitSet();
            object3 = basicBlock.getPhis();
            while (object3.hasNext()) {
                object2 = (QPhi)object3.next();
                if (!(object2 instanceof QPhiCatch)) continue;
                int n4 = 0;
                while (n4 < bitSet.size()) {
                    bitSet.clear(n4);
                    ++n4;
                }
                object = ((QPhi)object2).getUses();
                int n5 = 0;
                while (n5 < ((Object)object).length) {
                    if (((QOperandBox)object[n5]).getOperand() instanceof QSSAVar && !bitSet3.get(n3 = ((QSSAVar)((QOperandBox)object[n5]).getOperand()).getUniqueIndex())) {
                        bitSet.set(n3);
                    }
                    ++n5;
                }
                bitSet2.or(bitSet);
                if (!(((QPhi)object2).getTarget() instanceof QSSAVar)) continue;
                bitSet3.set(((QSSAVar)((QPhi)object2).getTarget()).getUniqueIndex());
            }
            object2 = basicBlock.getInstructions();
            while (object2.hasNext()) {
                int n6 = 0;
                while (n6 < bitSet.size()) {
                    bitSet.clear(n6);
                    ++n6;
                }
                object = (QInst)object2.next();
                QOperandBox[] qOperandBoxArray = ((QInst)object).getUses();
                n3 = 0;
                while (n3 < qOperandBoxArray.length) {
                    int n7;
                    if (qOperandBoxArray[n3].getOperand() instanceof QSSAVar && !bitSet3.get(n7 = ((QSSAVar)qOperandBoxArray[n3].getOperand()).getUniqueIndex())) {
                        bitSet.set(n7);
                    }
                    ++n3;
                }
                bitSet2.or(bitSet);
                if (!((QInst)object).defVar() || !(((QInst)object).getDefined().getOperand() instanceof QSSAVar)) continue;
                bitSet3.set(((QSSAVar)((QInst)object).getDefined().getOperand()).getUniqueIndex());
            }
            object = basicBlock.getSuccessors();
            while (object.hasNext()) {
                BasicBlock basicBlock2 = (BasicBlock)object.next();
                object3 = basicBlock2.getPhis();
                while (object3.hasNext()) {
                    QPhiJoin qPhiJoin;
                    QPhi qPhi = (QPhi)object3.next();
                    if (!(qPhi instanceof QPhiJoin) || !(qPhiJoin = (QPhiJoin)qPhi).hasOperandForBlock(basicBlock)) continue;
                    QOperand qOperand = qPhiJoin.getOperandForBlock(basicBlock).getOperand();
                    QOperand qOperand2 = qPhiJoin.getTarget();
                    if (!(qOperand2 instanceof QSSAVar) || !(qOperand instanceof QSSAVar)) continue;
                    int n8 = ((QSSAVar)qOperand).getUniqueIndex();
                    if (!bitSet3.get(n8)) {
                        bitSet2.set(n8);
                    }
                    bitSet3.set(((QSSAVar)qOperand2).getUniqueIndex());
                }
            }
            ++n2;
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            int n9 = this.topologicalOrder.length - 1;
            while (n9 >= 0) {
                int n10 = this.topologicalOrder[n9];
                bitSet2 = bitSetArray2[n10];
                bitSet = bitSetArray[n10];
                object3 = bitSet;
                int n11 = 0;
                while (n11 < bitSet2.size()) {
                    bitSet2.clear(n11);
                    ++n11;
                }
                object2 = this.nodes[n10].getSuccessors();
                while (object2.hasNext()) {
                    bitSet2.or(bitSetArray[((Node)object2.next()).getIndex()]);
                }
                object = (BitSet)bitSet2.clone();
                ((BitSet)object).andNot(bitSetArray3[n10]);
                bitSetArray[n10] = bitSet = (BitSet)bitSetArray4[n10].clone();
                bitSet.or((BitSet)object);
                if (!bitSet.equals(object3)) {
                    n2 = 1;
                }
                --n9;
            }
        }
    }

    public void computeNonSSALivenessAnalysis(BitSet[] bitSetArray, BitSet[] bitSetArray2) {
        Object object;
        Object object2;
        Object object3;
        BitSet bitSet;
        BitSet bitSet2;
        int n = this.nodes.length;
        BitSet[] bitSetArray3 = new BitSet[n];
        BitSet[] bitSetArray4 = new BitSet[n];
        int n2 = 0;
        while (n2 < n) {
            bitSetArray3[n2] = new BitSet();
            bitSetArray4[n2] = new BitSet();
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            BasicBlock basicBlock = (BasicBlock)this.nodes[n2];
            BitSet bitSet3 = bitSetArray3[n2];
            bitSet2 = bitSetArray4[n2];
            bitSet = new BitSet();
            object3 = basicBlock.getInstructions();
            while (object3.hasNext()) {
                int n3 = 0;
                while (n3 < bitSet.size()) {
                    bitSet.clear(n3);
                    ++n3;
                }
                object2 = (QInst)object3.next();
                object = ((QInst)object2).getUses();
                int n4 = 0;
                while (n4 < ((QOperandBox[])object).length) {
                    int n5;
                    if (object[n4].getOperand() instanceof QVar && !bitSet3.get(n5 = ((QVar)object[n4].getOperand()).getRegister())) {
                        bitSet.set(n5);
                    }
                    ++n4;
                }
                bitSet2.or(bitSet);
                if (!((QInst)object2).defVar() || !(((QInst)object2).getDefined().getOperand() instanceof QVar)) continue;
                bitSet3.set(((QVar)((QInst)object2).getDefined().getOperand()).getRegister());
            }
            ++n2;
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            int n6 = this.topologicalOrder.length - 1;
            while (n6 >= 0) {
                int n7 = this.topologicalOrder[n6];
                bitSet2 = bitSetArray2[n7];
                bitSet = bitSetArray[n7];
                object3 = bitSet;
                int n8 = 0;
                while (n8 < bitSet2.size()) {
                    bitSet2.clear(n8);
                    ++n8;
                }
                object2 = this.nodes[n7].getSuccessors();
                while (object2.hasNext()) {
                    bitSet2.or(bitSetArray[((Node)object2.next()).getIndex()]);
                }
                object = (BitSet)bitSet2.clone();
                ((BitSet)object).andNot(bitSetArray3[n7]);
                bitSetArray[n7] = bitSet = (BitSet)bitSetArray4[n7].clone();
                bitSet.or((BitSet)object);
                if (!bitSet.equals(object3)) {
                    n2 = 1;
                }
                --n6;
            }
        }
    }

    protected void addPhiCatch(BasicBlock basicBlock, Vector vector) {
        int n = 0;
        while (n < this.exceptionHandlers.length) {
            if (this.exceptionHandlers[n].contains(basicBlock)) {
                this.addPhiCatchFrom(this.exceptionHandlers[n].getHandlerBlock(), vector);
            }
            ++n;
        }
    }

    protected void addPhiCatchFrom(BasicBlock basicBlock, Vector vector) {
        Iterator iterator = basicBlock.getPhis();
        while (iterator.hasNext()) {
            QPhi qPhi = (QPhi)iterator.next();
            if (!(qPhi instanceof QPhiCatch)) continue;
            vector.addElement(qPhi);
        }
    }

    protected void topologicalSort(Node[] nodeArray, Node node) {
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2].setMarked(false);
            ++n2;
        }
        this.num = n;
        this.depthFirstSearch(node);
        n2 = 0;
        while (n2 < n) {
            if (!nodeArray[n2].getMarked()) {
                this.depthFirstSearch(nodeArray[n2]);
            }
            ++n2;
        }
    }

    protected void depthFirstSearch(Node node) {
        if (!node.getMarked()) {
            node.setMarked(true);
            Iterator iterator = node.getSuccessors();
            while (iterator.hasNext()) {
                this.depthFirstSearch((Node)iterator.next());
            }
            this.topologicalOrder[--this.num] = node.getIndex();
        }
    }

    public LivenessComputer(Graph graph, BasicBlock basicBlock, ExceptionHandler[] exceptionHandlerArray) {
        this.graph = graph;
        this.start = basicBlock;
        this.nodes = this.graph.getNodes();
        this.exceptionHandlers = exceptionHandlerArray;
        this.topologicalOrder = new int[this.nodes.length];
        this.topologicalSort(this.nodes, basicBlock);
    }
}

