/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.CodeInfo;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.MethodInfo;
import at.dms.ssa.ControlFlowGraph;
import at.dms.ssa.SSAOptions;

public class MethodOptimizer {
    CodeInfo info;
    protected ControlFlowGraph cfg;

    public CodeInfo generateCode() {
        Instruction[] instructionArray = this.cfg.getInstructions();
        HandlerInfo[] handlerInfoArray = this.cfg.getHandlerInfos(instructionArray);
        CodeInfo codeInfo = new CodeInfo(instructionArray, handlerInfoArray, new LineNumberInfo[0], new LocalVariableInfo[0]);
        return codeInfo;
    }

    public static CodeInfo optimize(MethodInfo methodInfo, CodeInfo codeInfo, SSAOptions sSAOptions) {
        MethodOptimizer methodOptimizer = new MethodOptimizer(methodInfo, codeInfo);
        return methodOptimizer.generateCode();
    }

    public static CodeInfo optimize(MethodInfo methodInfo, SSAOptions sSAOptions) {
        return MethodOptimizer.optimize(methodInfo, methodInfo.getCodeInfo(), sSAOptions);
    }

    public MethodOptimizer(MethodInfo methodInfo, CodeInfo codeInfo) {
        this.cfg = new ControlFlowGraph(methodInfo, codeInfo);
        this.info = codeInfo;
    }
}

