/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.Edge;
import at.dms.ssa.PredecessorsIterator;
import at.dms.ssa.SuccessorsIterator;
import java.util.Iterator;
import java.util.Vector;

public class Node {
    protected Vector predecessors = new Vector();
    protected Vector successors = new Vector();
    protected boolean marked = false;
    protected int index;

    public Iterator getPredecessors() {
        return new PredecessorsIterator(this.predecessors.iterator());
    }

    public Iterator getSuccessors() {
        return new SuccessorsIterator(this.successors.iterator());
    }

    public boolean hasSuccessor() {
        boolean bl = false;
        if (this.successors.size() != 0) {
            bl = true;
        }
        return bl;
    }

    public Iterator getInEdges() {
        return this.predecessors.iterator();
    }

    public Iterator getOutEdges() {
        return this.successors.iterator();
    }

    public int getInEdgesNumber() {
        return this.predecessors.size();
    }

    public int getOutEdgesNumber() {
        return this.successors.size();
    }

    public void changeEdgeTarget(Edge edge, Node node) {
        edge.getTarget().predecessors.removeElement(edge);
        edge.setTarget(node);
        node.predecessors.addElement(edge);
    }

    public Edge addSuccessor(Edge edge, Node node) {
        edge.setSource(this);
        edge.setTarget(node);
        this.successors.addElement(edge);
        node.predecessors.addElement(edge);
        return edge;
    }

    public void removeSuccessor(Node node) {
        Iterator iterator = this.getOutEdges();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getTarget() != node) continue;
            this.predecessors.removeElement(edge);
            this.successors.removeElement(edge);
        }
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
    }

    public boolean getMarked() {
        return this.marked;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int n) {
        this.index = n;
    }
}

