/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.ClassInfo;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.MethodInfo;
import at.dms.ssa.MethodOptimizer;

public class Optimizer {
    public static void optimizeClass(ClassInfo classInfo) {
        MethodInfo[] methodInfoArray = classInfo.getMethods();
        int n = 0;
        while (n < methodInfoArray.length) {
            CodeInfo codeInfo = methodInfoArray[n].getCodeInfo();
            if (codeInfo != null) {
                MethodOptimizer methodOptimizer = new MethodOptimizer(methodInfoArray[n], codeInfo);
                codeInfo = methodOptimizer.generateCode();
                methodInfoArray[n].setCodeInfo(codeInfo);
            }
            ++n;
        }
    }

    public static MethodInfo optimize(MethodInfo methodInfo) {
        CodeInfo codeInfo = methodInfo.getCodeInfo();
        if (codeInfo != null) {
            MethodOptimizer methodOptimizer = new MethodOptimizer(methodInfo, codeInfo);
            codeInfo = methodOptimizer.generateCode();
            methodInfo.setCodeInfo(codeInfo);
        }
        return methodInfo;
    }
}

