/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.BasicBlock;
import at.dms.ssa.QAssignment;
import at.dms.ssa.QExpression;
import at.dms.ssa.QInst;
import at.dms.ssa.QInstArray;
import at.dms.ssa.QNop;
import at.dms.ssa.QOperand;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QVar;
import at.dms.ssa.VarListDefUse;
import java.util.BitSet;

public class Propagator {
    public static void propagate(BasicBlock basicBlock, BitSet[] bitSetArray) {
        VarListDefUse varListDefUse = new VarListDefUse();
        BasicBlock basicBlock2 = basicBlock;
        while (basicBlock2 != null) {
            QInstArray qInstArray = basicBlock2.getInstructionsArray();
            Propagator.findDefUse(qInstArray, varListDefUse);
            Propagator.removeDefUseThrowEdges(varListDefUse, bitSetArray[basicBlock2.getIndex()]);
            varListDefUse.verifyAllLists();
            Propagator.propagate(qInstArray, varListDefUse);
            basicBlock2 = basicBlock2.getNext();
        }
    }

    private static final void removeDefUseThrowEdges(VarListDefUse varListDefUse, BitSet bitSet) {
        int n = 0;
        while (n < bitSet.size()) {
            if (bitSet.get(n)) {
                varListDefUse.addUse(n, -2);
                varListDefUse.addUse(n, -2);
            }
            ++n;
        }
    }

    private static final void findDefUse(QInstArray qInstArray, VarListDefUse varListDefUse) {
        varListDefUse.clear();
        int n = 0;
        while (n < qInstArray.size()) {
            QOperand qOperand;
            QInst qInst = qInstArray.getInstructionAt(n);
            QOperandBox[] qOperandBoxArray = qInst.getUses();
            int n2 = 0;
            while (n2 < qOperandBoxArray.length) {
                QOperand qOperand2 = qOperandBoxArray[n2].getOperand();
                if (qOperand2 instanceof QVar) {
                    int n3 = ((QVar)qOperand2).getRegister();
                    varListDefUse.addUse(n3, n);
                }
                ++n2;
            }
            if (qInst instanceof QAssignment && (qOperand = ((QAssignment)qInst).getDefined().getOperand()) instanceof QVar) {
                int n4 = ((QVar)qOperand).getRegister();
                varListDefUse.addDef(n4, n);
            }
            ++n;
        }
    }

    private static final void propagate(QInstArray qInstArray, VarListDefUse varListDefUse) {
        int n = qInstArray.size() - 1;
        while (n >= 0) {
            QOperandBox[] qOperandBoxArray = qInstArray.getInstructionAt(n).getUses();
            Propagator.propagate(qInstArray, qOperandBoxArray, n, n, varListDefUse);
            --n;
        }
    }

    private static final void propagate(QInstArray qInstArray, QOperandBox[] qOperandBoxArray, int n, int n2, VarListDefUse varListDefUse) {
        int n3 = qOperandBoxArray.length - 1;
        while (n3 >= 0) {
            int n4;
            int n5;
            QOperand qOperand = qOperandBoxArray[n3].getOperand();
            if (qOperand instanceof QVar && varListDefUse.isUniqUse(n5 = ((QVar)qOperand).getRegister(), n2) && Propagator.isMovePossible(qInstArray, n4 = varListDefUse.getDefIndex(n5), n)) {
                QExpression qExpression = Propagator.moveExpression(qInstArray, n4, qOperandBoxArray[n3]);
                Propagator.propagate(qInstArray, qExpression.getUses(), n, n4, varListDefUse);
            }
            --n3;
        }
    }

    private static final boolean isMovePossible(QInstArray qInstArray, int n, int n2) {
        Object object;
        QAssignment qAssignment = (QAssignment)qInstArray.getInstructionAt(n);
        BitSet bitSet = new BitSet();
        QOperandBox[] qOperandBoxArray = qAssignment.getUses();
        int n3 = 0;
        while (n3 < qOperandBoxArray.length) {
            object = qOperandBoxArray[n3].getOperand();
            if (object instanceof QVar) {
                int n4 = ((QVar)object).getRegister();
                bitSet.set(n4);
            }
            ++n3;
        }
        if (qAssignment.mayThrowException()) {
            n3 = n + 1;
            while (n3 < n2) {
                if (!(qInstArray.getInstructionAt(n3) instanceof QNop)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        n3 = n + 1;
        while (n3 < n2) {
            int n5;
            QOperand qOperand;
            object = qInstArray.getInstructionAt(n3);
            if (((QInst)object).mayThrowException()) {
                return false;
            }
            if (object instanceof QAssignment && (qOperand = ((QAssignment)object).getDefined().getOperand()) instanceof QVar && bitSet.get(n5 = ((QVar)qOperand).getRegister())) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static final QExpression moveExpression(QInstArray qInstArray, int n, QOperandBox qOperandBox) {
        QAssignment qAssignment = (QAssignment)qInstArray.getInstructionAt(n);
        qOperandBox.setOperand(qAssignment.getExpression());
        qInstArray.replaceInstruction(n, new QNop());
        return qAssignment.getExpression();
    }
}

