/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.NoArgInstruction;
import at.dms.ssa.CodeGenerator;
import at.dms.ssa.QExpression;
import at.dms.ssa.QOperand;
import at.dms.ssa.QOperandBox;

public class QBinaryOperation
extends QExpression {
    protected QOperandBox op1;
    protected QOperandBox op2;
    protected int opcode;
    protected boolean exception;
    protected byte type;

    public QOperandBox[] getUses() {
        return new QOperandBox[]{this.op1, this.op2};
    }

    public boolean isIadd() {
        boolean bl = false;
        if (this.opcode == 96) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.op1 + " xxx " + this.op2;
    }

    public boolean mayThrowException() {
        return this.exception;
    }

    public byte getType() {
        return this.type;
    }

    public void generateInstructions(CodeGenerator codeGenerator) {
        this.op1.getOperand().generateInstructions(codeGenerator);
        this.op2.getOperand().generateInstructions(codeGenerator);
        codeGenerator.addInstruction(new NoArgInstruction(this.opcode));
    }

    public QBinaryOperation(QOperand qOperand, QOperand qOperand2, int n) {
        this.op1 = new QOperandBox(qOperand, this);
        this.op2 = new QOperandBox(qOperand2, this);
        this.opcode = n;
        if (n == 132) {
            this.opcode = 96;
        }
        this.exception = false;
        switch (n) {
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                this.type = (byte)4;
                break;
            }
            case 98: 
            case 102: 
            case 106: {
                this.type = (byte)3;
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.type = (byte)4;
                break;
            }
            case 99: 
            case 103: 
            case 107: {
                this.type = (byte)2;
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                this.type = (byte)5;
                break;
            }
            case 108: 
            case 112: {
                this.type = (byte)4;
                this.exception = true;
                break;
            }
            case 110: 
            case 114: {
                this.type = (byte)3;
                this.exception = true;
                break;
            }
            case 111: 
            case 115: {
                this.type = (byte)2;
                this.exception = true;
                break;
            }
            case 109: 
            case 113: {
                this.type = (byte)5;
                this.exception = true;
                break;
            }
            default: {
                this.exception = false;
            }
        }
    }
}

