/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.JumpInstruction;
import at.dms.ssa.BasicBlock;
import at.dms.ssa.CodeGenerator;
import at.dms.ssa.Edge;
import at.dms.ssa.EdgeLabel;
import at.dms.ssa.QAbstractJumpInst;
import at.dms.ssa.QConstant;
import at.dms.ssa.QOperand;
import at.dms.ssa.QOperandBox;

public class QConditionalJump
extends QAbstractJumpInst {
    protected QOperandBox operand1;
    protected QOperandBox operand2;
    protected int opcode;
    protected Edge destTrue;
    protected Edge destFalse;

    public boolean mayThrowException() {
        return false;
    }

    public void generateInstructions(CodeGenerator codeGenerator) {
        BasicBlock basicBlock;
        this.simplifyJump(this.destTrue);
        if (!this.tryGenerateUnaryConditionalJump(codeGenerator)) {
            this.operand1.getOperand().generateInstructions(codeGenerator);
            this.operand2.getOperand().generateInstructions(codeGenerator);
            codeGenerator.addInstruction(new JumpInstruction(this.opcode, new EdgeLabel(this.destTrue)));
        }
        if ((basicBlock = codeGenerator.getCurrentBasicBlock().getNext()) != null && this.destFalse.getTarget() == basicBlock) {
            return;
        }
        this.simplifyJump(this.destFalse);
        codeGenerator.addInstruction(new JumpInstruction(167, new EdgeLabel(this.destFalse)));
    }

    public void simplifyAllJumps() {
        this.simplifyJump(this.destTrue);
        this.simplifyJump(this.destFalse);
    }

    public boolean tryGenerateUnaryConditionalJump(CodeGenerator codeGenerator) {
        if (this.operand2.getOperand() instanceof QConstant) {
            QConstant qConstant = (QConstant)this.operand2.getOperand();
            if (qConstant.isNull()) {
                switch (this.opcode) {
                    case 165: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(198, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                    case 166: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(199, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                }
            } else if (qConstant.getValue() instanceof Integer && (Integer)qConstant.getValue() == 0) {
                switch (this.opcode) {
                    case 159: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(153, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                    case 160: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(154, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                    case 161: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(155, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                    case 162: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(156, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                    case 163: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(157, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                    case 164: {
                        this.operand1.getOperand().generateInstructions(codeGenerator);
                        codeGenerator.addInstruction(new JumpInstruction(158, new EdgeLabel(this.destTrue)));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public QOperandBox[] getUses() {
        return new QOperandBox[]{this.operand1, this.operand2};
    }

    public String toString() {
        return "if " + this.operand1 + " xxx " + this.operand2;
    }

    protected QConditionalJump(Edge edge, Edge edge2, QOperand qOperand, QOperand qOperand2, int n) {
        this.destTrue = edge;
        this.destFalse = edge2;
        this.operand1 = new QOperandBox(qOperand, this);
        this.operand2 = new QOperandBox(qOperand2, this);
        this.opcode = n;
    }
}

