/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.NoArgInstruction;
import at.dms.classfile.PushLiteralInstruction;
import at.dms.ssa.CodeGenerator;
import at.dms.ssa.QOperand;
import at.dms.util.InconsistencyException;

public class QConstant
extends QOperand {
    protected boolean nullConstant;
    protected Object value;
    protected byte type;

    public boolean mayThrowException() {
        return false;
    }

    public boolean hasSideEffects() {
        return false;
    }

    public byte getType() {
        return this.type;
    }

    public boolean isConstant() {
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.nullConstant) {
            return "null";
        }
        if (this.value instanceof Integer) {
            return "" + (Integer)this.value;
        }
        if (this.value instanceof Long) {
            return "" + (Long)this.value;
        }
        if (this.value instanceof Float) {
            return "" + ((Float)this.value).floatValue();
        }
        if (this.value instanceof Double) {
            return "" + (Double)this.value;
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return "constant";
    }

    public boolean isNull() {
        return this.nullConstant;
    }

    public void generateInstructions(CodeGenerator codeGenerator) {
        if (this.nullConstant) {
            codeGenerator.addInstruction(new NoArgInstruction(1));
        } else if (this.value instanceof Integer) {
            codeGenerator.addInstruction(new PushLiteralInstruction((Integer)this.value));
        } else if (this.value instanceof Long) {
            codeGenerator.addInstruction(new PushLiteralInstruction((Long)this.value));
        } else if (this.value instanceof Float) {
            codeGenerator.addInstruction(new PushLiteralInstruction(((Float)this.value).floatValue()));
        } else if (this.value instanceof Double) {
            codeGenerator.addInstruction(new PushLiteralInstruction((Double)this.value));
        } else if (this.value instanceof String) {
            codeGenerator.addInstruction(new PushLiteralInstruction((String)this.value));
        }
    }

    public void generateStore(CodeGenerator codeGenerator) {
        throw new InconsistencyException("Cannot store in constant value");
    }

    public QConstant() {
        this.nullConstant = true;
        this.type = (byte)6;
    }

    public QConstant(Object object, byte by) {
        this.value = object;
        this.type = object instanceof String ? (byte)6 : by;
    }
}

