/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.BasicBlock;
import at.dms.ssa.QInst;
import at.dms.ssa.QInstArrayAccessor;
import at.dms.ssa.QNop;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QPhi;
import at.dms.ssa.QPhiNop;
import at.dms.ssa.QSSAVar;
import at.dms.ssa.SSAVar;
import java.util.Iterator;
import java.util.Vector;

public class QInstArray {
    protected BasicBlock bb;
    protected Vector insts;

    public void addInstruction(QInst qInst) {
        qInst.setArray(new QInstArrayAccessor(this, this.insts.size()));
        this.insts.addElement(qInst);
    }

    public BasicBlock getBasicBlock() {
        return this.bb;
    }

    public Iterator iterator() {
        return this.insts.iterator();
    }

    public int size() {
        return this.insts.size();
    }

    public void replaceInstruction(int n, QInst qInst) {
        ((QInst)this.insts.elementAt(n)).setArray(null);
        qInst.setArray(new QInstArrayAccessor(this, n));
        this.insts.setElementAt(qInst, n);
    }

    public QInst getLastInstruction() {
        return (QInst)this.insts.elementAt(this.insts.size() - 1);
    }

    public QInst getInstructionAt(int n) {
        return (QInst)this.insts.elementAt(n);
    }

    public QInst removeLastInstruction() {
        if (this.insts.size() == 0) {
            return null;
        }
        QInst qInst = (QInst)this.insts.elementAt(this.insts.size() - 1);
        qInst.setArray(null);
        this.insts.setSize(this.insts.size() - 1);
        return qInst;
    }

    public void removeSSAInstruction(int n) {
        QInst qInst = (QInst)this.insts.elementAt(n);
        QOperandBox[] qOperandBoxArray = qInst.getUses();
        int n2 = 0;
        while (n2 < qOperandBoxArray.length) {
            if (qOperandBoxArray[n2].getOperand() instanceof QSSAVar) {
                SSAVar sSAVar = ((QSSAVar)qOperandBoxArray[n2].getOperand()).getSSAVar();
                sSAVar.removeUse(qOperandBoxArray[n2]);
            }
            ++n2;
        }
        if (qInst instanceof QPhi) {
            this.replaceInstruction(n, new QPhiNop());
        } else {
            this.replaceInstruction(n, new QNop());
        }
    }

    public void insertAfter(int n, QInst qInst) {
        if (n == this.insts.size() - 1) {
            this.addInstruction(qInst);
        } else {
            QInst qInst2 = this.getInstructionAt(n + 1);
            if (qInst2 instanceof QNop) {
                this.replaceInstruction(n + 1, qInst);
            } else {
                this.insts.insertElementAt(qInst, n + 1);
                ++n;
                while (n < this.insts.size()) {
                    this.getInstructionAt(n).setArray(new QInstArrayAccessor(this, n));
                    ++n;
                }
            }
        }
    }

    public QInstArray(BasicBlock basicBlock) {
        this.bb = basicBlock;
        this.insts = new Vector();
    }
}

