/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.MultiarrayInstruction;
import at.dms.ssa.CodeGenerator;
import at.dms.ssa.QCallReturn;
import at.dms.ssa.QOperand;
import at.dms.ssa.QOperandBox;

public class QMultiArray
extends QCallReturn {
    protected MultiarrayInstruction mai;
    protected QOperandBox[] dimensions;

    public boolean hasSideEffects() {
        return true;
    }

    public byte getType() {
        return 6;
    }

    public QOperandBox[] getUses() {
        return this.dimensions;
    }

    public String toString() {
        String string = "new " + this.mai.getType() + ' ';
        int n = 0;
        while (n < this.dimensions.length) {
            string = string + '[' + this.dimensions[n] + ']';
            ++n;
        }
        return string;
    }

    public void generateInstructions(CodeGenerator codeGenerator) {
        int n = 0;
        while (n < this.dimensions.length) {
            this.dimensions[n].getOperand().generateInstructions(codeGenerator);
            ++n;
        }
        codeGenerator.addInstruction(this.mai);
    }

    public QMultiArray(MultiarrayInstruction multiarrayInstruction, QOperand[] qOperandArray) {
        this.mai = multiarrayInstruction;
        this.dimensions = new QOperandBox[qOperandArray.length];
        int n = 0;
        while (n < qOperandArray.length) {
            this.dimensions[n] = new QOperandBox(qOperandArray[n], this);
            ++n;
        }
    }
}

