/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.classfile.ClassRefInstruction;
import at.dms.classfile.FieldRefInstruction;
import at.dms.classfile.IincInstruction;
import at.dms.classfile.Instruction;
import at.dms.classfile.InvokeinterfaceInstruction;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.MethodRefInstruction;
import at.dms.classfile.MultiarrayInstruction;
import at.dms.classfile.NewarrayInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.classfile.PushLiteralInstruction;
import at.dms.classfile.SwitchInstruction;
import at.dms.ssa.BasicBlock;
import at.dms.ssa.GenerateQVar;
import at.dms.ssa.QANewArray;
import at.dms.ssa.QArrayLength;
import at.dms.ssa.QAssignment;
import at.dms.ssa.QBinaryOperation;
import at.dms.ssa.QCheckCast;
import at.dms.ssa.QConditionalJump;
import at.dms.ssa.QConstant;
import at.dms.ssa.QDeclareInitialised;
import at.dms.ssa.QExpression;
import at.dms.ssa.QGetArray;
import at.dms.ssa.QGetField;
import at.dms.ssa.QInstanceOf;
import at.dms.ssa.QJsr;
import at.dms.ssa.QJump;
import at.dms.ssa.QMethodReturn;
import at.dms.ssa.QMonitor;
import at.dms.ssa.QMultiArray;
import at.dms.ssa.QNew;
import at.dms.ssa.QNewArray;
import at.dms.ssa.QOperand;
import at.dms.ssa.QPutArray;
import at.dms.ssa.QPutField;
import at.dms.ssa.QRet;
import at.dms.ssa.QReturn;
import at.dms.ssa.QSimpleExpression;
import at.dms.ssa.QSwitch;
import at.dms.ssa.QThrow;
import at.dms.ssa.QUnaryOperation;
import at.dms.ssa.QVar;
import at.dms.ssa.QVoidMethodCall;
import at.dms.util.InconsistencyException;

public class QuadrupleGenerator {
    protected GenerateQVar generateVar;

    public int getVarNumber() {
        return this.generateVar.getVarNumber();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean generate(Instruction instruction, Instruction instruction2, BasicBlock basicBlock) {
        int n = instruction.getOpcode();
        if (instruction.getPushedOnStack() <= 0) {
            if (instruction instanceof SwitchInstruction) {
                basicBlock.addInstruction(new QSwitch((SwitchInstruction)instruction, this.generateVar.pop()));
                return false;
            } else if (instruction instanceof JumpInstruction) {
                switch (instruction.getStack()) {
                    case 0: {
                        basicBlock.addInstruction(new QJump(basicBlock.getDefaultNext()));
                        return false;
                    }
                    case -1: {
                        QConstant qConstant = new QConstant(new Integer(0), 4);
                        int n2 = 0;
                        switch (n) {
                            case 153: {
                                n2 = 159;
                                break;
                            }
                            case 154: {
                                n2 = 160;
                                break;
                            }
                            case 155: {
                                n2 = 161;
                                break;
                            }
                            case 156: {
                                n2 = 162;
                                break;
                            }
                            case 157: {
                                n2 = 163;
                                break;
                            }
                            case 158: {
                                n2 = 164;
                                break;
                            }
                            case 198: {
                                qConstant = new QConstant();
                                n2 = 165;
                                break;
                            }
                            case 199: {
                                qConstant = new QConstant();
                                n2 = 166;
                                break;
                            }
                            default: {
                                throw new InconsistencyException("INVALID UNARY CONDITIONAL JUMP");
                            }
                        }
                        basicBlock.addInstruction(new QConditionalJump(basicBlock.getConditionNext(), basicBlock.getDefaultNext(), this.generateVar.pop(), qConstant, n2));
                        return false;
                    }
                    case -2: {
                        QOperand qOperand = this.generateVar.pop();
                        QOperand qOperand2 = this.generateVar.pop();
                        basicBlock.addInstruction(new QConditionalJump(basicBlock.getConditionNext(), basicBlock.getDefaultNext(), qOperand2, qOperand, n));
                    }
                }
                return false;
            } else if (instruction instanceof FieldRefInstruction) {
                QOperand qOperand = this.generateVar.pop();
                QOperand qOperand3 = null;
                if (n == 181) {
                    qOperand3 = this.generateVar.pop();
                }
                basicBlock.addInstruction(new QPutField(((FieldRefInstruction)instruction).getFieldRefConstant(), qOperand3, qOperand, n));
                return false;
            } else if (instruction instanceof InvokeinterfaceInstruction) {
                InvokeinterfaceInstruction invokeinterfaceInstruction = (InvokeinterfaceInstruction)instruction;
                int n3 = this.nbParam(invokeinterfaceInstruction);
                QOperand[] qOperandArray = new QOperand[n3];
                int n4 = n3 - 1;
                while (n4 >= 0) {
                    qOperandArray[n4] = this.generateVar.pop();
                    --n4;
                }
                basicBlock.addInstruction(new QVoidMethodCall(invokeinterfaceInstruction.getInterfaceConstant(), qOperandArray, n, invokeinterfaceInstruction.getNbArgs()));
                return false;
            } else if (instruction instanceof MethodRefInstruction) {
                MethodRefInstruction methodRefInstruction = (MethodRefInstruction)instruction;
                int n5 = this.nbParam(methodRefInstruction);
                QOperand[] qOperandArray = new QOperand[n5];
                int n6 = n5 - 1;
                while (n6 >= 0) {
                    qOperandArray[n6] = this.generateVar.pop();
                    --n6;
                }
                basicBlock.addInstruction(new QVoidMethodCall(methodRefInstruction.getMethodRefConstant(), qOperandArray, n));
                return false;
            } else if (instruction instanceof NoArgInstruction) {
                switch (n) {
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        QOperand qOperand = this.generateVar.pop();
                        QOperand qOperand4 = this.generateVar.pop();
                        QOperand qOperand5 = this.generateVar.pop();
                        basicBlock.addInstruction(new QPutArray(qOperand5, qOperand4, qOperand, n));
                        return false;
                    }
                    case 177: {
                        basicBlock.addInstruction(new QReturn());
                        return false;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: {
                        basicBlock.addInstruction(new QReturn(this.generateVar.pop(), n));
                        return false;
                    }
                    case 191: {
                        basicBlock.addInstruction(new QThrow(this.generateVar.pop()));
                        return false;
                    }
                    case 194: 
                    case 195: {
                        basicBlock.addInstruction(new QMonitor(this.generateVar.pop(), n));
                        return false;
                    }
                    case 87: {
                        this.generateVar.pop();
                        return false;
                    }
                    case 88: {
                        this.generateVar.pop2();
                        return false;
                    }
                }
                return false;
            } else if (instruction instanceof LocalVarInstruction) {
                LocalVarInstruction localVarInstruction = (LocalVarInstruction)instruction;
                if (localVarInstruction.isStore()) {
                    QVar qVar = this.generateVar.getVar(localVarInstruction.getIndex(), localVarInstruction.getOperandType());
                    this.verifyVarNotInStack(qVar, basicBlock);
                    basicBlock.addInstruction(new QAssignment(qVar, new QSimpleExpression(this.generateVar.pop())));
                    return false;
                } else {
                    basicBlock.addInstruction(new QRet(this.generateVar.getVar(localVarInstruction.getIndex(), localVarInstruction.getOperandType())));
                }
                return false;
            } else if (instruction instanceof IincInstruction) {
                IincInstruction iincInstruction = (IincInstruction)instruction;
                QVar qVar = this.generateVar.getVar(iincInstruction.getVariable(), (byte)4);
                this.verifyVarNotInStack(qVar, basicBlock);
                basicBlock.addInstruction(new QAssignment(qVar, new QBinaryOperation(qVar, new QConstant(new Integer(iincInstruction.getIncrement()), 4), n)));
                return false;
            } else {
                if (!(instruction instanceof ClassRefInstruction)) throw new InconsistencyException("Instruction inconnue " + n + ' ' + instruction);
                ClassRefInstruction classRefInstruction = (ClassRefInstruction)instruction;
                QOperand qOperand = this.generateVar.pop();
                basicBlock.addInstruction(new QAssignment(this.generateVar.push((byte)6), new QCheckCast(classRefInstruction.getClassConstant(), qOperand)));
            }
            return false;
        } else {
            Object object;
            QExpression qExpression = null;
            if (instruction instanceof LocalVarInstruction) {
                object = (LocalVarInstruction)instruction;
                this.generateVar.push(this.generateVar.getVar(((LocalVarInstruction)object).getIndex(), ((LocalVarInstruction)object).getOperandType()));
            } else if (instruction instanceof NoArgInstruction) {
                switch (n) {
                    case 174: {
                        basicBlock.addInstruction(new QReturn(this.generateVar.pop(), n));
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: {
                        object = this.generateVar.pop();
                        QOperand qOperand = this.generateVar.pop();
                        qExpression = new QBinaryOperation(qOperand, (QOperand)object, n);
                        break;
                    }
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: {
                        QOperand qOperand = this.generateVar.pop();
                        qExpression = new QUnaryOperation(qOperand, n);
                        break;
                    }
                    case 1: {
                        this.generateVar.push(new QConstant());
                        break;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: {
                        QOperand qOperand = this.generateVar.pop();
                        QOperand qOperand6 = this.generateVar.pop();
                        qExpression = new QGetArray(qOperand6, qOperand, ((NoArgInstruction)instruction).getReturnType(), n);
                        break;
                    }
                    case 190: {
                        QOperand qOperand = this.generateVar.pop();
                        qExpression = new QArrayLength(qOperand);
                        break;
                    }
                    case 89: {
                        this.generateVar.dup();
                        break;
                    }
                    case 90: {
                        this.generateVar.dup_x1();
                        break;
                    }
                    case 91: {
                        this.generateVar.dup_x2();
                        break;
                    }
                    case 92: {
                        this.generateVar.dup2();
                        break;
                    }
                    case 93: {
                        this.generateVar.dup2_x1();
                        break;
                    }
                    case 94: {
                        this.generateVar.dup2_x2();
                        break;
                    }
                    case 95: {
                        this.generateVar.swap();
                        break;
                    }
                    default: {
                        throw new InconsistencyException("Instruction Not Used " + n + ' ' + instruction);
                    }
                }
            } else if (instruction instanceof PushLiteralInstruction) {
                object = (PushLiteralInstruction)instruction;
                this.generateVar.push(new QConstant(((PushLiteralInstruction)object).getLiteral(), ((PushLiteralInstruction)object).getReturnType()));
            } else if (instruction instanceof InvokeinterfaceInstruction) {
                object = (InvokeinterfaceInstruction)instruction;
                int n7 = this.nbParam((InvokeinterfaceInstruction)object);
                QOperand[] qOperandArray = new QOperand[n7];
                int n8 = n7 - 1;
                while (n8 >= 0) {
                    qOperandArray[n8] = this.generateVar.pop();
                    --n8;
                }
                qExpression = new QMethodReturn(((InvokeinterfaceInstruction)object).getInterfaceConstant(), qOperandArray, ((InvokeinterfaceInstruction)object).getReturnType(), n, ((InvokeinterfaceInstruction)object).getNbArgs());
            } else if (instruction instanceof MethodRefInstruction) {
                object = (MethodRefInstruction)instruction;
                int n9 = this.nbParam((MethodRefInstruction)object);
                QOperand[] qOperandArray = new QOperand[n9];
                int n10 = n9 - 1;
                while (n10 >= 0) {
                    qOperandArray[n10] = this.generateVar.pop();
                    --n10;
                }
                qExpression = new QMethodReturn(((MethodRefInstruction)object).getMethodRefConstant(), qOperandArray, ((MethodRefInstruction)object).getReturnType(), n);
            } else if (instruction instanceof FieldRefInstruction) {
                object = null;
                if (n == 180) {
                    object = this.generateVar.pop();
                }
                FieldRefInstruction fieldRefInstruction = (FieldRefInstruction)instruction;
                qExpression = new QGetField(fieldRefInstruction.getFieldRefConstant(), (QOperand)object, fieldRefInstruction.getReturnType(), n);
            } else if (instruction instanceof ClassRefInstruction) {
                object = (ClassRefInstruction)instruction;
                switch (n) {
                    case 193: {
                        qExpression = new QInstanceOf(this.generateVar.pop(), ((ClassRefInstruction)object).getClassConstant());
                        break;
                    }
                    case 187: {
                        qExpression = new QNew(((ClassRefInstruction)object).getClassConstant());
                        break;
                    }
                    case 189: {
                        qExpression = new QANewArray(((ClassRefInstruction)object).getClassConstant(), this.generateVar.pop());
                        break;
                    }
                    default: {
                        throw new InconsistencyException("Instruction Not Used " + n + ' ' + instruction);
                    }
                }
            } else if (instruction instanceof NewarrayInstruction) {
                object = (NewarrayInstruction)instruction;
                qExpression = new QNewArray((NewarrayInstruction)object, this.generateVar.pop());
            } else if (instruction instanceof MultiarrayInstruction) {
                object = (MultiarrayInstruction)instruction;
                QOperand[] qOperandArray = new QOperand[((MultiarrayInstruction)object).getDimension()];
                int n11 = qOperandArray.length - 1;
                while (n11 >= 0) {
                    qOperandArray[n11] = this.generateVar.pop();
                    --n11;
                }
                qExpression = new QMultiArray((MultiarrayInstruction)object, qOperandArray);
            } else {
                if (!(instruction instanceof JumpInstruction)) throw new InconsistencyException("Unknown Instruction" + n + ' ' + instruction);
                basicBlock.addInstruction(new QJsr(basicBlock.getDefaultNext()));
            }
            if (qExpression == null) return false;
            if (instruction2 != null && instruction2 instanceof LocalVarInstruction && ((LocalVarInstruction)instruction2).isStore()) {
                object = (LocalVarInstruction)instruction2;
                QVar qVar = this.generateVar.getVar(((LocalVarInstruction)object).getIndex(), ((LocalVarInstruction)object).getOperandType());
                this.verifyVarNotInStack(qVar, basicBlock);
                basicBlock.addInstruction(new QAssignment(qVar, qExpression));
                return true;
            }
            basicBlock.addInstruction(new QAssignment(this.generateVar.push(qExpression.getType()), qExpression));
        }
        return false;
    }

    public void initEntryStack(BasicBlock basicBlock, QOperand[] qOperandArray) {
        QOperand[] qOperandArray2 = new QOperand[qOperandArray.length];
        int n = 0;
        while (n < qOperandArray.length) {
            qOperandArray2[n] = this.generateVar.getNewVar(qOperandArray[n].getType());
            ++n;
        }
        basicBlock.setEntryStack(qOperandArray2);
    }

    public void setStack(QOperand[] qOperandArray) {
        if (qOperandArray == null) {
            return;
        }
        int n = 0;
        while (n < qOperandArray.length) {
            this.generateVar.push(qOperandArray[n]);
            ++n;
        }
    }

    public QOperand[] getStack() {
        return this.generateVar.removeElements();
    }

    public void addVariableConversionInstruction(BasicBlock basicBlock, QOperand[] qOperandArray, QOperand[] qOperandArray2) {
        int n = 0;
        while (n < qOperandArray.length) {
            basicBlock.addInstruction(new QAssignment(qOperandArray2[n], new QSimpleExpression(qOperandArray[n])));
            ++n;
        }
    }

    public void addInitException(BasicBlock basicBlock) {
        basicBlock.addInstruction(new QDeclareInitialised(this.generateVar.push((byte)6), true));
    }

    public void addInitException(BasicBlock basicBlock, Instruction instruction) {
        if (!(instruction instanceof LocalVarInstruction) || !((LocalVarInstruction)instruction).isStore()) {
            throw new InconsistencyException("Instruction in catch block must be a store");
        }
        int n = ((LocalVarInstruction)instruction).getIndex();
        basicBlock.addInstruction(new QDeclareInitialised(this.generateVar.getVar(n, (byte)6), true));
    }

    public void addInitSubroutine(BasicBlock basicBlock) {
        basicBlock.addInstruction(new QDeclareInitialised(this.generateVar.push((byte)1), true));
    }

    public void addInitSubroutine(BasicBlock basicBlock, Instruction instruction) {
        if (!(instruction instanceof LocalVarInstruction) || !((LocalVarInstruction)instruction).isStore()) {
            throw new InconsistencyException("Instruction in catch block must be a store");
        }
        int n = ((LocalVarInstruction)instruction).getIndex();
        basicBlock.addInstruction(new QDeclareInitialised(this.generateVar.getVar(n, (byte)1), true));
    }

    public void addJump(BasicBlock basicBlock) {
        basicBlock.addInstruction(new QJump(basicBlock.getDefaultNext()));
    }

    public int nbParam(MethodRefInstruction methodRefInstruction) {
        int n = this.nbParam(methodRefInstruction.getMethodRefConstant().getType());
        if (methodRefInstruction.getOpcode() != 184) {
            ++n;
        }
        return n;
    }

    public int nbParam(InvokeinterfaceInstruction invokeinterfaceInstruction) {
        int n = this.nbParam(invokeinterfaceInstruction.getInterfaceConstant().getType());
        return n + 1;
    }

    protected void verifyVarNotInStack(QVar qVar, BasicBlock basicBlock) {
        QVar qVar2 = this.generateVar.findVariableOnStack(qVar.getRegister());
        if (qVar2 != null) {
            QVar qVar3 = this.generateVar.getNewVar(qVar2.getType());
            basicBlock.addInstruction(new QAssignment(qVar3, new QSimpleExpression(qVar2)));
            this.generateVar.replaceVar(qVar.getRegister(), qVar3);
        }
    }

    protected int nbParam(String string) {
        int n = 0;
        if (string.charAt(0) != '(') {
            throw new InconsistencyException("invalid signature " + string);
        }
        int n2 = 1;
        block6: while (true) {
            switch (string.charAt(n2++)) {
                case ')': {
                    break block6;
                }
                case '[': {
                    while (string.charAt(n2) == '[') {
                        ++n2;
                    }
                    if (string.charAt(n2) == 'L') {
                        while (string.charAt(n2) != ';') {
                            ++n2;
                        }
                    }
                    ++n2;
                    ++n;
                    break;
                }
                case 'L': {
                    while (string.charAt(n2) != ';') {
                        ++n2;
                    }
                    ++n2;
                    ++n;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++n;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid signature " + string);
                }
            }
        }
        return n;
    }

    public QuadrupleGenerator(int n) {
        this.generateVar = new GenerateQVar(n);
    }
}

