/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.BasicBlock;
import at.dms.ssa.DominatorComputer;
import at.dms.ssa.DominatorTreeNode;
import at.dms.ssa.Edge;
import at.dms.ssa.ExceptionHandler;
import at.dms.ssa.Graph;
import at.dms.ssa.LivenessComputer;
import at.dms.ssa.Node;
import at.dms.ssa.NodeVisitor;
import at.dms.ssa.QInst;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QPhi;
import at.dms.ssa.QPhiCatch;
import at.dms.ssa.QPhiJoin;
import at.dms.ssa.QPhiReturn;
import at.dms.ssa.QSSAVar;
import at.dms.ssa.QVar;
import at.dms.ssa.SSAConstructorInfo;
import at.dms.ssa.SSAVar;
import at.dms.ssa.SubRoutine;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class SSAConstructor {
    protected Graph cfg;
    protected BasicBlock start;
    protected BasicBlock end;
    protected DominatorComputer dominatorComputer;
    protected Node[] nodes;
    protected BitSet varUsed;
    protected BitSet nonLocals;
    protected Collection subroutines;
    protected ExceptionHandler[] exceptionHandlers;
    protected BitSet[] ins;
    protected BitSet[] outs;

    public void constructSSAForm() {
        SSAVar.init();
        this.findUsedVar();
        int n = 0;
        while (n < this.varUsed.size()) {
            if (this.varUsed.get(n)) {
                SSAConstructorInfo sSAConstructorInfo = new SSAConstructorInfo(this, n);
                this.findUses(sSAConstructorInfo);
                this.placePhiFunctions(sSAConstructorInfo);
                this.renameVariable(sSAConstructorInfo);
                this.verifyPhiTypes(sSAConstructorInfo);
                this.insertPhiFunctions(sSAConstructorInfo);
            }
            ++n;
        }
    }

    protected void findUsedVar() {
        BitSet bitSet = this.varUsed;
        this.cfg.visitGraph(this.start, new NodeVisitor(this){
            final /* synthetic */ SSAConstructor this$0;

            public final boolean visit(Node node) {
                Iterator iterator = ((BasicBlock)node).getInstructions();
                while (iterator.hasNext()) {
                    QInst qInst = (QInst)iterator.next();
                    if (qInst.defVar() && qInst.getDefined().getOperand() instanceof QVar) {
                        this.this$0.varUsed.set(((QVar)qInst.getDefined().getOperand()).getRegister());
                    }
                    QOperandBox[] qOperandBoxArray = qInst.getUses();
                    int n = 0;
                    while (n < qOperandBoxArray.length) {
                        if (qOperandBoxArray[n].getOperand() instanceof QVar) {
                            this.this$0.varUsed.set(((QVar)qOperandBoxArray[n].getOperand()).getRegister());
                        }
                        ++n;
                    }
                }
                return true;
            }
            {
                this.this$0 = sSAConstructor;
            }
        });
    }

    protected void findUses(SSAConstructorInfo sSAConstructorInfo) {
        int n = sSAConstructorInfo.getVariableRegister();
        this.cfg.visitGraph(this.start, new NodeVisitor(this, n, sSAConstructorInfo){
            final /* synthetic */ SSAConstructor this$0;
            final /* synthetic */ int val$varIndex;
            final /* synthetic */ SSAConstructorInfo val$varInfo;

            public final boolean visit(Node node) {
                BasicBlock basicBlock = (BasicBlock)node;
                Iterator iterator = basicBlock.getInstructions();
                while (iterator.hasNext()) {
                    QOperandBox qOperandBox;
                    QInst qInst = (QInst)iterator.next();
                    QOperandBox[] qOperandBoxArray = qInst.getUses();
                    int n = 0;
                    while (n < qOperandBoxArray.length) {
                        QOperandBox qOperandBox2 = qOperandBoxArray[n];
                        if (qOperandBox2.getOperand() instanceof QVar && ((QVar)qOperandBox2.getOperand()).getRegister() == this.val$varIndex) {
                            this.val$varInfo.addUse(basicBlock, qOperandBox2);
                        }
                        ++n;
                    }
                    if (!qInst.defVar() || !((qOperandBox = qInst.getDefined()).getOperand() instanceof QVar) || ((QVar)qOperandBox.getOperand()).getRegister() != this.val$varIndex) continue;
                    this.val$varInfo.addDefinitionBlock(basicBlock);
                    this.val$varInfo.addUse(basicBlock, qOperandBox);
                }
                return true;
            }
            {
                this.this$0 = sSAConstructor;
                this.val$varIndex = n;
                this.val$varInfo = sSAConstructorInfo;
            }
        });
    }

    protected void placePhiFunctions(SSAConstructorInfo sSAConstructorInfo) {
        Object object;
        Object object2;
        if (!this.nonLocals.get(sSAConstructorInfo.getVariableRegister())) {
            return;
        }
        int n = 0;
        while (n < this.exceptionHandlers.length) {
            object2 = this.exceptionHandlers[n].getHandlerBlock();
            if (this.ins[((Node)object2).getIndex()].get(sSAConstructorInfo.getVariableRegister())) {
                sSAConstructorInfo.addPhiCatch((BasicBlock)object2);
                sSAConstructorInfo.addDefinitionBlock((BasicBlock)object2);
            }
            ++n;
        }
        Iterator iterator = this.subroutines.iterator();
        while (iterator.hasNext()) {
            object2 = (SubRoutine)iterator.next();
            object = ((SubRoutine)object2).getCalls();
            while (object.hasNext()) {
                Edge[] edgeArray = (Edge[])object.next();
                BasicBlock basicBlock = (BasicBlock)edgeArray[1].getTarget();
                if (!this.ins[basicBlock.getIndex()].get(sSAConstructorInfo.getVariableRegister())) continue;
                sSAConstructorInfo.addPhiReturn(basicBlock, (SubRoutine)object2);
                sSAConstructorInfo.addDefinitionBlock(basicBlock);
            }
        }
        object2 = this.dominatorComputer.getDFPlus(sSAConstructorInfo.getDefinitionBlocks()).iterator();
        while (object2.hasNext()) {
            object = (BasicBlock)this.nodes[(Integer)object2.next()];
            if (object == this.end || !this.ins[((Node)object).getIndex()].get(sSAConstructorInfo.getVariableRegister())) continue;
            sSAConstructorInfo.addPhiJoin((BasicBlock)object);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void renameVariable(SSAConstructorInfo var1_1) {
        this.search(var1_1, null, this.dominatorComputer.getTreeRoot());
        var2_2 = true;
        while (var2_2) {
            var2_2 = false;
            var3_3 = this.subroutines.iterator();
            while (var3_3.hasNext()) {
                var4_4 = (SubRoutine)var3_3.next();
                var5_5 = var4_4.getCalls();
                var6_6 = (QPhiJoin)var1_1.getPhiAtBlock(var4_4.getStart());
                if (var6_6 != null) ** GOTO lbl31
                continue;
lbl-1000:
                // 1 sources

                {
                    var7_7 = (Edge[])var5_5.next();
                    var8_8 = (QPhiReturn)var1_1.getPhiAtBlock((BasicBlock)var7_7[1].getTarget());
                    if (var8_8 == null || (var9_9 = ((QSSAVar)var8_8.getOperand().getOperand()).getSSAVar()) != ((QSSAVar)var6_6.getTarget()).getSSAVar()) continue;
                    if (var6_6.hasOperandForBlock((BasicBlock)var7_7[0].getSource())) {
                        var10_10 = ((QSSAVar)var6_6.getOperandForBlock((BasicBlock)var7_7[0].getSource()).getOperand()).getSSAVar();
                        var11_11 = ((QSSAVar)var8_8.getTarget()).getSSAVar();
                        var12_12 = var11_11.getUses();
                        while (var12_12.hasNext()) {
                            var13_13 = (QOperandBox)var12_12.next();
                            QSSAVar.newSSAVarUse(var13_13, (SSAVar)var10_10, var10_10.getType());
                        }
                        var9_9.removeUse(var8_8.getOperand());
                        var1_1.removePhiAtBlock((BasicBlock)var7_7[1].getTarget());
                        var2_2 = true;
                        continue;
                    }
                    if (((QSSAVar)var8_8.getTarget()).getSSAVar().getUses().hasNext()) continue;
                    var9_9.removeUse(var8_8.getOperand());
                    var1_1.removePhiAtBlock((BasicBlock)var7_7[1].getTarget());
lbl31:
                    // 5 sources

                    ** while (var5_5.hasNext())
                }
lbl32:
                // 1 sources

            }
        }
        var3_3 = this.subroutines.iterator();
        while (var3_3.hasNext()) {
            var4_4 = (SubRoutine)var3_3.next();
            var5_5 = var4_4.getCalls();
            while (var5_5.hasNext()) {
                var6_6 = (Edge[])var5_5.next();
                var7_7 = (Edge[])var1_1.getPhiAtBlock((BasicBlock)var6_6[1].getTarget());
                if (var7_7 == null || !(var7_7.getOperand().getOperand() instanceof QSSAVar)) continue;
                var8_8 = ((QSSAVar)var7_7.getOperand().getOperand()).getSSAVar();
                var9_9 = ((QSSAVar)var7_7.getTarget()).getSSAVar();
                var10_10 = var9_9.getUses();
                while (var10_10.hasNext()) {
                    var11_11 = (QOperandBox)var10_10.next();
                    QSSAVar.newSSAVarUse((QOperandBox)var11_11, (SSAVar)var8_8, var8_8.getType());
                }
                var8_8.removeUse(var7_7.getOperand());
                var1_1.removePhiAtBlock((BasicBlock)var6_6[1].getTarget());
            }
        }
    }

    protected void search(SSAConstructorInfo sSAConstructorInfo, SSAVar sSAVar, DominatorTreeNode dominatorTreeNode) {
        Object object;
        Object object2;
        QPhi qPhi;
        LinkedList linkedList = new LinkedList();
        BasicBlock basicBlock = (BasicBlock)dominatorTreeNode.getNode();
        if (sSAVar != null) {
            this.findCatchBlocks(basicBlock, linkedList);
            this.addCatchPhiOperands(sSAConstructorInfo, sSAVar, linkedList);
        }
        if ((qPhi = sSAConstructorInfo.getPhiAtBlock(basicBlock)) != null) {
            object2 = qPhi.getDefined();
            object = (QVar)((QOperandBox)object2).getOperand();
            int n = 0;
            if (sSAVar == null) {
                this.findCatchBlocks(basicBlock, linkedList);
            } else {
                n = sSAVar.getCount() + 1;
            }
            sSAVar = qPhi.getUses().length > 0 ? new SSAVar(((QVar)object).getRegister(), qPhi.getUses()[0].getOperand().getType(), n) : new SSAVar(((QVar)object).getRegister(), ((QVar)object).getType(), n);
            QSSAVar.newSSAVarDefinition((QOperandBox)object2, sSAVar);
        }
        object2 = sSAConstructorInfo.getUsesAtBlock(basicBlock);
        while (object2.hasNext()) {
            object = (QOperandBox)object2.next();
            if (((QOperandBox)object).isDefinition()) {
                QVar qVar = (QVar)((QOperandBox)object).getOperand();
                int n = 0;
                if (sSAVar == null) {
                    this.findCatchBlocks(basicBlock, linkedList);
                } else {
                    n = sSAVar.getCount() + 1;
                }
                sSAVar = new SSAVar(qVar.getRegister(), qVar.getType(), n);
                QSSAVar.newSSAVarDefinition((QOperandBox)object, sSAVar);
                this.addCatchPhiOperands(sSAConstructorInfo, sSAVar, linkedList);
                continue;
            }
            if (sSAVar == null) {
                System.out.println("Error2 : " + sSAConstructorInfo.getVariableRegister());
            }
            QSSAVar.newSSAVarUse((QOperandBox)object, sSAVar, ((QOperandBox)object).getOperand().getType());
        }
        linkedList = null;
        if (sSAVar != null) {
            object = basicBlock.getSuccessors();
            while (object.hasNext()) {
                BasicBlock basicBlock2 = (BasicBlock)object.next();
                QPhi qPhi2 = sSAConstructorInfo.getPhiAtBlock(basicBlock2);
                if (qPhi2 instanceof QPhiJoin) {
                    QSSAVar.newSSAVarUse(((QPhiJoin)qPhi2).getOperandForBlock(basicBlock), sSAVar, sSAVar.getType());
                } else if (qPhi2 instanceof QPhiReturn) {
                    QSSAVar.newSSAVarUse(((QPhiReturn)qPhi2).getOperand(), sSAVar, sSAVar.getType());
                }
                LinkedList linkedList2 = new LinkedList();
                this.findCatchBlocks(basicBlock, linkedList2);
                this.addCatchPhiOperands(sSAConstructorInfo, sSAVar, linkedList2);
            }
        }
        object = dominatorTreeNode.getSuccessors();
        while (object.hasNext()) {
            DominatorTreeNode dominatorTreeNode2 = (DominatorTreeNode)object.next();
            this.search(sSAConstructorInfo, sSAVar, dominatorTreeNode2);
        }
    }

    protected void findCatchBlocks(BasicBlock basicBlock, LinkedList linkedList) {
        int n = 0;
        while (n < this.exceptionHandlers.length) {
            if (this.exceptionHandlers[n].contains(basicBlock)) {
                linkedList.add(this.exceptionHandlers[n].getHandlerBlock());
            }
            ++n;
        }
    }

    protected void addCatchPhiOperands(SSAConstructorInfo sSAConstructorInfo, SSAVar sSAVar, LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            BasicBlock basicBlock = (BasicBlock)iterator.next();
            QPhiCatch qPhiCatch = (QPhiCatch)sSAConstructorInfo.getPhiAtBlock(basicBlock);
            if (qPhiCatch == null || qPhiCatch.getTarget() instanceof QSSAVar && ((QSSAVar)qPhiCatch.getTarget()).getUniqueIndex() == sSAVar.getUniqueIndex() || qPhiCatch.hasSSAVarAsOperand(sSAVar)) continue;
            QSSAVar.newSSAVarUse(qPhiCatch.addNewOperand(), sSAVar, sSAVar.getType());
        }
    }

    protected void insertPhiFunctions(SSAConstructorInfo sSAConstructorInfo) {
        int n = 0;
        while (n < this.nodes.length) {
            BasicBlock basicBlock = (BasicBlock)this.nodes[n];
            QPhi qPhi = sSAConstructorInfo.getPhiAtBlock(basicBlock);
            if (qPhi != null) {
                if (qPhi instanceof QPhiCatch && qPhi.getUses().length == 0) {
                    SSAVar sSAVar = ((QSSAVar)qPhi.getTarget()).getSSAVar();
                    Iterator iterator = sSAVar.getUses();
                    while (iterator.hasNext()) {
                        QOperandBox qOperandBox = (QOperandBox)iterator.next();
                        QInst qInst = qOperandBox.getInstruction();
                        if (qInst instanceof QPhiCatch) {
                            ((QPhiCatch)qInst).removeOperand(qOperandBox);
                            continue;
                        }
                        if (!(qInst instanceof QPhiJoin)) continue;
                        ((QPhiJoin)qInst).removeOperand(qOperandBox);
                    }
                } else {
                    basicBlock.addPhi(qPhi);
                }
            }
            ++n;
        }
    }

    protected void verifyPhiTypes(SSAConstructorInfo sSAConstructorInfo) {
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < this.nodes.length) {
                SSAVar sSAVar;
                BasicBlock basicBlock = (BasicBlock)this.nodes[n];
                QPhi qPhi = sSAConstructorInfo.getPhiAtBlock(basicBlock);
                if (qPhi != null && (sSAVar = ((QSSAVar)qPhi.getTarget()).getSSAVar()).getType() == 6) {
                    QOperandBox[] qOperandBoxArray = qPhi.getUses();
                    int n2 = 0;
                    while (n2 < qOperandBoxArray.length) {
                        byte by = qOperandBoxArray[n2].getOperand().getType();
                        if (by != 6) {
                            sSAVar.setType(by);
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    Node[] getBasicBlockArray() {
        return this.nodes;
    }

    public SSAConstructor(Graph graph, BasicBlock basicBlock, BasicBlock basicBlock2, BitSet bitSet, ExceptionHandler[] exceptionHandlerArray, Collection collection) {
        this.cfg = graph;
        this.start = basicBlock;
        this.end = basicBlock2;
        graph.setNodesIndex();
        this.nodes = graph.getNodes();
        this.dominatorComputer = new DominatorComputer(this.nodes, basicBlock);
        this.varUsed = new BitSet(bitSet.size());
        this.nonLocals = bitSet;
        this.exceptionHandlers = exceptionHandlerArray;
        this.subroutines = collection;
        LivenessComputer livenessComputer = new LivenessComputer(graph, basicBlock, exceptionHandlerArray);
        this.ins = new BitSet[this.nodes.length];
        this.outs = new BitSet[this.nodes.length];
        int n = 0;
        while (n < this.nodes.length) {
            this.ins[n] = new BitSet();
            this.outs[n] = new BitSet();
            ++n;
        }
        livenessComputer.computeNonSSALivenessAnalysis(this.ins, this.outs);
    }
}

