/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.BasicBlock;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QPhi;
import at.dms.ssa.QPhiCatch;
import at.dms.ssa.QPhiJoin;
import at.dms.ssa.QPhiReturn;
import at.dms.ssa.QVar;
import at.dms.ssa.SSAConstructor;
import at.dms.ssa.SubRoutine;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class SSAConstructorInfo {
    protected int var;
    protected Set definitionBlocks;
    protected LinkedList[] usesOperandBox;
    protected SSAConstructor ssaConstructor;
    protected QPhi[] phis;

    public int getVariableRegister() {
        return this.var;
    }

    public void addDefinitionBlock(BasicBlock basicBlock) {
        this.definitionBlocks.add(new Integer(basicBlock.getIndex()));
    }

    public void addUse(BasicBlock basicBlock, QOperandBox qOperandBox) {
        LinkedList linkedList = this.usesOperandBox[basicBlock.getIndex()];
        linkedList.add(qOperandBox);
    }

    public Iterator getUsesAtBlock(BasicBlock basicBlock) {
        return this.usesOperandBox[basicBlock.getIndex()].iterator();
    }

    public Set getDefinitionBlocks() {
        return this.definitionBlocks;
    }

    public QPhi getPhiAtBlock(BasicBlock basicBlock) {
        return this.phis[basicBlock.getIndex()];
    }

    public void addPhiCatch(BasicBlock basicBlock) {
        if (this.phis[basicBlock.getIndex()] != null) {
            return;
        }
        QVar qVar = new QVar(this.var, 6);
        this.phis[basicBlock.getIndex()] = new QPhiCatch(qVar);
    }

    public void addPhiReturn(BasicBlock basicBlock, SubRoutine subRoutine) {
        if (this.phis[basicBlock.getIndex()] != null) {
            return;
        }
        QVar qVar = new QVar(this.var, 6);
        this.phis[basicBlock.getIndex()] = new QPhiReturn(qVar, subRoutine);
    }

    public void addPhiJoin(BasicBlock basicBlock) {
        if (this.phis[basicBlock.getIndex()] != null) {
            return;
        }
        QVar qVar = new QVar(this.var, 6);
        this.phis[basicBlock.getIndex()] = new QPhiJoin(qVar, basicBlock);
    }

    public void removePhiAtBlock(BasicBlock basicBlock) {
        this.phis[basicBlock.getIndex()] = null;
    }

    public SSAConstructorInfo(SSAConstructor sSAConstructor, int n) {
        this.ssaConstructor = sSAConstructor;
        this.var = n;
        this.definitionBlocks = new HashSet();
        int n2 = sSAConstructor.getBasicBlockArray().length;
        this.usesOperandBox = new LinkedList[n2];
        this.phis = new QPhi[n2];
        int n3 = 0;
        while (n3 < this.usesOperandBox.length) {
            this.usesOperandBox[n3] = new LinkedList();
            ++n3;
        }
    }
}

