/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ssa;

import at.dms.ssa.BasicBlock;
import at.dms.ssa.Node;
import at.dms.ssa.QInst;
import at.dms.ssa.QInstArray;
import at.dms.ssa.QOperandBox;
import at.dms.ssa.QPhi;
import at.dms.ssa.QPhiCatch;
import at.dms.ssa.QSSAVar;
import at.dms.ssa.SSAVar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class UnusedComputer {
    protected Node[] nodes;

    public void removeUnusedVariables() {
        LinkedList linkedList = new LinkedList();
        int n = 0;
        while (n < this.nodes.length) {
            Object object;
            BasicBlock basicBlock = (BasicBlock)this.nodes[n];
            Iterator iterator = basicBlock.getPhis();
            while (iterator.hasNext()) {
                object = (QInst)iterator.next();
                this.tryRemoveInstruction((QInst)object, linkedList);
            }
            object = basicBlock.getInstructionsArray();
            int n2 = ((QInstArray)object).size() - 1;
            while (n2 >= 0) {
                QInst qInst = ((QInstArray)object).getInstructionAt(n2);
                this.tryRemoveInstruction(qInst, linkedList);
                --n2;
            }
            ++n;
        }
        while (!linkedList.isEmpty()) {
            QInst qInst = (QInst)linkedList.removeFirst();
            if (!qInst.isAttached()) continue;
            this.tryRemoveInstruction(qInst, linkedList);
        }
    }

    public void removeUnusefullPhis() {
        LinkedList linkedList = new LinkedList();
        int n = 0;
        while (n < this.nodes.length) {
            BasicBlock basicBlock = (BasicBlock)this.nodes[n];
            Iterator iterator = basicBlock.getPhis();
            while (iterator.hasNext()) {
                QPhi qPhi = (QPhi)iterator.next();
                this.tryRemovePhi(qPhi, linkedList);
            }
            ++n;
        }
        while (!linkedList.isEmpty()) {
            QPhi qPhi = (QPhi)linkedList.removeFirst();
            if (!qPhi.isAttached()) continue;
            this.tryRemovePhi(qPhi, linkedList);
        }
    }

    protected void tryRemoveInstruction(QInst qInst, LinkedList linkedList) {
        SSAVar sSAVar;
        if (qInst.defVar() && qInst.getDefined().getOperand() instanceof QSSAVar && !(sSAVar = ((QSSAVar)qInst.getDefined().getOperand()).getSSAVar()).isUsed() && !qInst.hasSideEffects()) {
            QOperandBox[] qOperandBoxArray = qInst.getUses();
            int n = 0;
            while (n < qOperandBoxArray.length) {
                QOperandBox qOperandBox = qOperandBoxArray[n];
                if (qOperandBox.getOperand() instanceof QSSAVar) {
                    linkedList.add(((QSSAVar)qOperandBox.getOperand()).getSSAVar().getDefinition().getInstruction());
                }
                ++n;
            }
            qInst.removeSSAInstruction();
        }
    }

    protected void tryRemovePhi(QPhi qPhi, LinkedList linkedList) {
        if (qPhi.getDefined().getOperand() instanceof QSSAVar) {
            Object object;
            Object object2;
            SSAVar sSAVar = ((QSSAVar)qPhi.getDefined().getOperand()).getSSAVar();
            Iterator iterator = sSAVar.getUses();
            HashSet<Object> hashSet = new HashSet<Object>();
            while (iterator.hasNext()) {
                object2 = (QOperandBox)iterator.next();
                if (!(((QOperandBox)object2).getInstruction() instanceof QPhiCatch)) {
                    return;
                }
                hashSet.add(object2);
            }
            object2 = qPhi.getUses();
            int n = 0;
            while (n < ((Object)object2).length) {
                object = object2[n];
                SSAVar sSAVar2 = ((QSSAVar)((QOperandBox)object).getOperand()).getSSAVar();
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    QPhiCatch qPhiCatch = (QPhiCatch)((QOperandBox)iterator.next()).getInstruction();
                    if (qPhiCatch.hasSSAVarAsOperand(sSAVar2)) continue;
                    QSSAVar.newSSAVarUse(qPhiCatch.addNewOperand(), sSAVar2, sSAVar2.getType());
                }
                if (sSAVar2.getDefinition().getInstruction() instanceof QPhi) {
                    linkedList.add(sSAVar2.getDefinition().getInstruction());
                }
                ++n;
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                QOperandBox qOperandBox = (QOperandBox)iterator.next();
                object = (QPhiCatch)qOperandBox.getInstruction();
                ((QPhiCatch)object).removeOperand(qOperandBox);
            }
            qPhi.removeSSAInstruction();
        }
    }

    public UnusedComputer(Node[] nodeArray) {
        this.nodes = nodeArray;
    }
}

