/*
 * Decompiled with CFR 0.152.
 */
package at.dms.xtype;

import at.dms.xtype.NotNullDate;
import at.dms.xtype.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Date
extends Type {
    private static GregorianCalendar calendar = new GregorianCalendar();
    private static final NotNullDate ORIGIN;
    public static final NotNullDate DEFAULT;
    private int scalar;

    public static NotNullDate now() {
        return new NotNullDate((int)(System.currentTimeMillis() / 86400000L) + Date.ORIGIN.scalar);
    }

    public static NotNullDate parse(String string, String string2) throws IllegalArgumentException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            gregorianCalendar.setTime(new SimpleDateFormat(string2).parse(string));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw new IllegalArgumentException(parseException.getMessage());
        }
        return new NotNullDate(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
    }

    public static NotNullDate parse(String string, String string2, Locale locale) throws IllegalArgumentException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            gregorianCalendar.setTime(new SimpleDateFormat(string2, locale).parse(string));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw new IllegalArgumentException(parseException.getMessage());
        }
        return new NotNullDate(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
    }

    public void setScalar(int n) {
        this.scalar = n;
    }

    public int getScalar() {
        return this.scalar;
    }

    public int getYear() {
        return Date.julianToGregorian(this.scalar)[0];
    }

    public int getMonth() {
        return Date.julianToGregorian(this.scalar)[1];
    }

    public int getDay() {
        return Date.julianToGregorian(this.scalar)[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWeekday() {
        GregorianCalendar gregorianCalendar = calendar;
        synchronized (gregorianCalendar) {
            int[] nArray = Date.julianToGregorian(this.scalar);
            calendar.set(1, nArray[0]);
            calendar.set(2, nArray[1] - 1);
            calendar.set(5, nArray[2]);
            return calendar.get(7);
        }
    }

    public int getDayOfWeek() {
        return this.getWeekday();
    }

    public NotNullDate add(int n) {
        return new NotNullDate(this.scalar + n);
    }

    public Integer subtract(Date date) {
        return date == null ? null : new Integer(this.subtract((NotNullDate)date));
    }

    public int subtract(NotNullDate notNullDate) {
        return this.scalar - notNullDate.scalar;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Date && this.scalar == ((Date)object).scalar) {
            bl = true;
        }
        return bl;
    }

    public int compareTo(Date date) {
        int n;
        int n2 = this.scalar;
        int n3 = date.scalar;
        if (n2 < n3) {
            n = -1;
        } else {
            n = 0;
            if (n2 > n3) {
                n = 1;
            }
        }
        return n;
    }

    public String toString(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = Date.julianToGregorian(this.scalar);
        if (locale == Locale.GERMAN || locale == Locale.FRENCH) {
            stringBuffer.append(nArray[2] / 10);
            stringBuffer.append(nArray[2] % 10);
            stringBuffer.append('.');
            stringBuffer.append(nArray[1] / 10);
            stringBuffer.append(nArray[1] % 10);
            stringBuffer.append('.');
            stringBuffer.append(nArray[0]);
        } else if (locale == Locale.US || locale == Locale.ENGLISH) {
            stringBuffer.append(nArray[1] / 10);
            stringBuffer.append(nArray[1] % 10);
            stringBuffer.append('/');
            stringBuffer.append(nArray[2] / 10);
            stringBuffer.append(nArray[2] % 10);
            stringBuffer.append('/');
            stringBuffer.append(nArray[0]);
        } else {
            stringBuffer.append(nArray[0]);
            stringBuffer.append('.');
            stringBuffer.append(nArray[1] / 10);
            stringBuffer.append(nArray[1] % 10);
            stringBuffer.append('.');
            stringBuffer.append(nArray[2] / 10);
            stringBuffer.append(nArray[2] % 10);
        }
        return stringBuffer.toString();
    }

    public String toSql() {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = Date.julianToGregorian(this.scalar);
        stringBuffer.append("{d '");
        stringBuffer.append(nArray[0]);
        stringBuffer.append('-');
        stringBuffer.append(nArray[1] / 10);
        stringBuffer.append(nArray[1] % 10);
        stringBuffer.append('-');
        stringBuffer.append(nArray[2] / 10);
        stringBuffer.append(nArray[2] % 10);
        stringBuffer.append("'}");
        return stringBuffer.toString();
    }

    private static final int gregorianToJulian(int n, int n2, int n3) {
        if (n2 > 2) {
            n2 -= 3;
        } else {
            n2 += 9;
            --n;
        }
        int n4 = n / 100;
        return (146097 * n4 >> 2) + (1461 * (n %= 100) >> 2) + (153 * n2 + 2) / 5 + n3 + 1721119;
    }

    private static final int[] julianToGregorian(int n) {
        int n2 = n - 1721119;
        int n3 = ((n2 << 2) - 1) / 146097;
        n2 = (n2 << 2) - 1 - 146097 * n3;
        int n4 = n2 >> 2;
        n2 = ((n4 << 2) + 3) / 1461;
        n4 = (n4 << 2) + 3 - 1461 * n2;
        n4 = n4 + 4 >> 2;
        int n5 = (5 * n4 - 3) / 153;
        n4 = 5 * n4 - 3 - 153 * n5;
        n4 = (n4 + 5) / 5;
        n3 = 100 * n3 + n2;
        n5 = n5 < 10 ? (n5 += 3) : (n5 -= 9);
        return new int[]{++n3, n5, n4};
    }

    Date(int n, int n2, int n3) {
        this.scalar = Date.gregorianToJulian(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Date(java.sql.Date date) {
        GregorianCalendar gregorianCalendar = calendar;
        synchronized (gregorianCalendar) {
            calendar.setTime(date);
            this.scalar = Date.gregorianToJulian(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
            return;
        }
    }

    Date(String string) throws IllegalArgumentException {
        Pattern pattern = Pattern.compile("(\\d\\d\\d\\d)[-.]{1}(\\d\\d?)[-.]{1}(\\d\\d?)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid date string " + string);
        }
        String[] stringArray = Pattern.compile("[-.]").split(string);
        this.scalar = Date.gregorianToJulian(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
    }

    Date(int n) {
        this.scalar = n;
    }

    static {
        calendar.setMinimalDaysInFirstWeek(4);
        ORIGIN = new NotNullDate(1970, 1, 1);
        DEFAULT = new NotNullDate(0);
    }
}

