/*
 * Decompiled with CFR 0.152.
 */
package at.dms.xtype;

import at.dms.xtype.Date;
import at.dms.xtype.NotNullDate;
import at.dms.xtype.NotNullMonth;
import at.dms.xtype.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class Month
extends Type {
    public static final NotNullMonth DEFAULT = new NotNullMonth(1900, 1);
    private int scalar;

    public static NotNullMonth now() {
        Calendar calendar = Calendar.getInstance();
        return new NotNullMonth(calendar.get(1), calendar.get(2) + 1);
    }

    public static NotNullMonth parse(String string, String string2) throws IllegalArgumentException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            gregorianCalendar.setTime(new SimpleDateFormat(string2).parse(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException();
        }
        return new NotNullMonth(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1);
    }

    public NotNullMonth copy() {
        return new NotNullMonth(this.scalar / 12, this.scalar % 12 + 1);
    }

    public void addTo(int n) {
        this.scalar += n;
    }

    public NotNullMonth add(int n) {
        return new NotNullMonth((this.scalar + n) / 12, (this.scalar + n) % 12 + 1);
    }

    public Integer subtract(Month month) {
        return month == null ? null : new Integer(this.subtract((NotNullMonth)month));
    }

    public int subtract(NotNullMonth notNullMonth) {
        return this.scalar - notNullMonth.scalar;
    }

    public int compareTo(Month month) {
        int n;
        int n2 = this.scalar;
        int n3 = month.scalar;
        if (n2 < n3) {
            n = -1;
        } else {
            n = 0;
            if (n2 > n3) {
                n = 1;
            }
        }
        return n;
    }

    public int getYear() {
        return this.scalar / 12;
    }

    public int getMonth() {
        return this.scalar % 12 + 1;
    }

    public NotNullDate getFirstDay() {
        return new NotNullDate(this.scalar / 12, this.scalar % 12 + 1, 1);
    }

    public NotNullDate getLastDay() {
        return new NotNullDate((this.scalar + 1) / 12, (this.scalar + 1) % 12 + 1, 1).add(-1);
    }

    public NotNullDate getDate() {
        return this.getFirstDay();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Month && this.scalar == ((Month)object).scalar) {
            bl = true;
        }
        return bl;
    }

    public String toString(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.scalar / 12;
        int n2 = this.scalar % 12 + 1;
        if (locale == Locale.GERMAN || locale == Locale.FRENCH || locale == Locale.US || locale == Locale.ENGLISH) {
            stringBuffer.append(n2 / 10);
            stringBuffer.append(n2 % 10);
            stringBuffer.append('.');
            stringBuffer.append(n);
        } else {
            stringBuffer.append(n);
            stringBuffer.append('.');
            stringBuffer.append(n2 / 10);
            stringBuffer.append(n2 % 10);
        }
        return stringBuffer.toString();
    }

    public String toSql() {
        int n = this.scalar / 12;
        int n2 = this.scalar % 12 + 1;
        return "{fn MONTH(" + n + ", " + n2 + ")}";
    }

    Month(int n, int n2) {
        this.scalar = n * 12 + n2 - 1;
    }

    Month(Date date) {
        this(date.getYear(), date.getMonth());
    }
}

