/*
 * Decompiled with CFR 0.152.
 */
package at.dms.xtype;

import at.dms.xtype.NotNullTime;
import at.dms.xtype.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class Time
extends Type {
    private static GregorianCalendar calendar = new GregorianCalendar();
    public static final Time DEFAULT = new Time(0, 0, 0);
    private int scalar;

    public static NotNullTime now() {
        Calendar calendar = Calendar.getInstance();
        return new NotNullTime(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static NotNullTime parse(String string, String string2) throws IllegalArgumentException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            gregorianCalendar.setTime(new SimpleDateFormat(string2).parse(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException();
        }
        return new NotNullTime(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13));
    }

    public void setScalar(int n) {
        this.scalar = n;
    }

    public int getScalar() {
        return this.scalar;
    }

    public NotNullTime add(int n) {
        return new NotNullTime(this.scalar + n);
    }

    public int compareTo(Time time) {
        int n;
        int n2 = this.scalar;
        int n3 = time.scalar;
        if (n2 < n3) {
            n = -1;
        } else {
            n = 0;
            if (n2 > n3) {
                n = 1;
            }
        }
        return n;
    }

    public int getHours() {
        return this.scalar / 3600;
    }

    public int getMinutes() {
        return this.scalar / 60 % 60;
    }

    public int getSeconds() {
        return this.scalar % 60;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.Time getSqlTime() {
        GregorianCalendar gregorianCalendar = calendar;
        synchronized (gregorianCalendar) {
            calendar.set(11, this.scalar / 3600);
            calendar.set(12, this.scalar / 60 % 60);
            calendar.set(13, this.scalar % 60);
            return new java.sql.Time(calendar.getTime().getTime());
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Time && ((Time)object).scalar == this.scalar) {
            bl = true;
        }
        return bl;
    }

    public String toString(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.scalar / 3600;
        int n2 = this.scalar / 60 % 60;
        stringBuffer.append(n / 10);
        stringBuffer.append(n % 10);
        stringBuffer.append(':');
        stringBuffer.append(n2 / 10);
        stringBuffer.append(n2 % 10);
        return stringBuffer.toString();
    }

    public String toSql() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.scalar / 3600;
        int n2 = this.scalar / 60 % 60;
        int n3 = this.scalar % 60;
        stringBuffer.append("{t '");
        stringBuffer.append(n / 10);
        stringBuffer.append(n % 10);
        stringBuffer.append(':');
        stringBuffer.append(n2 / 10);
        stringBuffer.append(n2 % 10);
        stringBuffer.append(':');
        stringBuffer.append(n3 / 10);
        stringBuffer.append(n3 % 10);
        stringBuffer.append("'}");
        return stringBuffer.toString();
    }

    Time(int n, int n2, int n3) {
        this.scalar = (n * 3600 + n2 * 60 + n3) % 86400;
    }

    Time(int n, int n2) {
        this(n, n2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Time(java.sql.Time time) {
        GregorianCalendar gregorianCalendar = calendar;
        synchronized (gregorianCalendar) {
            calendar.setTime(time);
            int n = calendar.get(11);
            int n2 = calendar.get(12);
            int n3 = calendar.get(13);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var5_2
            this.scalar = (n * 3600 + n2 * 60 + n3) % 86400;
            return;
        }
    }

    Time(String string) throws IllegalArgumentException {
        this(java.sql.Time.valueOf(string));
    }

    Time(int n) {
        this.scalar = n % 86400;
    }
}

