/*
 * Decompiled with CFR 0.152.
 */
package at.dms.xtype;

import at.dms.xtype.Date;
import at.dms.xtype.NotNullDate;
import at.dms.xtype.NotNullWeek;
import at.dms.xtype.Type;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class Week
extends Type {
    private static final int[] DAYS_BEFORE_MONTH;
    private static GregorianCalendar calendar;
    public static final NotNullWeek DEFAULT;
    private int scalar;

    public static NotNullWeek now() {
        Calendar calendar = Calendar.getInstance();
        return new NotNullWeek(calendar.get(1), calendar.get(3));
    }

    public NotNullWeek copy() {
        return new NotNullWeek(this.scalar / 53, this.scalar % 53 + 1);
    }

    public void addTo(int n) {
        this.scalar += n;
    }

    public NotNullWeek add(int n) {
        return new NotNullWeek((this.scalar + n) / 53, (this.scalar + n) % 53 + 1);
    }

    public Integer subtract(Week week) {
        return week == null ? null : new Integer(this.subtract((NotNullWeek)week));
    }

    public int subtract(NotNullWeek notNullWeek) {
        return this.scalar - notNullWeek.scalar;
    }

    public int compareTo(Week week) {
        int n;
        int n2 = this.scalar;
        int n3 = week.scalar;
        if (n2 < n3) {
            n = -1;
        } else {
            n = 0;
            if (n2 > n3) {
                n = 1;
            }
        }
        return n;
    }

    public int getWeek() {
        return this.scalar % 53 + 1;
    }

    public int getYear() {
        return this.scalar / 53;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NotNullDate getDate(int n) {
        GregorianCalendar gregorianCalendar = calendar;
        synchronized (gregorianCalendar) {
            calendar.clear();
            calendar.set(1, this.scalar / 53);
            calendar.set(3, this.scalar % 53 + 1);
            calendar.set(7, n % 7 + 1);
            int n2 = calendar.get(1);
            int n3 = calendar.get(2) + 1;
            int n4 = calendar.get(5);
            return new NotNullDate(n2, n3, n4);
        }
    }

    public NotNullDate getFirstDay() {
        return this.getDate(1);
    }

    public NotNullDate getLastDay() {
        return this.getDate(7);
    }

    public NotNullDate getDate() {
        return this.getDate(1);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Week && this.scalar == ((Week)object).scalar) {
            bl = true;
        }
        return bl;
    }

    public String toString(Locale locale) {
        int n = this.scalar / 53;
        int n2 = this.scalar % 53 + 1;
        if (locale == Locale.GERMAN || locale == Locale.FRENCH || locale == Locale.US || locale == Locale.ENGLISH) {
            return (n2 < 10 ? "0" + n2 : "" + n2) + '.' + n;
        }
        return "" + n + '.' + (n2 < 10 ? "0" + n2 : "" + n2);
    }

    public String toSql() {
        int n = this.scalar / 53;
        int n2 = this.scalar % 53 + 1;
        return "{fn WEEK(" + n + ", " + n2 + ")}";
    }

    private static final int iso8601(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = Week.isLeapYear(n);
        boolean bl = Week.isLeapYear(n - 1);
        int n7 = n3 + DAYS_BEFORE_MONTH[n2 - 1];
        if (n6 != 0 && n2 > 2) {
            ++n7;
        }
        int n8 = (n - 1) % 100;
        int n9 = n - 1 - n8;
        int n10 = n8 + n8 / 4;
        int n11 = 1 + (n9 / 100 % 4 * 5 + n10) % 7;
        int n12 = n7 + (n11 - 1);
        int n13 = 1 + (n12 - 1) % 7;
        if (n7 <= 8 - n11 && n11 > 4) {
            n5 = n - 1;
            int n14 = 0;
            if (n11 == 5 || n11 == 6 && bl) {
                n14 = 1;
            }
            n4 = n14 + 52;
        } else {
            n5 = n;
            n4 = -10000000;
        }
        int n15 = n6 + 365;
        if (n15 - n7 < 4 - n13) {
            n5 = n + 1;
            n4 = 1;
        }
        if (n5 == n) {
            int n16 = n7 + (7 - n13) + (n11 - 1);
            n4 = n16 / 7;
            if (n11 > 4) {
                --n4;
            }
        }
        return n5 * 53 + n4 - 1;
    }

    private static final boolean isLeapYear(int n) {
        boolean bl = false;
        if (n % 4 == 0 && n % 100 != 0 || n % 400 == 0) {
            bl = true;
        }
        return bl;
    }

    Week(int n, int n2) {
        this.scalar = n * 53 + n2 - 1;
    }

    Week(Date date) {
        this.scalar = Week.iso8601(date.getYear(), date.getMonth(), date.getDay());
    }

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        DAYS_BEFORE_MONTH = nArray;
        calendar = new GregorianCalendar();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        DEFAULT = new NotNullWeek(0, 0);
    }
}

