/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.classpath.RawData;
import gnu.java.nio.MappedByteFileBuffer;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChannelImpl
extends FileChannel {
    RawData map_address;
    int length;
    FileDescriptor fd;
    MappedByteBuffer buf;
    Object file_obj;

    public FileChannelImpl(FileDescriptor fileDescriptor, boolean bl, Object object) {
        if (!(object instanceof RandomAccessFile || object instanceof FileInputStream || object instanceof FileOutputStream)) {
            throw new InternalError();
        }
        this.fd = fileDescriptor;
        this.file_obj = object;
    }

    public FileChannelImpl() {
        this(new FileDescriptor(), true, null);
    }

    private native long implPosition();

    private native FileChannel implPosition(long var1);

    private native FileChannel implTruncate(long var1);

    private native RawData nio_mmap_file(long var1, long var3, int var5);

    private native void nio_unmmap_file(RawData var1, int var2);

    private native void nio_msync(RawData var1, int var2);

    @Override
    public native long size() throws IOException;

    @Override
    protected void implCloseChannel() throws IOException {
        if (this.map_address != null) {
            this.nio_unmmap_file(this.map_address, this.length);
            this.map_address = null;
        }
        if (this.file_obj instanceof RandomAccessFile) {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.file_obj;
            randomAccessFile.close();
            return;
        }
        if (this.file_obj instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)this.file_obj;
            fileInputStream.close();
            return;
        }
        if (this.file_obj instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)this.file_obj;
            fileOutputStream.close();
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.buf != null) {
            throw new Error("Accessing mapped buffers not implemented.");
        }
        return this.implRead(byteBuffer);
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileOutputStream) {
            throw new NonReadableChannelException();
        }
        long l2 = this.implPosition();
        int n = this.implRead(byteBuffer);
        this.implPosition(l2);
        return n;
    }

    private int implRead(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[byteBuffer.remaining()];
        int n = this.implRead(byArray, 0, byArray.length);
        byteBuffer.put(byArray, 0, n);
        return n;
    }

    private native int implRead(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        int n3 = n;
        while (n3 < n + n2) {
            l += (long)this.read(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.buf != null) {
            throw new Error("Accessing mapped buffers not implemented.");
        }
        return this.implWrite(byteBuffer);
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        long l2 = this.implPosition();
        int n = this.implWrite(byteBuffer);
        this.implPosition(l2);
        return n;
    }

    private int implWrite(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray, 0, byArray.length);
        return this.implWrite(byArray, 0, byArray.length);
    }

    private native int implWrite(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        int n3 = n;
        while (n3 < n + n2) {
            l += (long)this.write(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        if (mapMode != FileChannel.MapMode.READ_ONLY && mapMode != FileChannel.MapMode.READ_WRITE && mapMode != FileChannel.MapMode.PRIVATE || l < 0L || l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int n = mapMode.m;
        this.map_address = this.nio_mmap_file(l, l2, n);
        this.length = (int)l2;
        this.buf = new MappedByteFileBuffer(this);
        return this.buf;
    }

    static MappedByteBuffer create_direct_mapped_buffer(RawData rawData, long l) throws IOException {
        FileChannelImpl fileChannelImpl = new FileChannelImpl();
        fileChannelImpl.map_address = rawData;
        fileChannelImpl.length = (int)l;
        fileChannelImpl.buf = new MappedByteFileBuffer(fileChannelImpl);
        return fileChannelImpl.buf;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public void force(boolean bl) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.nio_msync(this.map_address, this.length);
    }

    @Override
    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileOutputStream) {
            throw new NonReadableChannelException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l2);
        this.read(byteBuffer, l);
        return writableByteChannel.write(byteBuffer);
    }

    @Override
    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l2);
        readableByteChannel.read(byteBuffer);
        return this.write(byteBuffer, l);
    }

    @Override
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (bl && this.file_obj instanceof FileOutputStream) {
            throw new NonReadableChannelException();
        }
        if (!bl && this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        throw new Error("Not implemented");
    }

    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new Error("Not implemented");
    }

    @Override
    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition();
    }

    @Override
    public FileChannel position(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition(l);
    }

    @Override
    public FileChannel truncate(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.file_obj instanceof FileInputStream) {
            throw new NonWritableChannelException();
        }
        return this.implTruncate(l);
    }
}

