/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UTF_16Decoder
extends CharsetDecoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    static final int UNKNOWN_ENDIAN = 2;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char REVERSED_BYTE_ORDER_MARK = '\ufffe';
    private final int originalByteOrder;
    private int byteOrder;

    UTF_16Decoder(Charset charset, int n) {
        super(charset, 0.5f, 1.0f);
        this.originalByteOrder = n;
        this.byteOrder = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block13: {
            CoderResult coderResult2;
            block16: {
                CoderResult coderResult3;
                block15: {
                    CoderResult coderResult4;
                    n = byteBuffer.position();
                    try {
                        while (true) {
                            char c;
                            if (byteBuffer.remaining() < 2) {
                                coderResult = CoderResult.UNDERFLOW;
                                break block13;
                            }
                            byte by = byteBuffer.get();
                            byte by2 = byteBuffer.get();
                            if (this.byteOrder == 2) {
                                c = (char)(by << 8 | by2);
                                if (c == '\ufeff') {
                                    this.byteOrder = 0;
                                    n += 2;
                                    continue;
                                }
                                if (c == '\ufffe') {
                                    this.byteOrder = 1;
                                    n += 2;
                                    continue;
                                }
                                this.byteOrder = 0;
                            }
                            char c2 = c = this.byteOrder == 0 ? (char)(by << 8 | by2) : (char)(by2 << 8 | by);
                            if ('\ud800' <= c && c <= '\udfff') {
                                char c3;
                                if (c > '\udbff') {
                                    CoderResult coderResult5 = CoderResult.malformedForLength(2);
                                    Object var5_15 = null;
                                    byteBuffer.position(n);
                                    return coderResult5;
                                }
                                if (byteBuffer.remaining() < 2) {
                                    coderResult4 = CoderResult.UNDERFLOW;
                                    break;
                                }
                                byte by3 = byteBuffer.get();
                                byte by4 = byteBuffer.get();
                                char c4 = c3 = this.byteOrder == 0 ? (char)(by3 << 8 | by4) : (char)(by4 << 8 | by3);
                                if (c3 < '\udc00' || c3 > '\udfff') {
                                    coderResult3 = CoderResult.malformedForLength(2);
                                    break block15;
                                } else {
                                    charBuffer.put(c);
                                    charBuffer.put(c3);
                                    n += 4;
                                    continue;
                                }
                            }
                            if (!charBuffer.hasRemaining()) {
                                coderResult2 = CoderResult.UNDERFLOW;
                                break block16;
                            }
                            charBuffer.put(c);
                            n += 2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_20 = null;
                        byteBuffer.position(n);
                        throw throwable;
                    }
                    Object var5_16 = null;
                    byteBuffer.position(n);
                    return coderResult4;
                }
                Object var5_17 = null;
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var5_18 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var5_19 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    private void put(ByteBuffer byteBuffer, char c) {
        if (this.byteOrder == 0) {
            byteBuffer.put((byte)(c >> 8));
            byteBuffer.put((byte)(c & 0xFF));
            return;
        }
        byteBuffer.put((byte)(c & 0xFF));
        byteBuffer.put((byte)(c >> 8));
    }

    @Override
    protected void implReset() {
        this.byteOrder = this.originalByteOrder;
    }
}

