/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RETokenChar
extends REToken {
    private char[] ch = new char[1];
    private boolean insens;

    RETokenChar(int n, char c, boolean bl) {
        super(n);
        this.insens = bl;
        this.ch[0] = this.insens ? Character.toLowerCase(c) : c;
    }

    @Override
    int getMinimumLength() {
        return this.ch.length;
    }

    @Override
    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        int n = this.ch.length;
        int n2 = 0;
        while (n2 < n) {
            char c = charIndexed.charAt(rEMatch.index + n2);
            if ((this.insens ? Character.toLowerCase(c) : c) != this.ch[n2]) {
                return false;
            }
            ++n2;
        }
        rEMatch.index += n;
        return this.next(charIndexed, rEMatch);
    }

    @Override
    boolean chain(REToken rEToken) {
        if (rEToken instanceof RETokenChar) {
            RETokenChar rETokenChar = (RETokenChar)rEToken;
            int n = this.ch.length + rETokenChar.ch.length;
            char[] cArray = new char[n];
            System.arraycopy(this.ch, 0, cArray, 0, this.ch.length);
            System.arraycopy(rETokenChar.ch, 0, cArray, this.ch.length, rETokenChar.ch.length);
            this.ch = cArray;
            return false;
        }
        return super.chain(rEToken);
    }

    @Override
    void dump(StringBuffer stringBuffer) {
        stringBuffer.append(this.ch);
    }
}

