/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomEx;
import gnu.xml.dom.DomNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomCharacterData
extends DomNode
implements CharacterData {
    private char[] raw;
    static final EmptyNodeList theEmptyNodeList = new EmptyNodeList();

    DomCharacterData(Document document, String string) {
        super(document);
        if (string != null) {
            this.raw = string.toCharArray();
            return;
        }
        this.raw = new char[0];
    }

    DomCharacterData(Document document, char[] cArray, int n, int n2) {
        super(document);
        if (cArray == null) {
            this.raw = new char[0];
            return;
        }
        this.raw = new char[n2];
        System.arraycopy(cArray, n, this.raw, 0, n2);
    }

    @Override
    public void appendData(String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[this.raw.length + cArray.length];
        System.arraycopy(this.raw, 0, cArray2, 0, this.raw.length);
        System.arraycopy(cArray, 0, cArray2, this.raw.length, cArray.length);
        this.mutating(new String(cArray2));
        this.raw = cArray2;
    }

    @Override
    public void deleteData(int n, int n2) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (n < 0 || n2 < 0 || n > this.raw.length) {
            throw new DomEx(1);
        }
        if (n + n2 > this.raw.length) {
            n2 = this.raw.length - n;
        }
        if (n2 == 0) {
            return;
        }
        char[] cArray = new char[this.raw.length - n2];
        System.arraycopy(this.raw, 0, cArray, 0, n);
        System.arraycopy(this.raw, n + n2, cArray, n, this.raw.length - (n + n2));
        this.mutating(new String(cArray));
        this.raw = cArray;
    }

    @Override
    public String getNodeValue() {
        return new String(this.raw);
    }

    @Override
    public final String getData() {
        return this.getNodeValue();
    }

    @Override
    public int getLength() {
        return this.raw.length;
    }

    @Override
    public final NodeList getChildNodes() {
        return theEmptyNodeList;
    }

    @Override
    public void insertData(int n, String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[this.raw.length + cArray.length];
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        try {
            System.arraycopy(this.raw, 0, cArray2, 0, n);
            System.arraycopy(cArray, 0, cArray2, n, cArray.length);
            System.arraycopy(this.raw, n, cArray2, n + cArray.length, this.raw.length - n);
            this.mutating(new String(cArray2));
            this.raw = cArray2;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DomEx(1);
        }
    }

    @Override
    public void replaceData(int n, int n2, String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        this.deleteData(n, n2);
        this.insertData(n, string);
    }

    @Override
    public void setNodeValue(String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (string == null) {
            string = "";
        }
        this.mutating(string);
        this.raw = string.toCharArray();
    }

    @Override
    public final void setData(String string) {
        this.setNodeValue(string);
    }

    @Override
    public String substringData(int n, int n2) {
        try {
            return new String(this.raw, n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n3;
            if (n >= 0 && n2 >= 0 && n < (n3 = this.raw.length) && n + n2 > n3) {
                return new String(this.raw, n, n3 - n);
            }
            throw new DomEx(1);
        }
    }

    private void mutating(String string) {
        MutationEvent mutationEvent = (MutationEvent)this.createEvent("MutationEvents");
        mutationEvent.initMutationEvent("DOMCharacterDataModified", true, false, null, new String(this.raw), string, null, (short)0);
        this.dispatchEvent(mutationEvent);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EmptyNodeList
    implements NodeList {
        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Node item(int n) {
            return null;
        }

        EmptyNodeList() {
        }
    }
}

