/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomCDATA;
import gnu.xml.dom.DomComment;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomEntity;
import gnu.xml.dom.DomEntityReference;
import gnu.xml.dom.DomEx;
import gnu.xml.dom.DomFragment;
import gnu.xml.dom.DomImpl;
import gnu.xml.dom.DomIterator;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.DomNotation;
import gnu.xml.dom.DomPI;
import gnu.xml.dom.DomText;
import java.util.Enumeration;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomDocument
extends DomNode
implements Document,
DocumentTraversal {
    private final DOMImplementation implementation;
    private boolean checkingCharacters;
    static final String xmlNamespace = "http://www.w3.org/XML/1998/namespace";
    static final String xmlnsURI = "http://www.w3.org/2000/xmlns/";

    public DomDocument() {
        super(null);
        this.Block$();
        this.implementation = new DomImpl();
    }

    protected DomDocument(DOMImplementation dOMImplementation) {
        super(null);
        this.Block$();
        this.implementation = dOMImplementation;
    }

    @Override
    public final String getNodeName() {
        return "#document";
    }

    @Override
    public final short getNodeType() {
        return 9;
    }

    @Override
    public final Element getDocumentElement() {
        int n = 0;
        while (n < this.getLength()) {
            Node node = this.item(n);
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            ++n;
        }
        return null;
    }

    @Override
    public final DocumentType getDoctype() {
        int n = 0;
        while (n < this.getLength()) {
            Node node = this.item(n);
            if (node.getNodeType() == 10) {
                return (DocumentType)node;
            }
            ++n;
        }
        return null;
    }

    @Override
    public final DOMImplementation getImplementation() {
        return this.implementation;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Element getElementById(String var1_1) {
        var2_2 = (DomDoctype)this.getDoctype();
        if (var2_2 == null || !var2_2.hasIds() || var1_1 == null || var1_1.length() == 0) {
            return null;
        }
        var3_3 = this.getDocumentElement();
        if (var3_3 != null) ** GOTO lbl21
        return null;
lbl-1000:
        // 1 sources

        {
            if (var3_3.getNodeType() == 1 && var1_1.equals((var5_5 = var3_3).getAttribute((var6_6 = var2_2.getElementInfo(var3_3.getNodeName())).getIdAttr()))) {
                return var5_5;
            }
            if (var3_3.hasChildNodes()) {
                var3_3 = var3_3.getFirstChild();
                continue;
            }
            var4_4 = var3_3.getNextSibling();
            if (var4_4 != null) {
                var3_3 = var4_4;
                continue;
            }
            do {
                if ((var4_4 = var3_3.getParentNode()) != null) continue;
                return null;
            } while ((var4_4 = (var3_3 = var4_4).getNextSibling()) == null);
            var3_3 = var4_4;
lbl21:
            // 4 sources

            ** while (var3_3 != this)
        }
lbl22:
        // 1 sources

        return null;
    }

    private void checkNewChild(Node node) {
        if (node.getNodeType() == 1 && this.getDocumentElement() != null) {
            throw new DomEx(3, null, node, 0);
        }
        if (node.getNodeType() == 10 && this.getDoctype() != null) {
            throw new DomEx(3, null, node, 0);
        }
    }

    @Override
    public Node appendChild(Node node) {
        this.checkNewChild(node);
        return super.appendChild(node);
    }

    @Override
    public Node insertBefore(Node node, Node node2) {
        this.checkNewChild(node);
        return super.insertBefore(node, node2);
    }

    @Override
    public Node replaceChild(Node node, Node node2) {
        if (!(node.getNodeType() == 1 && node2.getNodeType() != 1 || node.getNodeType() == 10 && node2.getNodeType() != 1)) {
            this.checkNewChild(node);
        }
        return super.replaceChild(node, node2);
    }

    public static void verifyXmlName(String string) {
        int n = string.length();
        if (n == 0) {
            throw new DomEx(14, string, null, 0);
        }
        char c = string.charAt(0);
        if (!Character.isUnicodeIdentifierStart(c) && c != ':' && c != '_') {
            throw new DomEx(5, string, null, c);
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!Character.isUnicodeIdentifierPart(c) && c != ':' && c != '_' && c != '.' && c != '-' && !DomDocument.isExtender(c)) {
                throw new DomEx(5, string, null, c);
            }
            ++n2;
        }
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    static void verifyNamespaceName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            DomDocument.verifyXmlName(string);
            return;
        }
        if (string.lastIndexOf(58) != n) {
            throw new DomEx(14, string, null, 0);
        }
        DomDocument.verifyXmlName(string.substring(0, n));
        DomDocument.verifyXmlName(string.substring(n + 1));
    }

    static void verifyXmlCharacters(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if ((c < ' ' || c > '\ufffd') && c != '\n' && c != '\t' && c != '\r') {
                throw new DomEx(5, string, null, c);
            }
            ++n2;
        }
    }

    static void verifyXmlCharacters(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n + n3];
            if ((c < ' ' || c > '\ufffd') && c != '\n' && c != '\t' && c != '\r') {
                throw new DomEx(5, new String(cArray, n, n2), null, c);
            }
            ++n3;
        }
    }

    public final void setCheckingCharacters(boolean bl) {
        this.checkingCharacters = bl;
    }

    public final boolean isCheckingCharacters() {
        return this.checkingCharacters;
    }

    @Override
    public Element createElement(String string) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlName(string);
        }
        Element element = string.startsWith("xml:") ? this.createElementNS(null, string) : new DomElement(this, null, string);
        this.defaultAttributes(element, string);
        return element;
    }

    @Override
    public Element createElementNS(String string, String string2) {
        if (this.checkingCharacters) {
            DomDocument.verifyNamespaceName(string2);
        }
        if ("".equals(string)) {
            string = null;
        }
        if (string2.startsWith("xml:")) {
            if (string != null && !xmlNamespace.equals(string)) {
                throw new DomEx(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
            }
            string = xmlNamespace;
        } else {
            if (string2.startsWith("xmlns:")) {
                throw new DomEx(14, "xmlns is reserved", this, 0);
            }
            if (string == null && string2.indexOf(58) != -1) {
                throw new DomEx(14, "prefixed name needs a URI", this, 0);
            }
        }
        DomElement domElement = new DomElement(this, string, string2);
        this.defaultAttributes(domElement, string2);
        return domElement;
    }

    private void defaultAttributes(Element element, String string) {
        DomDoctype domDoctype = (DomDoctype)this.getDoctype();
        if (domDoctype == null) {
            return;
        }
        DomDoctype.ElementInfo elementInfo = domDoctype.getElementInfo(string);
        Enumeration enumeration = elementInfo.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            DomAttr domAttr = (DomAttr)this.createAttribute(string2);
            domAttr.setValue((String)elementInfo.get(string2));
            domAttr.setSpecified(false);
            element.setAttributeNode(domAttr);
        }
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DomFragment(this);
    }

    @Override
    public Text createTextNode(String string) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlCharacters(string);
        }
        return new DomText(this, string);
    }

    public Text createTextNode(char[] cArray, int n, int n2) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlCharacters(cArray, n, n2);
        }
        return new DomText(this, cArray, n, n2);
    }

    @Override
    public Comment createComment(String string) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlCharacters(string);
        }
        return new DomComment(this, string);
    }

    @Override
    public CDATASection createCDATASection(String string) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlCharacters(string);
        }
        return new DomCDATA(this, string);
    }

    public CDATASection createCDATASection(char[] cArray, int n, int n2) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlCharacters(cArray, n, n2);
        }
        return new DomCDATA(this, cArray, n, n2);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlName(string);
            DomDocument.verifyXmlCharacters(string2);
            if ("xml".equalsIgnoreCase(string)) {
                throw new DomEx(12, "illegal PI target name", this, 0);
            }
        }
        return new DomPI(this, string, string2);
    }

    @Override
    public Attr createAttribute(String string) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlName(string);
        }
        if (string.startsWith("xml:") || string.startsWith("xmlns:")) {
            return this.createAttributeNS(null, string);
        }
        return new DomAttr(this, null, string);
    }

    @Override
    public Attr createAttributeNS(String string, String string2) {
        if (this.checkingCharacters) {
            DomDocument.verifyNamespaceName(string2);
        }
        if ("".equals(string)) {
            string = null;
        }
        if (string2.startsWith("xml:")) {
            if (string == null) {
                string = xmlNamespace;
            } else if (!xmlNamespace.equals(string)) {
                throw new DomEx(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
            }
            string = xmlNamespace;
        } else if (string2.startsWith("xmlns:") || string2.equals("xmlns")) {
            if (!xmlnsURI.equals(string)) {
                throw new DomEx(14, "xmlns is reserved", this, 0);
            }
            string = xmlnsURI;
        } else if (string == null && string2.indexOf(58) != -1) {
            throw new DomEx(14, new StringBuffer().append("prefixed name needs a URI: ").append(string2).toString(), this, 0);
        }
        return new DomAttr(this, string, string2);
    }

    @Override
    public EntityReference createEntityReference(String string) {
        if (this.checkingCharacters) {
            DomDocument.verifyXmlName(string);
        }
        DomEntityReference domEntityReference = new DomEntityReference(this, string);
        domEntityReference.makeReadonly();
        return domEntityReference;
    }

    @Override
    public Node importNode(Node node, boolean bl) {
        switch (node.getNodeType()) {
            case 3: {
                return this.createTextNode(node.getNodeValue());
            }
            case 4: {
                return this.createCDATASection(node.getNodeValue());
            }
            case 8: {
                return this.createComment(node.getNodeValue());
            }
            case 7: {
                return this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
            }
            case 12: {
                Notation notation = (Notation)node;
                return new DomNotation(this, notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
            }
            case 6: {
                Entity entity = (Entity)node;
                return new DomEntity(this, entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
            }
            case 5: {
                return this.createEntityReference(node.getNodeName());
            }
            case 11: {
                DocumentFragment documentFragment = this.createDocumentFragment();
                if (bl) {
                    NodeList nodeList = node.getChildNodes();
                    int n = nodeList.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        documentFragment.appendChild(this.importNode(nodeList.item(n2), bl));
                        ++n2;
                    }
                }
                return documentFragment;
            }
            case 2: {
                String string = node.getNodeName();
                String string2 = node.getNamespaceURI();
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                DomAttr domAttr = string2 != null ? (DomAttr)this.createAttributeNS(string2, string) : (DomAttr)this.createAttribute(string);
                int n3 = 0;
                while (n3 < n) {
                    domAttr.appendChild(this.importNode(nodeList.item(n3), false));
                    ++n3;
                }
                return domAttr;
            }
            case 1: {
                String string = node.getNodeName();
                String string3 = node.getNamespaceURI();
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                DomElement domElement = string3 != null ? (DomElement)this.createElementNS(string3, string) : (DomElement)this.createElement(string);
                int n4 = 0;
                while (n4 < n) {
                    Attr attr = (Attr)namedNodeMap.item(n4);
                    Attr attr2 = domElement.getAttributeNode(attr.getNodeName());
                    if (attr2 != null) {
                        String string4 = attr.getNodeValue();
                        if (!attr2.getNodeValue().equals(string4) || attr.getSpecified()) {
                            attr2.setNodeValue(string4);
                        }
                    } else {
                        domElement.setAttributeNode((Attr)this.importNode(attr, false));
                    }
                    ++n4;
                }
                if (!bl) {
                    return domElement;
                }
                NodeList nodeList = node.getChildNodes();
                n = nodeList.getLength();
                int n5 = 0;
                while (n5 < n) {
                    domElement.appendChild(this.importNode(nodeList.item(n5), true));
                    ++n5;
                }
                return domElement;
            }
        }
        throw new DomEx(9, null, node, 0);
    }

    @Override
    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        return new DomIterator(node, n, nodeFilter, bl);
    }

    @Override
    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        this.nyi();
        return null;
    }

    private /* synthetic */ void Block$() {
        this.checkingCharacters = true;
    }
}

