/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomEx;
import gnu.xml.dom.DomNamedNodeMap;
import gnu.xml.dom.DomNsNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomElement
extends DomNsNode
implements Element {
    private DomNamedNodeMap attributes;

    protected DomElement(Document document, String string, String string2) {
        super(document, string, string2);
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new DomNamedNodeMap(this.getOwnerDocument(), this);
        }
        return this.attributes;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    @Override
    public Object clone() {
        DomNamedNodeMap domNamedNodeMap;
        DomElement domElement = (DomElement)super.clone();
        if (this.attributes == null) {
            return domElement;
        }
        domElement.attributes = domNamedNodeMap = new DomNamedNodeMap(this.getOwnerDocument(), domElement);
        int n = 0;
        while (n < this.attributes.getLength()) {
            Node node = this.attributes.item(n);
            node = node.cloneNode(true);
            domNamedNodeMap.setNamedItem(node);
            ++n;
        }
        return domElement;
    }

    @Override
    public void makeReadonly() {
        super.makeReadonly();
        if (this.attributes != null) {
            this.attributes.makeReadonly();
        }
    }

    @Override
    public final String getTagName() {
        return this.getNodeName();
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public String getAttribute(String string) {
        Attr attr = this.getAttributeNode(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    @Override
    public String getAttributeNS(String string, String string2) {
        Attr attr = this.getAttributeNodeNS(string, string2);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    @Override
    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    @Override
    public void setAttribute(String string, String string2) {
        Attr attr = this.getAttributeNode(string);
        if (attr != null) {
            attr.setNodeValue(string2);
            return;
        }
        attr = this.getOwnerDocument().createAttribute(string);
        attr.setNodeValue(string2);
        this.setAttributeNode(attr);
    }

    @Override
    public void setAttributeNS(String string, String string2, String string3) {
        if (("xmlns".equals(string2) || string2.startsWith("xmlns:")) && !"http://www.w3.org/2000/xmlns/".equals(string)) {
            throw new DomEx(14, "setting xmlns attribute to illegal value", this, 0);
        }
        Attr attr = this.getAttributeNodeNS(string, string2);
        if (attr != null) {
            attr.setNodeValue(string3);
            return;
        }
        attr = this.getOwnerDocument().createAttributeNS(string, string2);
        attr.setNodeValue(string3);
        this.setAttributeNodeNS(attr);
    }

    @Override
    public Attr setAttributeNode(Attr attr) {
        return (Attr)this.getAttributes().setNamedItem(attr);
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) {
        return (Attr)this.getAttributes().setNamedItemNS(attr);
    }

    @Override
    public void removeAttribute(String string) {
        if (this.attributes == null) {
            return;
        }
        try {
            this.attributes.removeNamedItem(string);
            return;
        }
        catch (DomEx domEx) {
            if (domEx.code == 8) {
                return;
            }
            return;
        }
    }

    @Override
    public Attr removeAttributeNode(Attr attr) {
        if (this.attributes == null) {
            throw new DomEx(8, null, attr, 0);
        }
        return (Attr)this.attributes.removeNamedItem(attr.getNodeName());
    }

    @Override
    public void removeAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            throw new DomEx(8, string2, null, 0);
        }
        this.attributes.removeNamedItemNS(string, string2);
    }
}

