/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.events.UIEvent;
import org.w3c.dom.views.AbstractView;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomEvent
implements Event {
    String type;
    EventTarget target;
    EventTarget currentNode;
    short eventPhase;
    boolean bubbles;
    boolean cancelable;
    long timeStamp;
    boolean stop;
    boolean doDefault;

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final EventTarget getTarget() {
        return this.target;
    }

    @Override
    public final EventTarget getCurrentTarget() {
        return this.currentNode;
    }

    @Override
    public final short getEventPhase() {
        return this.eventPhase;
    }

    @Override
    public final boolean getBubbles() {
        return this.bubbles;
    }

    @Override
    public final boolean getCancelable() {
        return this.cancelable;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void stopPropagation() {
        this.stop = true;
    }

    @Override
    public final void preventDefault() {
        this.doDefault = false;
    }

    @Override
    public void initEvent(String string, boolean bl, boolean bl2) {
        this.eventPhase = 0;
        this.type = string;
        this.bubbles = bl;
        this.cancelable = bl2;
        this.timeStamp = System.currentTimeMillis();
    }

    public DomEvent(String string) {
        this.type = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Event ");
        stringBuffer.append(this.type);
        switch (this.eventPhase) {
            case 1: {
                stringBuffer.append(", CAPTURING");
                break;
            }
            case 2: {
                stringBuffer.append(", AT TARGET");
                break;
            }
            case 3: {
                stringBuffer.append(", BUBBLING");
                break;
            }
            default: {
                stringBuffer.append(", (inactive)");
            }
        }
        if (this.bubbles && this.eventPhase != 3) {
            stringBuffer.append(", bubbles");
        }
        if (this.cancelable) {
            stringBuffer.append(", can cancel");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DomMutationEvent
    extends DomEvent
    implements MutationEvent {
        Node relatedNode;
        private String prevValue;
        private String newValue;
        private String attrName;
        private short attrChange;

        @Override
        public final Node getRelatedNode() {
            return this.relatedNode;
        }

        @Override
        public final String getPrevValue() {
            return this.prevValue;
        }

        @Override
        public final String getNewValue() {
            return this.newValue;
        }

        @Override
        public final String getAttrName() {
            return this.attrName;
        }

        @Override
        public final short getAttrChange() {
            return this.attrChange;
        }

        @Override
        public final void initMutationEvent(String string, boolean bl, boolean bl2, Node node, String string2, String string3, String string4, short s) {
            this.eventPhase = 0;
            this.type = string;
            this.bubbles = bl;
            this.cancelable = bl2;
            this.timeStamp = System.currentTimeMillis();
            this.relatedNode = node;
            this.prevValue = string2;
            this.newValue = string3;
            this.attrName = string4;
            this.attrChange = s;
        }

        void clear() {
            this.type = null;
            this.target = null;
            this.relatedNode = null;
            this.currentNode = null;
            this.attrName = null;
            this.newValue = null;
            this.prevValue = null;
        }

        public DomMutationEvent(String string) {
            super(string);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DomUIEvent
    extends DomEvent
    implements UIEvent {
        private AbstractView view;
        private int detail;

        public DomUIEvent(String string) {
            super(string);
        }

        @Override
        public final AbstractView getView() {
            return this.view;
        }

        @Override
        public final int getDetail() {
            return this.detail;
        }

        @Override
        public final void initUIEvent(String string, boolean bl, boolean bl2, AbstractView abstractView, int n) {
            super.initEvent(string, bl, bl2);
            this.view = abstractView;
            this.detail = n;
        }
    }
}

