/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomEx;
import gnu.xml.dom.DomNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomNamedNodeMap
implements NamedNodeMap {
    private final Document owner;
    private DomNode[] contents;
    private int length;
    private boolean readonly;
    private final Element element;
    private static final int DELTA = 5;

    public DomNamedNodeMap(Document document) {
        this.Block$();
        this.owner = document;
        this.element = null;
    }

    DomNamedNodeMap(Document document, Element element) {
        this.Block$();
        this.owner = document;
        this.element = element;
    }

    public void compact() {
        if (this.contents.length != this.length) {
            this.setCapacity(this.length);
        }
    }

    private void setCapacity(int n) {
        DomNode[] domNodeArray = new DomNode[n];
        System.arraycopy(this.contents, 0, domNodeArray, 0, this.length);
        this.contents = domNodeArray;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public void makeReadonly() {
        this.readonly = true;
        int n = 0;
        while (n < this.length) {
            this.contents[n].makeReadonly();
            ++n;
        }
    }

    @Override
    public Node getNamedItem(String string) {
        int n = 0;
        while (n < this.length) {
            if (this.contents[n].getNodeName().equals(string)) {
                return this.contents[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public Node getNamedItemNS(String string, String string2) {
        int n = 0;
        while (n < this.length) {
            String string3;
            DomNode domNode = this.contents[n];
            String string4 = domNode.getLocalName();
            if (string4 != null && string4.equals(string2) && ((string3 = domNode.getNamespaceURI()) == null && string == null || string3.equals(string))) {
                return domNode;
            }
            ++n;
        }
        return null;
    }

    private void checkAttr(Attr attr) {
        if (this.element == null) {
            return;
        }
        Element element = attr.getOwnerElement();
        if (element != null) {
            if (element != this.element) {
                throw new DomEx(10);
            }
            return;
        }
        ((DomAttr)attr).setOwnerElement(this.element);
    }

    @Override
    public Node setNamedItem(Node node) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node.getOwnerDocument() != this.owner) {
            throw new DomEx(4);
        }
        if (node instanceof Attr) {
            this.checkAttr((Attr)node);
        }
        String string = node.getNodeName();
        int n = 0;
        while (n < this.length) {
            DomNode domNode = this.contents[n];
            if (domNode.getNodeName().equals(string)) {
                this.contents[n] = (DomNode)node;
                return domNode;
            }
            ++n;
        }
        if (this.length == this.contents.length) {
            this.setCapacity(this.length + 5);
        }
        this.contents[this.length++] = (DomNode)node;
        return null;
    }

    @Override
    public Node setNamedItemNS(Node node) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node.getOwnerDocument() != this.owner) {
            throw new DomEx(4);
        }
        if (node instanceof Attr) {
            this.checkAttr((Attr)node);
        }
        String string = node.getLocalName();
        String string2 = node.getNamespaceURI();
        if (string == null) {
            throw new DomEx(15);
        }
        int n = 0;
        while (n < this.length) {
            String string3;
            DomNode domNode = this.contents[n];
            String string4 = domNode.getLocalName();
            if (string4 != null && string4.equals(string) && ((string3 = domNode.getNamespaceURI()) == null && string2 == null || string3.equals(string2))) {
                this.contents[n] = (DomNode)node;
                return domNode;
            }
            ++n;
        }
        if (this.length == this.contents.length) {
            this.setCapacity(this.length + 5);
        }
        this.contents[this.length++] = (DomNode)node;
        return null;
    }

    private void maybeRestoreDefault(String string, String string2) {
        DomDoctype domDoctype = (DomDoctype)this.owner.getDoctype();
        if (domDoctype == null) {
            return;
        }
        DomDoctype.ElementInfo elementInfo = domDoctype.getElementInfo(this.element.getNodeName());
        if (elementInfo == null) {
            return;
        }
        String string3 = elementInfo.getAttrDefault(string2);
        if (string3 == null) {
            return;
        }
        DomAttr domAttr = string == null ? (DomAttr)this.owner.createAttribute(string2) : (DomAttr)this.owner.createAttributeNS(string, string2);
        domAttr.setNodeValue(string3);
        domAttr.setSpecified(false);
        this.setNamedItem(domAttr);
    }

    @Override
    public Node removeNamedItem(String string) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = 0;
        while (n < this.length) {
            DomNode domNode = this.contents[n];
            if (domNode.getNodeName().equals(string)) {
                System.arraycopy(this.contents, n + 1, this.contents, n, this.length - (n + 1));
                this.contents[this.length += -1] = null;
                if (this.element != null) {
                    this.maybeRestoreDefault(domNode.getNamespaceURI(), string);
                }
                return domNode;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    @Override
    public Node removeNamedItemNS(String string, String string2) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = 0;
        while (n < this.length) {
            String string3;
            DomNode domNode = this.contents[n];
            String string4 = domNode.getLocalName();
            if (string4 != null && string4.equals(string2) && ((string3 = domNode.getNamespaceURI()) == null && string == null || string3.equals(string))) {
                System.arraycopy(this.contents, n + 1, this.contents, n, this.length - (n + 1));
                this.contents[this.length += -1] = null;
                if (this.element != null) {
                    this.maybeRestoreDefault(string3, domNode.getNodeName());
                }
                return domNode;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    @Override
    public Node item(int n) {
        if (n < 0 || n >= this.length) {
            return null;
        }
        return this.contents[n];
    }

    @Override
    public int getLength() {
        return this.length;
    }

    private /* synthetic */ void Block$() {
        this.contents = new DomNode[1];
    }
}

