/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomEvent;
import gnu.xml.dom.DomEx;
import gnu.xml.dom.DomIterator;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomNode
implements Node,
NodeList,
EventTarget,
DocumentEvent,
Cloneable {
    private static final int NKIDS_INIT = 5;
    private static final int NKIDS_DELTA = 8;
    private static final int ANCESTORS_INIT = 20;
    private static final int NOTIFICATIONS_INIT = 10;
    static final boolean reportMutations = true;
    private static final Object lockNode = new Object();
    private static final DomNode[] noKids = new DomNode[0];
    private static boolean dispatchDataLock;
    private static DomNode[] ancestors;
    private static ListenerRecord[] notificationSet;
    private static boolean eventDataLock;
    private static DomEvent.DomMutationEvent mutationEvent;
    private Document owner;
    private DomNode parent;
    boolean readonly;
    private DomNode[] children;
    private int length;
    private ListenerRecord[] listeners;
    private int nListeners;
    private transient int parentIndex;

    void nyi() {
        throw new DomEx(9, "feature not yet implemented", this, 0);
    }

    public void compact() {
        Object[] objectArray;
        if (this.children != null && this.children != noKids) {
            if (this.length == 0) {
                this.children = noKids;
            } else if (this.children.length - this.length > 1) {
                objectArray = new DomNode[this.length];
                System.arraycopy(this.children, 0, objectArray, 0, this.length);
                this.children = objectArray;
            }
        }
        if (this.listeners != null && this.listeners.length != this.nListeners) {
            if (this.nListeners == 0) {
                this.listeners = null;
                return;
            }
            objectArray = new ListenerRecord[this.nListeners];
            System.arraycopy(this.listeners, 0, objectArray, 0, this.nListeners);
            this.listeners = objectArray;
        }
    }

    protected DomNode(Document document) {
        short s = this.getNodeType();
        if (document == null && s != 9 && s != 10) {
            throw new IllegalArgumentException("no owner!");
        }
        this.owner = document;
        switch (s) {
            case 1: 
            case 5: 
            case 9: 
            case 11: {
                this.children = new DomNode[5];
                return;
            }
            case 2: {
                this.children = new DomNode[1];
                return;
            }
            case 6: {
                this.children = noKids;
            }
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public NodeList getChildNodes() {
        return this;
    }

    @Override
    public final Node getFirstChild() {
        return this.item(0);
    }

    @Override
    public final Node getLastChild() {
        return this.item(this.length - 1);
    }

    @Override
    public final boolean hasChildNodes() {
        return this.length > 0;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public void makeReadonly() {
        this.readonly = true;
        int n = 0;
        while (n < this.length) {
            this.children[n].makeReadonly();
            ++n;
        }
    }

    private void ensureEnough(int n) {
        if (this.children.length - this.length > n) {
            return;
        }
        if (n < 8) {
            n = 8;
        }
        DomNode[] domNodeArray = new DomNode[n += this.children.length];
        int n2 = 0;
        while (n2 < this.length) {
            domNodeArray[n2] = this.children[n2];
            ++n2;
        }
        this.children = domNodeArray;
    }

    private void checkMisc(DomNode domNode) {
        Node node;
        if (this.readonly) {
            throw new DomEx(7, null, this, 0);
        }
        if (this.children == null) {
            throw new DomEx(3, null, this, 0);
        }
        if (this.parent != null && domNode.length > 0) {
            node = this.parent;
            while (node != null) {
                if (domNode == this.parent) {
                    throw new DomEx(3, "can't make ancestor into a child", this, 0);
                }
                node = node.getParentNode();
            }
        }
        node = this.owner;
        Document document = domNode.owner;
        short s = this.getNodeType();
        short s2 = domNode.getNodeType();
        if (s == 9) {
            node = this;
        }
        if (document != node && (s2 != 10 || document != null)) {
            throw new DomEx(4, null, domNode, 0);
        }
        switch (s) {
            case 9: {
                if (s2 != 1 && s2 != 7 && s2 != 8 && s2 != 10) break;
                return;
            }
            case 2: {
                if (s2 != 3 && s2 != 5) break;
                return;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                if (s2 != 1 && s2 != 3 && s2 != 8 && s2 != 7 && s2 != 4 && s2 != 5) break;
                return;
            }
        }
        throw new DomEx(3, "this node can't have that type of child", this, 0);
    }

    private void reparent(DomNode domNode) {
        DomNode domNode2;
        short s = domNode.getNodeType();
        if (this.getNodeType() == 9 && s == 10) {
            domNode2 = (DomDoctype)domNode;
            if (((DomDoctype)domNode2).getImplementation() != ((Document)((Object)this)).getImplementation()) {
                throw new DomEx(4, "implementation mismatch", domNode, 0);
            }
            domNode.owner = (Document)((Object)this);
        }
        if ((domNode2 = domNode.parent) != null) {
            domNode2.removeChild(domNode);
        }
        if (s != 2) {
            domNode.parent = this;
        }
    }

    private void insertionEvent(DomEvent.DomMutationEvent domMutationEvent, DomNode domNode) {
        boolean bl = false;
        if (domMutationEvent == null) {
            domMutationEvent = DomNode.getMutationEvent();
            if (domMutationEvent != null) {
                bl = true;
            } else {
                domMutationEvent = new DomEvent.DomMutationEvent(null);
            }
        }
        domMutationEvent.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)0);
        domNode.dispatchEvent(domMutationEvent);
        if (bl) {
            domMutationEvent.target = null;
            domMutationEvent.relatedNode = null;
            domMutationEvent.currentNode = null;
            eventDataLock = false;
        }
    }

    private void removalEvent(DomEvent.DomMutationEvent domMutationEvent, DomNode domNode) {
        boolean bl = false;
        if (domMutationEvent == null) {
            domMutationEvent = DomNode.getMutationEvent();
            if (domMutationEvent != null) {
                bl = true;
            } else {
                domMutationEvent = new DomEvent.DomMutationEvent(null);
            }
        }
        domMutationEvent.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)0);
        domNode.dispatchEvent(domMutationEvent);
        domMutationEvent.target = null;
        domMutationEvent.relatedNode = null;
        domMutationEvent.currentNode = null;
        if (bl) {
            eventDataLock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DomEvent.DomMutationEvent getMutationEvent() {
        Object object = lockNode;
        synchronized (object) {
            if (eventDataLock) {
                return null;
            }
            eventDataLock = true;
            return mutationEvent;
        }
    }

    private static void freeMutationEvent() {
        mutationEvent.clear();
        eventDataLock = false;
    }

    @Override
    public Node appendChild(Node node) {
        try {
            DomNode domNode = (DomNode)node;
            if (node.getNodeType() != 11) {
                this.checkMisc(domNode);
                if (this.length >= this.children.length) {
                    this.ensureEnough(1);
                }
                this.reparent(domNode);
                this.children[this.length++] = domNode;
                this.insertionEvent(null, domNode);
            } else {
                int n = 0;
                while (n < domNode.length) {
                    this.checkMisc(domNode.children[n]);
                    ++n;
                }
                this.ensureEnough(domNode.length);
                n = 0;
                while (n <= domNode.length) {
                    this.appendChild(domNode.children[0]);
                    ++n;
                }
            }
            return domNode;
        }
        catch (ClassCastException classCastException) {
            throw new DomEx(4, null, node, 0);
        }
    }

    @Override
    public Node insertBefore(Node node, Node node2) {
        if (node2 == null) {
            return this.appendChild(node);
        }
        try {
            DomNode domNode = (DomNode)node;
            if (node.getNodeType() != 11) {
                this.checkMisc(domNode);
                int n = 0;
                while (n < this.length) {
                    if (this.children[n] == node2) {
                        this.ensureEnough(1);
                        this.reparent(domNode);
                        if (this.children[n] != node2) {
                            --n;
                        }
                        int n2 = ++this.length;
                        while (n2 > n) {
                            this.children[n2] = this.children[n2 - 1];
                            --n2;
                        }
                        this.children[n] = domNode;
                        this.insertionEvent(null, domNode);
                        return node;
                    }
                    ++n;
                }
                throw new DomEx(8, "that's no child of mine", node2, 0);
            }
            int n = 0;
            while (n < domNode.length) {
                this.checkMisc(domNode.children[n]);
                ++n;
            }
            this.ensureEnough(domNode.length);
            n = 0;
            while (n <= domNode.length) {
                this.insertBefore(domNode.children[0], node2);
                ++n;
            }
            return node;
        }
        catch (ClassCastException classCastException) {
            throw new DomEx(4, null, node, 0);
        }
    }

    @Override
    public Node replaceChild(Node node, Node node2) {
        try {
            DomNode domNode = (DomNode)node;
            if (node.getNodeType() != 11) {
                this.checkMisc(domNode);
                int n = 0;
                while (n < this.length) {
                    if (this.children[n] == node2) {
                        DomNode domNode2 = (DomNode)node2;
                        DomEvent.DomMutationEvent domMutationEvent = DomNode.getMutationEvent();
                        boolean bl = domMutationEvent != null;
                        this.removalEvent(domMutationEvent, domNode2);
                        this.reparent(domNode);
                        if (this.children[n] != node2) {
                            --n;
                        }
                        this.children[n] = domNode;
                        domNode2.parent = null;
                        this.insertionEvent(domMutationEvent, domNode);
                        if (bl) {
                            DomNode.freeMutationEvent();
                        }
                        return node2;
                    }
                    ++n;
                }
                throw new DomEx(8, "that's no child of mine", node, 0);
            }
            throw new DomEx(9, "replacing with fragment, NYI", null, 0);
        }
        catch (ClassCastException classCastException) {
            throw new DomEx(4, null, node, 0);
        }
    }

    @Override
    public Node removeChild(Node node) {
        if (this.readonly) {
            throw new DomEx(7, null, this, 0);
        }
        int n = 0;
        while (n < this.length) {
            if (this.children[n] == node) {
                DomNode domNode = (DomNode)node;
                this.removalEvent(null, domNode);
                int n2 = n + 1;
                while (n2 < this.length) {
                    this.children[n] = this.children[n2];
                    ++n2;
                    ++n;
                }
                this.children[n] = null;
                domNode.parent = null;
                this.length += -1;
                return node;
            }
            ++n;
        }
        throw new DomEx(8, "that's no child of mine", node, 0);
    }

    @Override
    public final Node item(int n) {
        try {
            if (n < this.length) {
                return this.children[n];
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void trimToSize() {
        int n;
        Object[] objectArray;
        if (this.children != null && this.children.length != this.length) {
            objectArray = new DomNode[this.length];
            n = 0;
            while (n < this.length) {
                objectArray[n] = this.children[n];
                ++n;
            }
            this.children = objectArray;
        }
        if (this.listeners != null && this.listeners.length != this.nListeners) {
            objectArray = new ListenerRecord[this.length];
            n = 0;
            while (n < this.nListeners) {
                objectArray[n] = this.listeners[n];
                ++n;
            }
            this.listeners = objectArray;
        }
    }

    @Override
    public final Node getNextSibling() {
        if (this.parent == null || this.getNodeType() == 2) {
            return null;
        }
        if (this.parentIndex < this.parent.length && this.parent.children[this.parentIndex] == this) {
            int n = this.parentIndex + 1;
            if (n < this.parent.length) {
                return this.parent.children[n];
            }
            return null;
        }
        int n = 0;
        while (n < this.parent.length) {
            if (this.parent.children[n] == this) {
                this.parentIndex = n++;
                if (n >= this.parent.length) break;
                return this.parent.children[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public final Node getPreviousSibling() {
        if (this.parent == null || this.getNodeType() == 2) {
            return null;
        }
        NodeList nodeList = this.parent.getChildNodes();
        int n = nodeList.getLength();
        if (nodeList.item(this.parentIndex) == this) {
            return nodeList.item(this.parentIndex - 1);
        }
        int n2 = 0;
        while (n2 < n) {
            if (nodeList.item(n2) == this) {
                this.parentIndex = n2--;
                return nodeList.item(n2);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public final Node getParentNode() {
        return this.parent;
    }

    @Override
    public boolean isSupported(String string, String string2) {
        Document document = this.owner;
        DOMImplementation dOMImplementation = null;
        if (document == null && this.getNodeType() == 9) {
            document = (Document)((Object)this);
        }
        if (document == null) {
            throw new IllegalStateException("unbound ownerDocument");
        }
        dOMImplementation = document.getImplementation();
        return dOMImplementation.hasFeature(string, string2);
    }

    @Override
    public final Document getOwnerDocument() {
        return this.owner;
    }

    @Override
    public void setNodeValue(String string) {
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public abstract short getNodeType();

    @Override
    public abstract String getNodeName();

    @Override
    public void setPrefix(String string) {
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public Node cloneNode(boolean bl) {
        DomNode domNode = (DomNode)this.clone();
        if (bl && this.children != null) {
            DomNode[] domNodeArray = domNode.children;
            if (domNodeArray.length < this.length) {
                domNodeArray = new DomNode[this.length];
            }
            int n = 0;
            while (n < this.length) {
                domNodeArray[n] = (DomNode)this.children[n].cloneNode(true);
                ++n;
            }
            domNode.children = domNodeArray;
            domNode.length = this.length;
            if (this.getNodeType() == 5) {
                domNode.makeReadonly();
            }
        }
        return domNode;
    }

    public Object clone() {
        try {
            DomNode domNode = (DomNode)super.clone();
            domNode.parent = null;
            domNode.readonly = false;
            if (domNode.children != null) {
                domNode.children = noKids;
                domNode.length = 0;
            }
            domNode.listeners = null;
            domNode.nListeners = 0;
            return domNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("clone didn't work");
        }
    }

    public NodeList getElementsByTagName(String string) {
        return new ShadowList(null, string);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new ShadowList(string, string2);
    }

    @Override
    public Event createEvent(String string) {
        if ("mutationevents".equals(string = string.toLowerCase())) {
            return new DomEvent.DomMutationEvent(null);
        }
        if ("htmlevents".equals(string) || "events".equals(string) || "user-events".equals(string)) {
            return new DomEvent(null);
        }
        if ("uievents".equals(string)) {
            return new DomEvent.DomUIEvent(null);
        }
        throw new DomEx(9, string, null, 0);
    }

    @Override
    public final void addEventListener(String string, EventListener eventListener, boolean bl) {
        int n;
        ListenerRecord[] listenerRecordArray;
        if (this.listeners == null) {
            this.listeners = new ListenerRecord[1];
        } else if (this.nListeners == this.listeners.length) {
            listenerRecordArray = new ListenerRecord[this.listeners.length + 8];
            n = 0;
            while (n < this.nListeners) {
                listenerRecordArray[n] = this.listeners[n];
                ++n;
            }
            this.listeners = listenerRecordArray;
        }
        listenerRecordArray = new ListenerRecord(string, eventListener, bl);
        n = 0;
        while (n < this.nListeners) {
            if (listenerRecordArray.equals(this.listeners[n])) {
                return;
            }
            ++n;
        }
        this.listeners[this.nListeners++] = listenerRecordArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean dispatchEvent(Event event) throws EventException {
        Object object;
        boolean bl;
        DomEvent domEvent = (DomEvent)event;
        DomNode[] domNodeArray = null;
        int n = 0;
        boolean bl2 = false;
        if (domEvent.type == null) {
            throw new DomEventException();
        }
        domEvent.doDefault = true;
        domEvent.target = this;
        try {
            int n2;
            ListenerRecord[] listenerRecordArray;
            boolean bl3 = false;
            Object object2 = lockNode;
            synchronized (object2) {
                if (!dispatchDataLock) {
                    dispatchDataLock = true;
                    bl2 = true;
                    listenerRecordArray = notificationSet;
                    domNodeArray = ancestors;
                } else {
                    listenerRecordArray = new ListenerRecord[10];
                    domNodeArray = new DomNode[20];
                }
                n2 = domNodeArray.length;
            }
            int n3 = 0;
            Object object3 = this.parent;
            while (object3 != null && n3 < n2) {
                if (((DomNode)object3).nListeners != 0) {
                    bl3 = true;
                }
                domNodeArray[n3] = object3;
                ++n3;
                object3 = ((DomNode)object3).parent;
            }
            if (object3 != null) {
                throw new RuntimeException("dispatchEvent capture stack size");
            }
            n = n3;
            domEvent.stop = false;
            if (bl3) {
                domEvent.eventPhase = 1;
                while (!domEvent.stop && n3-- > 0) {
                    object3 = domNodeArray[n3];
                    if (((DomNode)object3).nListeners == 0) continue;
                    this.notifyNode(domEvent, (DomNode)object3, true, listenerRecordArray);
                }
            }
            if (!domEvent.stop && this.nListeners != 0) {
                domEvent.eventPhase = (short)2;
                this.notifyNode(domEvent, this, false, listenerRecordArray);
            } else if (!bl3) {
                domEvent.stop = true;
            }
            if (!domEvent.stop && domEvent.bubbles) {
                domEvent.eventPhase = (short)3;
                n3 = 0;
                while (!domEvent.stop && n3 < n && (object3 = domNodeArray[n3]) != null) {
                    if (((DomNode)object3).nListeners != 0) {
                        this.notifyNode(domEvent, (DomNode)object3, false, listenerRecordArray);
                    }
                    ++n3;
                }
            }
            domEvent.eventPhase = 0;
            bl = domEvent.doDefault;
            Object var7_17 = null;
            if (!bl2) return bl;
            object = lockNode;
        }
        catch (Throwable throwable) {
            Object var7_18 = null;
            if (!bl2) throw throwable;
            Object object4 = lockNode;
            synchronized (object4) {
                int n4 = 0;
                while (n4 < n) {
                    domNodeArray[n4] = null;
                    ++n4;
                }
                dispatchDataLock = false;
                throw throwable;
            }
        }
        synchronized (object) {
            int n5 = 0;
            while (n5 < n) {
                domNodeArray[n5] = null;
                ++n5;
            }
            dispatchDataLock = false;
            return bl;
        }
    }

    private void notifyNode(DomEvent domEvent, DomNode domNode, boolean bl, ListenerRecord[] listenerRecordArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < domNode.nListeners) {
            ListenerRecord listenerRecord = domNode.listeners[n2];
            if (listenerRecord.useCapture == bl && domEvent.type.equals(listenerRecord.type)) {
                if (n < listenerRecordArray.length) {
                    listenerRecordArray[n++] = listenerRecord;
                } else {
                    throw new RuntimeException("Event notification set size exceeded");
                }
            }
            ++n2;
        }
        domEvent.currentNode = domNode;
        n2 = 0;
        while (n2 < n) {
            try {
                int n3 = 0;
                while (n3 < domNode.nListeners) {
                    if (domNode.listeners[n3].equals(listenerRecordArray[n2])) {
                        listenerRecordArray[n2].listener.handleEvent(domEvent);
                        break;
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            listenerRecordArray[n2] = null;
            ++n2;
        }
    }

    @Override
    public final void removeEventListener(String string, EventListener eventListener, boolean bl) {
        int n = 0;
        while (n < this.nListeners) {
            if (this.listeners[n].listener == eventListener && this.listeners[n].useCapture == bl && this.listeners[n].type.equals(string)) {
                if (this.nListeners == 1) {
                    this.listeners = null;
                    this.nListeners = 0;
                    return;
                }
                int n2 = n + 1;
                while (n2 < this.nListeners) {
                    this.listeners[n++] = this.listeners[n2++];
                    ++n2;
                }
                this.listeners[this.nListeners += -1] = null;
                return;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void normalize() {
        Node node;
        int n = 0;
        block4: while ((node = this.item(n)) != null) {
            switch (node.getNodeType()) {
                case 3: {
                    Node node2 = this.item(n + 1);
                    if (node2 == null || node2.getNodeType() != 3) break;
                    Text text = (Text)node;
                    text.appendData(node2.getNodeValue());
                    this.removeChild(node2);
                    continue block4;
                }
                case 1: {
                    node.normalize();
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n2 = 0;
                    while (n2 < namedNodeMap.getLength()) {
                        namedNodeMap.item(n2).normalize();
                        ++n2;
                    }
                    break block0;
                }
            }
            ++n;
        }
    }

    public boolean nameAndTypeEquals(Node node) {
        if (this.getNodeType() != node.getNodeType()) {
            return false;
        }
        String string = this.getNamespaceURI();
        String string2 = node.getNamespaceURI();
        if (string != null && string2 != null) {
            return string.equals(string2) && this.getLocalName().equals(node.getLocalName());
        }
        if (string == null && string2 == null) {
            return this.getNodeName().equals(node.getNodeName());
        }
        return false;
    }

    static {
        ancestors = new DomNode[20];
        notificationSet = new ListenerRecord[10];
        mutationEvent = new DomEvent.DomMutationEvent(null);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ShadowList
    implements NodeList {
        private LiveNodeList liveList;

        ShadowList(String string, String string2) {
            this.liveList = new LiveNodeList(string, string2);
        }

        public void finalize() {
            this.liveList.detach();
            this.liveList = null;
        }

        @Override
        public Node item(int n) {
            return this.liveList.item(n);
        }

        @Override
        public int getLength() {
            return this.liveList.getLength();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LiveNodeList
    implements NodeList,
    EventListener,
    NodeFilter {
        private String elementURI;
        private String elementName;
        private DomIterator current;
        private int lastIndex;

        LiveNodeList(String string, String string2) {
            this.elementURI = string;
            this.elementName = string2;
            DomNode.this.addEventListener("DOMNodeInserted", this, true);
            DomNode.this.addEventListener("DOMNodeRemoved", this, true);
        }

        void detach() {
            this.current.detach();
            this.current = null;
            DomNode.this.removeEventListener("DOMNodeInserted", this, true);
            DomNode.this.removeEventListener("DOMNodeRemoved", this, true);
        }

        @Override
        public short acceptNode(Node node) {
            if (node == DomNode.this) {
                return 3;
            }
            if (this.elementURI != null) {
                if (!"*".equals(this.elementURI) && !this.elementURI.equals(node.getNamespaceURI())) {
                    return 3;
                }
                if (!"*".equals(this.elementName) && !this.elementName.equals(node.getLocalName())) {
                    return 3;
                }
            } else if (!"*".equals(this.elementName) && !this.elementName.equals(node.getNodeName())) {
                return 3;
            }
            return 1;
        }

        private DomIterator createIterator() {
            return new DomIterator(DomNode.this, 1, this, true);
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            Node node = mutationEvent.getRelatedNode();
            if (node.getNodeType() != 1) {
                return;
            }
            if (node.getNodeName() != this.elementName) {
                return;
            }
            if (node.getNamespaceURI() != this.elementURI) {
                return;
            }
            this.current = null;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Node item(int var1_1) {
            if (this.current == null) {
                this.current = this.createIterator();
                this.lastIndex = -1;
            }
            if (var1_1 > this.lastIndex) ** GOTO lbl13
            while (var1_1 != this.lastIndex) {
                this.current.previousNode();
                this.lastIndex += -1;
            }
            return this.current.previousNode();
lbl-1000:
            // 1 sources

            {
                this.current.nextNode();
lbl13:
                // 2 sources

                ** while (++this.lastIndex != var1_1)
            }
lbl14:
            // 1 sources

            return this.current.nextNode();
        }

        @Override
        public int getLength() {
            int n = 0;
            DomIterator domIterator = this.createIterator();
            while (domIterator.nextNode() != null) {
                ++n;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ListenerRecord {
        String type;
        EventListener listener;
        boolean useCapture;

        ListenerRecord(String string, EventListener eventListener, boolean bl) {
            this.type = string.intern();
            this.listener = eventListener;
            this.useCapture = bl;
        }

        boolean equals(ListenerRecord listenerRecord) {
            return this.listener == listenerRecord.listener && this.useCapture == listenerRecord.useCapture && this.type == listenerRecord.type;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DomEventException
    extends EventException {
        DomEventException() {
            super((short)0, "unspecified event type");
        }
    }
}

