/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuShortcut;
import java.awt.NativeGraphics;
import java.awt.PopupMenu;
import java.awt.ShortcutConsumer;
import java.awt.ShortcutHandler;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarMenu
extends Component
implements ShortcutConsumer {
    private static int Dx = 5;
    private Menu selection;
    MenuBar mb;
    private PopupMenu current;
    private WindowAdapter wa;

    public BarMenu(MenuBar menuBar) {
        this.mb = menuBar;
        this.setForeground(Defaults.MenuTxtClr);
        this.setBackground(Defaults.MenuBgClr);
        this.setFont(Defaults.MenuFont);
    }

    @Override
    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            super.addNotify();
            this.mb.owner = this.getToplevel();
            this.mb.parent = this;
            this.mb.addNotify();
            this.mb.propagateOldEvents((this.flags & 0x20) != 0);
            this.registerHandlers();
        }
    }

    void disposeCurrent() {
        if (this.current != null) {
            this.unlinkCurrent();
            this.current.dispose();
            this.current = null;
        }
    }

    @Override
    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), false);
    }

    @Override
    public Graphics getGraphics() {
        int n = this.x;
        int n2 = this.y;
        if ((Toolkit.flags & 0x10) != 0) {
            n -= this.parent.deco.x;
            n2 -= this.parent.deco.y;
        }
        return NativeGraphics.getGraphics(this.parent, ((Window)this.parent).nativeData, 0, n, n2, 0, 0, this.width, this.height, this.parent.fgClr, this.parent.bgClr, this.parent.font, false);
    }

    int getX(Menu menu) {
        int n = this.mb.menus.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Menu menu2 = (Menu)this.mb.menus.elementAt(n3);
            if (menu2 == menu) {
                return n2;
            }
            n2 += menu2.getWidth() + 2 * Dx;
            ++n3;
        }
        return -1;
    }

    @Override
    public void handleShortcut(MenuShortcut menuShortcut) {
        switch (menuShortcut.keyCode) {
            case 37: {
                this.selectPrev();
                return;
            }
            case 39: {
                this.selectNext();
                return;
            }
            case 10: {
                this.processSelection();
            }
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    Menu menuAt(int n) {
        int n2 = this.mb.menus.size();
        int n3 = Dx;
        int n4 = 0;
        while (n4 < n2) {
            Menu menu = (Menu)this.mb.menus.elementAt(n4);
            int n5 = menu.getWidth();
            if ((n3 += n5 + Dx) > n) {
                return menu;
            }
            n3 += Dx;
            ++n4;
        }
        return null;
    }

    boolean openSelection() {
        if (this.selection == null || this.selection.getItemCount() == 0) {
            return false;
        }
        this.disposeCurrent();
        this.current = new PopupMenu(this.selection);
        this.current.show(this, this.getX(this.selection), this.height);
        MenuShortcut menuShortcut = new MenuShortcut(this, 37, 0);
        MenuShortcut menuShortcut2 = new MenuShortcut(this, 39, 0);
        ShortcutHandler.addShortcut(menuShortcut, this.current.wnd, this);
        ShortcutHandler.addShortcut(menuShortcut2, this.current.wnd, this);
        this.current.wnd.addWindowListener(this.wa);
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.mb.menus.size();
        int n2 = 2 * Dx;
        int n3 = 1;
        int n4 = 1;
        int n5 = this.height - 2;
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(0, 0, this.width, this.height, true);
        int n6 = 0;
        while (n6 < n) {
            Menu menu = (Menu)this.mb.menus.elementAt(n6);
            int n7 = menu.getWidth() + n2;
            menu.paint(graphics, n3, Dx, n4, n7, n5, this.bgClr, this.fgClr, this.selection == menu);
            n3 += n7;
            ++n6;
        }
    }

    void paintMenu(Graphics graphics, Menu menu) {
        int n = this.mb.menus.size();
        int n2 = 1;
        int n3 = 2 * Dx;
        int n4 = 1;
        int n5 = this.height - 2;
        int n6 = 0;
        while (n6 < n) {
            Menu menu2 = (Menu)this.mb.menus.elementAt(n6);
            int n7 = menu2.getWidth() + n3;
            if (menu == menu2) {
                menu2.paint(graphics, n2, Dx, n4, n7, n5, this.bgClr, this.fgClr, this.selection == menu2);
                return;
            }
            n2 += n7;
            ++n6;
        }
    }

    void processSelection() {
        if (this.selection != null && !this.openSelection()) {
            this.selection.handleShortcut(null);
            this.selectMenu(null);
        }
    }

    void registerHandlers() {
        MenuShortcut menuShortcut = new MenuShortcut(this, 37, 0);
        MenuShortcut menuShortcut2 = new MenuShortcut(this, 39, 0);
        MenuShortcut menuShortcut3 = new MenuShortcut(this, 10, 0);
        ShortcutHandler.addShortcut(menuShortcut, this, this);
        ShortcutHandler.addShortcut(menuShortcut2, this, this);
        ShortcutHandler.addShortcut(menuShortcut3, this, this);
        1 var4_4 = new 1();
        2 var5_5 = new 2();
        this.wa = new 3();
        this.addMouseMotionListener(var4_4);
        this.addMouseListener(var5_5);
    }

    @Override
    public void removeNotify() {
        super.addNotify();
        this.mb.removeNotify();
        ShortcutHandler.removeShortcuts(this);
    }

    void selectMenu(Menu menu) {
        Menu menu2 = this.selection;
        if (menu == this.selection) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (menu == null) {
            this.disposeCurrent();
            this.selection = null;
            this.paintMenu(graphics, menu2);
        } else if (this.selection == null) {
            this.selection = menu;
            this.paintMenu(graphics, menu);
            this.openSelection();
        } else {
            this.selection = menu;
            this.paintMenu(graphics, menu2);
            this.paintMenu(graphics, menu);
            this.disposeCurrent();
            this.openSelection();
        }
        graphics.dispose();
    }

    void selectNext() {
        try {
            if (this.selection == null) {
                this.selectMenu((Menu)this.mb.menus.firstElement());
                return;
            }
            int n = this.mb.menus.indexOf(this.selection) + 1;
            this.selectMenu((Menu)this.mb.menus.elementAt(n));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void selectPrev() {
        try {
            if (this.selection == null) {
                this.selectMenu((Menu)this.mb.menus.lastElement());
                return;
            }
            int n = this.mb.menus.indexOf(this.selection) - 1;
            this.selectMenu((Menu)this.mb.menus.elementAt(n));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void setMenus(MenuBar menuBar) {
        this.mb = menuBar;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    void unlinkCurrent() {
        if (this.current != null && this.current.wnd != null) {
            ShortcutHandler.removeShortcuts(this.current.wnd);
            this.current.wnd.removeWindowListener(this.wa);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 1
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (AWTEvent.keyTgt == mouseEvent.getSource() || BarMenu.this.current != null) {
                BarMenu.this.selectMenu(BarMenu.this.menuAt(mouseEvent.getX()));
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 2
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            BarMenu.this.requestFocus();
            BarMenu.this.selectMenu(BarMenu.this.menuAt(mouseEvent.getX()));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BarMenu.this.processSelection();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (BarMenu.this.current == null) {
                BarMenu.this.selectMenu(null);
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 3
    extends WindowAdapter {
        @Override
        public void windowClosed(WindowEvent windowEvent) {
            BarMenu.this.selectMenu(null);
        }
    }
}

