/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BorderLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = -8658291919501921765L;
    Component center;
    Component north;
    Component west;
    Component south;
    Component east;
    int hGap;
    int vGap;
    public static final String CENTER = "Center";
    public static final String NORTH = "North";
    public static final String WEST = "West";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String BEFORE_LINE_BEGINS = "Before";

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int n, int n2) {
        this.hGap = n;
        this.vGap = n2;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        try {
            this.addLayoutComponent((String)object, component);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(new StringBuffer().append(this.getClass().getName()).append(": invalid constraint ").append(object).toString());
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            string = CENTER;
        }
        if (CENTER.equalsIgnoreCase(string)) {
            this.center = component;
            return;
        }
        if (NORTH.equalsIgnoreCase(string)) {
            this.north = component;
            return;
        }
        if (WEST.equalsIgnoreCase(string)) {
            this.west = component;
            return;
        }
        if (SOUTH.equalsIgnoreCase(string)) {
            this.south = component;
            return;
        }
        if (EAST.equalsIgnoreCase(string)) {
            this.east = component;
            return;
        }
        throw new IllegalArgumentException(new StringBuffer().append(this.getClass().getName()).append(": invalid position: ").append(string).toString());
    }

    public int getHgap() {
        return this.hGap;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int getVgap() {
        return this.vGap;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension;
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = container.height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.width - insets.right;
        if (this.north != null && (this.north.flags & 1) != 0) {
            dimension = this.north.getPreferredSize();
            this.north.setBounds(n3, n, n4 - n3, dimension.height);
            n += dimension.height + this.vGap;
        }
        if (this.south != null && (this.south.flags & 1) != 0) {
            dimension = this.south.getPreferredSize();
            this.south.setBounds(n3, n2 - dimension.height, n4 - n3, dimension.height);
            n2 -= dimension.height + this.vGap;
        }
        if (this.east != null && (this.east.flags & 1) != 0) {
            dimension = this.east.getPreferredSize();
            this.east.setBounds(n4 - dimension.width, n, dimension.width, n2 - n);
            n4 -= dimension.width + this.hGap;
        }
        if (this.west != null && (this.west.flags & 1) != 0) {
            dimension = this.west.getPreferredSize();
            this.west.setBounds(n3, n, dimension.width, n2 - n);
            n3 += dimension.width + this.hGap;
        }
        if (this.center != null && (this.center.flags & 1) != 0) {
            this.center.setBounds(n3, n, n4 - n3, n2 - n);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Dimension dimension2 = new Dimension();
        if (this.east != null && (this.east.flags & 1) != 0) {
            dimension = this.east.getMinimumSize();
            dimension2.width += dimension.width + this.hGap;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.west != null && (this.west.flags & 1) != 0) {
            dimension = this.west.getMinimumSize();
            dimension2.width += dimension.width + this.hGap;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.center != null && (this.center.flags & 1) != 0) {
            dimension = this.center.getMinimumSize();
            dimension2.width += dimension.width;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.north != null && (this.north.flags & 1) != 0) {
            dimension = this.north.getMinimumSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height + this.vGap;
        }
        if (this.south != null && (this.south.flags & 1) != 0) {
            dimension = this.south.getMinimumSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height + this.vGap;
        }
        Insets insets = container.getInsets();
        dimension2.width += insets.left + insets.right;
        dimension2.height += insets.top + insets.bottom;
        return dimension2;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Dimension dimension2 = new Dimension();
        if (this.east != null && (this.east.flags & 1) != 0) {
            dimension = this.east.getPreferredSize();
            dimension2.width += dimension.width + this.hGap;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.west != null && (this.west.flags & 1) != 0) {
            dimension = this.west.getPreferredSize();
            dimension2.width += dimension.width + this.hGap;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.center != null && (this.center.flags & 1) != 0) {
            dimension = this.center.getPreferredSize();
            dimension2.width += dimension.width;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.north != null && (this.north.flags & 1) != 0) {
            dimension = this.north.getPreferredSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height + this.vGap;
        }
        if (this.south != null && (this.south.flags & 1) != 0) {
            dimension = this.south.getPreferredSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height + this.vGap;
        }
        Insets insets = container.getInsets();
        dimension2.width += insets.left + insets.right;
        dimension2.height += insets.top + insets.bottom;
        return dimension2;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component == this.center) {
            this.center = null;
            return;
        }
        if (component == this.north) {
            this.north = null;
            return;
        }
        if (component == this.west) {
            this.west = null;
            return;
        }
        if (component == this.south) {
            this.south = null;
            return;
        }
        if (component == this.east) {
            this.east = null;
        }
    }

    public void setHgap(int n) {
        this.hGap = n;
    }

    public void setVgap(int n) {
        this.vGap = n;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("[hgap=").append(this.hGap).append(",vgap=").append(this.vGap).append(']').toString();
    }
}

