/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.ItemEvt;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable {
    private boolean isChecked;
    private ItemListener iListener;
    private static int counter;
    private static final long serialVersionUID = 6190621106981774043L;

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String string) {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) {
        super(string);
        this.isChecked = bl;
        this.setName(new StringBuffer().append("chkmenuitem").append(counter++).toString());
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.isChecked) {
            Object[] objectArray = new Object[]{this.getLabel()};
            return objectArray;
        }
        return null;
    }

    public boolean getState() {
        return this.isChecked;
    }

    @Override
    int getWidth() {
        int n = super.getWidth();
        return n += 3 * this.getHeight() / 4;
    }

    @Override
    public void handleShortcut(MenuShortcut menuShortcut) {
        if (((long)this.eventMask & Integer.MIN_VALUE) != 0L) {
            return;
        }
        this.setState(this.isChecked ^ true);
        if (this.iListener != null || ((long)this.eventMask & 0x200L) != 0L || (this.flags & 0x20) > 0) {
            Toolkit.eventQueue.postEvent(ItemEvt.getEvent(this, 701, this.getLabel(), this.isChecked ? 1 : 2));
        }
    }

    @Override
    int paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2, boolean bl) {
        int n6 = super.paint(graphics, n, n2 + 6, n3, n4, n5, color, color2, bl);
        int n7 = n3 + (n6 - 8) / 2 + 1;
        graphics.setColor(Defaults.BtnClr);
        graphics.fill3DRect(n + 3, n7, 8, 8, this.isChecked ^ true);
        return n6;
    }

    @Override
    public String paramString() {
        return new StringBuffer().append(super.paramString()).append(",state=").append(this.getState()).toString();
    }

    void process(ItemEvent itemEvent) {
        if (this.iListener != null || ((long)this.eventMask & 0xFFFFFFFF80000200L) == 512L) {
            this.processEvent(itemEvent);
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.iListener != null) {
            this.iListener.itemStateChanged(itemEvent);
        }
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public synchronized void setState(boolean bl) {
        this.isChecked = bl;
    }
}

