/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dialog
extends Frame {
    private static final long serialVersionUID = 5920926903803293709L;
    static Insets dialogInsets;
    static Rectangle dialogDeco;

    public Dialog(Frame frame) {
        this(frame, null, false);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        super(frame, string);
        this.deco = dialogDeco;
        if (bl) {
            this.flags |= 0x80;
        }
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    @Override
    void createNative() {
        int n = this.x;
        int n2 = this.y;
        int n3 = this.width;
        int n4 = this.height;
        this.insets = dialogInsets;
        if ((Toolkit.flags & 0x10) != 0) {
            n += this.deco.x;
            n2 += this.deco.y;
            n3 -= this.deco.width;
            n4 -= this.deco.height;
        }
        this.nativeData = Toolkit.wndCreateDialog(this.owner.nativeData, this.title, n, n2, n3, n4, this.cursor.type, this.bgClr.getNativeValue(), (this.flags & 0x40) != 0);
    }

    @Override
    public void hide() {
        if ((this.flags & 0x80) != 0) {
            this.dispose();
            return;
        }
        super.hide();
    }

    public boolean isModal() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width += Defaults.DialogInsets.left + Defaults.DialogInsets.right;
        dimension.height += Defaults.DialogInsets.top + Defaults.DialogInsets.bottom;
        return dimension;
    }

    static void setDecoInsets(int n, int n2, int n3, int n4, int n5) {
        Dialog.dialogInsets.top = n;
        Dialog.dialogInsets.left = n2;
        Dialog.dialogInsets.bottom = n3;
        Dialog.dialogInsets.right = n4;
        Dialog.dialogDeco.x = n2;
        Dialog.dialogDeco.y = n;
        Dialog.dialogDeco.width = n2 + n4;
        Dialog.dialogDeco.height = n + n3;
        if (n5 != -1) {
            Component component = AWTEvent.sources[n5];
            component.height = 0;
            component.width = 0;
        }
    }

    public void setModal(boolean bl) {
        if (bl) {
            this.flags |= 0x80;
            return;
        }
        this.flags &= 0xFFFFFF7F;
    }

    @Override
    public void show() {
        super.show();
        if ((this.flags & 0x80) != 0) {
            if (this.owner != null) {
                this.owner.propagateTempEnabled(false);
                Toolkit.eventThread.run(this);
                this.owner.propagateTempEnabled(true);
                return;
            }
            Toolkit.eventThread.run(this);
        }
    }

    static {
        Insets insets = Defaults.DialogInsets;
        dialogInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        dialogDeco = new Rectangle(insets.left, insets.top, insets.left + insets.right, insets.top + insets.bottom);
        Toolkit.wndSetDialogInsets(insets.top, insets.left, insets.bottom, insets.right);
    }
}

