/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Image;
import java.awt.ImageNativeProducer;
import java.awt.Toolkit;
import kaffe.util.Ptr;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageFrameLoader
extends Thread {
    Image img;

    ImageFrameLoader(Image image) {
        super("ImageFrameLoader");
        this.img = image;
        image.flags |= 0x800;
        this.setPriority(2);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        if (this.img.producer instanceof ImageNativeProducer) {
            this.runINPLoop();
            return;
        }
        throw new Error(new StringBuffer().append("Unhandled production: ").append(this.img.producer).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runINPLoop() {
        Ptr ptr = this.img.nativeData;
        this.img.flags |= 0x1000;
        do {
            int n = Toolkit.imgGetLatency(this.img.nativeData);
            long l = System.currentTimeMillis();
            Image image = this.img;
            synchronized (image) {
                try {
                    while ((this.img.flags & 0x800) != 0) {
                        this.img.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n2 = (int)(System.currentTimeMillis() - l);
            if (n2 < n) {
                try {
                    Thread.sleep(n - n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 0 || n2 < 2 * n) {
                ptr = Toolkit.imgGetNextFrame(this.img.nativeData);
                if (ptr == null) {
                    return;
                }
            } else {
                ptr = Toolkit.imgSetFrame(this.img.nativeData, 0);
            }
            this.img.nativeData = ptr;
            this.img.flags |= 0x800;
            this.img.stateChange(16, 0, 0, this.img.width, this.img.height);
        } while (this.img.observers != null);
    }
}

