/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Label
extends Component {
    private static final long serialVersionUID = 3094126758329070636L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final String[] ALIGNMENTS = new String[]{"left", "center", "right"};
    private static int counter;
    int align;
    String label;
    boolean hasBorder;
    FontMetrics fm;

    public Label() {
        this(null);
    }

    public Label(String string) {
        this(string, 0);
    }

    public Label(String string, int n) {
        this.setForeground(Defaults.LabelClr);
        this.setFont(Defaults.LabelFont);
        this.setText(string != null ? string : "");
        this.setAlignment(n);
        this.setName(new StringBuffer().append("label").append(counter++).toString());
    }

    public int getAlignment() {
        return this.align;
    }

    @Override
    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), true);
    }

    public String getText() {
        return this.label;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2 = this.fm.stringWidth(this.label);
        int n3 = this.hasBorder ? 2 : 0;
        int n4 = this.height - (this.height - this.fm.getHeight()) / 2 - this.fm.getDescent();
        switch (this.align) {
            case 1: {
                n = (this.width - n2) / 2;
                break;
            }
            case 2: {
                n = this.width - n2 - n3;
                break;
            }
            default: {
                n = n3 + 1;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.hasBorder) {
            this.kaffePaintBorder(graphics);
        }
        if (Defaults.LabelTxtCarved) {
            graphics.setColor(Color.white);
            graphics.drawString(this.label, n + 1, n4 + 1);
        }
        graphics.setColor(this.fgClr);
        graphics.drawString(this.label, n, n4);
    }

    @Override
    protected String paramString() {
        return new StringBuffer().append(super.paramString()).append(",align=").append(ALIGNMENTS[this.getAlignment()]).append(",text=").append(this.getText()).toString();
    }

    @Override
    public Dimension preferredSize() {
        int n = 40;
        int n2 = 20;
        if (this.fm != null) {
            n = Math.max(n, this.fm.stringWidth(this.label));
            n2 = Math.max(n2, 3 * this.fm.getHeight() / 2);
        }
        return new Dimension(n, n2);
    }

    public void setAlignment(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.align = n;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (this.label == null || !this.label.equals(string)) {
            Graphics graphics;
            this.label = string;
            boolean bl = this.hasBorder = string.startsWith(" ") && string.endsWith(" ");
            if ((this.flags & 0x405) == 1029 && (graphics = this.getGraphics()) != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
    }
}

