/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.RowCanvas;
import java.awt.Scrollbar;
import java.awt.TextBuffer;
import java.awt.TextComponent;
import java.awt.TextCursor;
import java.awt.TextEvt;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextArea
extends TextComponent {
    private static final long serialVersionUID = 3692302836626095722L;
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    int tabWidth;
    int crows;
    int ccols;
    TextPane tp;

    public TextArea() {
        this(null, 10, 20, 0);
    }

    public TextArea(String string) {
        this(string, 10, 20, 0);
    }

    public TextArea(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public TextArea(String string, int n, int n2, int n3) {
        this.Block$();
        this.crows = n;
        this.ccols = n2;
        this.setLayout(null);
        this.setFont(Defaults.TextAreaFont);
        if (n3 == 1 || n3 == 0) {
            this.tp.vScroll = new Scrollbar(1, 0, 0, 0, 0);
            this.add(this.tp.vScroll);
        }
        if (n3 == 2 || n3 == 0) {
            this.tp.hScroll = new Scrollbar(0, 0, 0, 0, 0);
            this.tp.hScroll.setUnitIncrement(this.tp.fm.charWidth('x'));
            this.add(this.tp.hScroll);
        }
        this.buildMenu();
        this.add(this.tp);
        this.tp.setListeners();
        this.setBackground(Defaults.TextAreaBgClr);
        this.setForeground(Defaults.TextAreaTxtClr);
        if (string != null) {
            this.append(string);
        }
    }

    public TextArea(int n, int n2) {
        this(null, n, n2, 0);
    }

    @Override
    public void add(PopupMenu popupMenu) {
        this.tp.add(popupMenu);
    }

    public void append(String string) {
        this.tp.append(string);
    }

    public void appendText(String string) {
        this.append(string);
    }

    protected void buildMenu() {
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(new MenuItem("Cut")).setShortcut(new MenuShortcut(85, false));
        popupMenu.add(new MenuItem("Copy")).setShortcut(new MenuShortcut(79, false));
        popupMenu.add(new MenuItem("Paste")).setShortcut(new MenuShortcut(65, false));
        popupMenu.addSeparator();
        popupMenu.add(new MenuItem("Select All")).setShortcut(new MenuShortcut(83, false));
        popupMenu.addActionListener(this);
        this.tp.add(popupMenu);
    }

    @Override
    public void doLayout() {
        this.tp.innerLayout();
    }

    @Override
    public Color getBackground() {
        return this.tp.getBackground();
    }

    @Override
    public int getCaretPosition() {
        Point point = new Point(this.tp.tCursor.index, this.tp.tCursor.yindex);
        return this.tp.get1D(point);
    }

    public int getColumns() {
        return this.ccols;
    }

    @Override
    public Color getForeground() {
        return this.tp.getForeground();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getMinimumSize(int n, int n2) {
        return this.minimumSize(n, n2);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.preferredSize(n, n2);
    }

    public int getRows() {
        return this.crows;
    }

    public int getScrollbarVisibility() {
        if (this.tp.hScroll == null && this.tp.vScroll == null) {
            return 3;
        }
        if (this.tp.hScroll == null) {
            return 1;
        }
        if (this.tp.vScroll == null) {
            return 2;
        }
        return 0;
    }

    @Override
    public String getSelectedText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.min(this.tp.sSel.y, this.tp.eSel.y);
        int n2 = Math.max(this.tp.sSel.y, this.tp.eSel.y);
        int n3 = n;
        while (n3 <= n2) {
            TextBuffer textBuffer = (TextBuffer)this.tp.rows.elementAt(n3);
            int n4 = this.tp.selXStart(n3);
            int n5 = this.tp.selXEnd(n3, textBuffer);
            stringBuffer.append(textBuffer.buf, n4, n5 - n4);
            if (n3 < n2) {
                stringBuffer.append(" ");
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    @Override
    public int getSelectionEnd() {
        int n = this.tp.get1D(this.tp.sSel);
        int n2 = this.tp.get1D(this.tp.eSel);
        return Math.max(n, n2);
    }

    @Override
    public int getSelectionStart() {
        int n = this.tp.get1D(this.tp.sSel);
        int n2 = this.tp.get1D(this.tp.eSel);
        return Math.min(n, n2);
    }

    @Override
    public String getText() {
        int n = this.tp.rows.size() - 1;
        StringBuffer stringBuffer = new StringBuffer((n + 1) * 80);
        int n2 = 0;
        while (n2 <= n) {
            TextBuffer textBuffer = (TextBuffer)this.tp.rows.elementAt(n2);
            stringBuffer.append(textBuffer.buf, 0, textBuffer.len);
            if (n2++ >= n) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    void hPosChange() {
        this.tp.hPosChange();
    }

    public synchronized void insert(String string, int n) {
        this.tp.insert(string, n);
    }

    @Override
    public Dimension minimumSize() {
        return this.minimumSize(this.crows, this.ccols);
    }

    public Dimension minimumSize(int n, int n2) {
        return new Dimension(n2 * this.tp.fm.charWidth('x'), n * this.tp.fm.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.paintChild(this.tp, false);
        if (this.tp.hScroll != null && (this.tp.hScroll.flags & 1) != 0) {
            graphics.paintChild(this.tp.hScroll, true);
        }
        if (this.tp.vScroll != null && (this.tp.vScroll.flags & 1) != 0) {
            graphics.paintChild(this.tp.vScroll, true);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }

    @Override
    public Dimension preferredSize() {
        return this.preferredSize(this.crows, this.ccols);
    }

    public Dimension preferredSize(int n, int n2) {
        return new Dimension(n2 * this.tp.fm.charWidth('x'), n * this.tp.fm.getHeight());
    }

    public void repaintRow(int n) {
        this.tp.repaintLine(n, 0, null);
    }

    public synchronized void replaceRange(String string, int n, int n2) {
        this.replaceText(string, n, n2);
    }

    @Override
    void replaceSelectionWith(String string) {
        this.tp.replaceSelectionWith(string);
    }

    public synchronized void replaceText(String string, int n, int n2) {
        this.tp.replaceRange(string, n, n2);
    }

    @Override
    public void requestFocus() {
        this.tp.requestFocus();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.tp.innerLayout();
        this.flags |= 2;
    }

    @Override
    public void select(int n, int n2) {
        Point point = this.tp.get2D(n2);
        this.tp.sSel = this.tp.get2D(n);
        this.tp.updateSel(point.x, point.y, true);
    }

    @Override
    public void selectAll() {
        TextBuffer textBuffer = (TextBuffer)this.tp.rows.lastElement();
        this.tp.sSel.x = 0;
        this.tp.sSel.y = 0;
        this.tp.eSel.x = 0;
        this.tp.eSel.y = 0;
        this.tp.updateSel(textBuffer.len, this.tp.rows.size() - 1, true);
    }

    @Override
    public void setBackground(Color color) {
        this.tp.setBackground(color);
    }

    @Override
    public void setCaretPosition(int n) {
        Point point = this.tp.get2D(n);
        this.tp.setCursorPos(point.x, point.y, true, true);
    }

    public void setColumns(int n) {
        this.ccols = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tp.setEnabled(bl);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.tp.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        this.tp.setForeground(color);
    }

    public void setRows(int n) {
    }

    @Override
    public void setSelectionEnd(int n) {
        Point point = this.tp.get2D(n);
        this.tp.updateSel(point.x, point.y, true);
    }

    @Override
    public void setSelectionStart(int n) {
        Point point = this.tp.get2D(n);
        this.tp.updateSel(point.x, point.y, true);
    }

    @Override
    public void setText(String string) {
        this.tp.setContents(string);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void vPosChange(int n) {
        this.tp.vPosChange(n);
    }

    private /* synthetic */ void Block$() {
        this.tp = new TextPane();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TextPane
    extends RowCanvas
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        TextCursor tCursor;
        Point sSel;
        Point eSel;

        public TextPane() {
            this.Block$();
            this.xOffsInit = 4;
            this.xOffs = 4;
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.tCursor.setPos(this.xOffs, this.rowHeight + 2);
            this.insertLine("", 0);
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addFocusListener(this);
        }

        synchronized void append(String string) {
            this.blankCursor();
            String[] stringArray = this.breakLines(string);
            int n = this.rows.size() - 1;
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n);
            textBuffer.append(stringArray[0]);
            int n2 = 1;
            while (n2 < stringArray.length) {
                textBuffer = new TextBuffer(stringArray[n2]);
                textBuffer.setMetrics(this.fm, TextArea.this.tabWidth);
                this.rows.addElement(textBuffer);
                ++n2;
            }
            int n3 = this.rows.size() - 1;
            this.makeVisible(n3);
            this.updateScrolls();
            this.repaintRows(n, n3 - n);
            this.setCursorPos(textBuffer.len, n3, true, true);
        }

        void backspace() {
            TextBuffer textBuffer = this.getCursorLine();
            if (this.tCursor.index >= 1) {
                textBuffer.remove(this.tCursor.index - 1, 1);
                this.setCursorPos(this.tCursor.index - 1, this.tCursor.yindex, false, true);
                this.repaintLine(this.tCursor.yindex, this.tCursor.index, textBuffer);
                return;
            }
            if (this.cursorLeft(1, false)) {
                TextBuffer textBuffer2 = this.getCursorLine();
                textBuffer2.append(textBuffer);
                this.rows.removeElement(textBuffer);
                this.repaint();
                this.updateScrolls();
            }
        }

        void blankCursor() {
            if (this.rgr != null) {
                this.rgr.setColor(this.bgClr);
                this.tCursor.blank(this.rgr, this.xOffs, this.getRowYPos(this.tCursor.yindex));
                this.rgr.setColor(this.fgClr);
                TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
                textBuffer.paint(this.rgr, this.xOffs, this.tCursor.y, this.rowHeight, this.tCursor.index, 1);
            }
        }

        String[] breakLines(String string) {
            int n = 0;
            int n2 = string.length();
            if (string == null || n2 == 0) {
                return new String[1];
            }
            Vector vector = new Vector(n2 / 20);
            char[] cArray = string.toCharArray();
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n3];
                if (c == '\n') {
                    vector.addElement(new String(cArray, n, n3 - n));
                    n = n3 + 1;
                } else if (c == '\r') {
                    vector.addElement(new String(cArray, n, n3 - n));
                    ++n3;
                    while (n3 < n2 && cArray[n3] == '\r') {
                        ++n3;
                    }
                    n = cArray[n3] == '\n' ? n3 + 1 : n3;
                }
                ++n3;
            }
            if (n <= n2) {
                vector.addElement(new String(cArray, n, n3 - n));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        void cursorDown(int n, boolean bl) {
            int n2 = Math.min(this.tCursor.yindex + n, this.rows.size() - 1);
            if (n2 != this.tCursor.yindex) {
                if (bl) {
                    this.updateSel(this.tCursor.index, n2, true);
                    return;
                }
                this.setCursorPos(this.tCursor.index, n2, true, true);
            }
        }

        void cursorEnd(boolean bl) {
            TextBuffer textBuffer = this.getCursorLine();
            if (bl) {
                this.updateSel(textBuffer.len, this.tCursor.yindex, true);
                return;
            }
            this.setCursorPos(textBuffer.len, this.tCursor.yindex, true, true);
        }

        void cursorHome(boolean bl) {
            if (bl) {
                this.updateSel(0, this.tCursor.yindex, true);
                return;
            }
            this.setCursorPos(0, this.tCursor.yindex, true, true);
        }

        boolean cursorLeft(int n, boolean bl) {
            int n2 = -1;
            int n3 = -1;
            if (this.tCursor.index >= n) {
                n2 = this.tCursor.index - n;
                n3 = this.tCursor.yindex;
            } else if (this.tCursor.yindex > 0) {
                n2 = ((TextBuffer)this.rows.elementAt((int)(this.tCursor.yindex - 1))).len;
                n3 = this.tCursor.yindex - 1;
            }
            if (n3 > -1) {
                if (bl) {
                    this.updateSel(n2, n3, true);
                } else {
                    this.setCursorPos(n2, n3, true, true);
                }
                return true;
            }
            return false;
        }

        void cursorRight(int n, boolean bl) {
            int n2 = -1;
            int n3 = -1;
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            if (textBuffer.len >= this.tCursor.index + n) {
                n2 = this.tCursor.index + n;
                n3 = this.tCursor.yindex;
            } else if (this.tCursor.yindex < this.rows.size() - 1) {
                n2 = 0;
                n3 = this.tCursor.yindex + 1;
            }
            if (n3 > -1) {
                if (bl) {
                    this.updateSel(n2, n3, true);
                    return;
                }
                this.setCursorPos(n2, n3, true, true);
            }
        }

        void cursorTextEnd(boolean bl) {
            int n = this.rows.size() - 1;
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n);
            if (bl) {
                this.updateSel(textBuffer.len, n, true);
                return;
            }
            this.setCursorPos(textBuffer.len, n, true, true);
        }

        void cursorTextHome(boolean bl) {
            if (bl) {
                this.updateSel(0, 0, true);
                return;
            }
            this.setCursorPos(0, 0, true, true);
        }

        void cursorUp(int n, boolean bl) {
            int n2 = Math.max(this.tCursor.yindex - n, 0);
            if (n2 != this.tCursor.yindex) {
                if (bl) {
                    this.updateSel(this.tCursor.index, n2, true);
                    return;
                }
                this.setCursorPos(this.tCursor.index, n2, true, true);
            }
        }

        void del() {
            TextBuffer textBuffer = this.getCursorLine();
            if (textBuffer.len > this.tCursor.index) {
                textBuffer.remove(this.tCursor.index, 1);
                this.repaintLine(this.tCursor.yindex, this.tCursor.index, textBuffer);
                return;
            }
            if (this.tCursor.yindex < this.rows.size() - 1) {
                TextBuffer textBuffer2 = (TextBuffer)this.rows.elementAt(this.tCursor.yindex + 1);
                textBuffer.append(textBuffer2);
                this.rows.removeElement(textBuffer2);
                this.updateScrolls();
                this.repaint();
            }
        }

        void deleteSel() {
            Point point = this.getSelStart();
            Point point2 = this.getSelEnd();
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(point.y);
            int n = 1;
            if (point.x == point2.x && point.y == point2.y) {
                return;
            }
            if (point.y == point2.y) {
                textBuffer.remove(point.x, point2.x - point.x);
                this.setCursorPos(point.x, point.y, true, true);
                if (this.updateHScroll()) {
                    this.rearrange();
                }
                return;
            }
            if (point.x > 0) {
                textBuffer.remove(point.x, textBuffer.len - point.x);
            } else {
                n = 0;
            }
            textBuffer = (TextBuffer)this.rows.elementAt(point2.y);
            textBuffer.remove(0, point2.x);
            int n2 = point.y + n;
            while (n2 < point2.y) {
                this.rows.removeElementAt(point.y + n);
                ++n2;
            }
            this.setCursorPos(point.x, point.y, false, true);
            this.updateScrolls();
            this.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintCursor();
            super.focusGained(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.paintInactiveCursor();
            super.focusLost(focusEvent);
        }

        int get1D(Point point) {
            int n = 0;
            int n2 = 0;
            while (n2 < point.y) {
                TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n2);
                n += textBuffer.len;
                ++n;
                ++n2;
            }
            return n += point.x;
        }

        Point get2D(int n) {
            int n2 = this.rows.size();
            int n3 = 0;
            TextBuffer textBuffer = null;
            if (n2 == 0) {
                return new Point(-1, -1);
            }
            int n4 = 0;
            while (n4 < n2) {
                textBuffer = (TextBuffer)this.rows.elementAt(n4);
                if ((n3 += textBuffer.len) >= n) {
                    return new Point(textBuffer.len - n3 + n, n4);
                }
                --n;
                ++n4;
            }
            return new Point(textBuffer.len, n2 - 1);
        }

        int getCol(int n, int n2) {
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n);
            return textBuffer.getIdx(n2 - this.xOffs);
        }

        TextBuffer getCursorLine() {
            return (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
        }

        Point getSelEnd() {
            if (this.sSel.y > this.eSel.y) {
                return this.sSel;
            }
            if (this.sSel.y == this.eSel.y) {
                if (this.sSel.x > this.eSel.x) {
                    return this.sSel;
                }
                return this.eSel;
            }
            return this.eSel;
        }

        Point getSelStart() {
            if (this.sSel.y < this.eSel.y) {
                return this.sSel;
            }
            if (this.sSel.y == this.eSel.y) {
                if (this.sSel.x < this.eSel.x) {
                    return this.sSel;
                }
                return this.eSel;
            }
            return this.eSel;
        }

        boolean hasSel() {
            return this.sSel.x != this.eSel.x || this.sSel.y != this.eSel.y;
        }

        boolean hasSel(int n) {
            if (this.hasSel()) {
                return this.sSel.y <= n || this.eSel.y >= n;
            }
            return false;
        }

        void insert(String string, boolean bl) {
            if (string == null || string.length() == 0) {
                return;
            }
            String[] stringArray = this.breakLines(string);
            int n = 0;
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            if (stringArray.length == 0) {
                return;
            }
            if (stringArray.length == 1) {
                int n2 = bl ? this.tCursor.index : this.tCursor.index + stringArray[0].length();
                textBuffer.insert(this.tCursor.index, stringArray[0]);
                this.setCursorPos(n2, this.tCursor.yindex, false, false);
                this.repaintLine(this.tCursor.yindex, 0, textBuffer);
                return;
            }
            String string2 = textBuffer.getString(this.tCursor.index, textBuffer.len - this.tCursor.index);
            textBuffer.remove(this.tCursor.index, textBuffer.len - this.tCursor.index);
            textBuffer.append(stringArray[n++]);
            while (n < stringArray.length) {
                textBuffer = this.insertLine(stringArray[n++], this.tCursor.yindex + n - 1);
            }
            if (!bl) {
                this.setCursorPos(textBuffer.len, this.tCursor.yindex + stringArray.length - 1, false, false);
            }
            textBuffer.append(string2);
            this.updateScrolls();
            this.repaint();
        }

        void insert(String string, int n) {
            this.insertText(string, n);
        }

        void insertChar(char c) {
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            boolean bl = this.tCursor.index == textBuffer.len;
            textBuffer.insert(this.tCursor.index, c);
            if (!bl) {
                int n = this.tCursor.index > 0 ? this.tCursor.index - 1 : this.tCursor.index;
                this.repaintLine(this.tCursor.yindex, n, textBuffer);
            }
            this.cursorRight(1, false);
        }

        TextBuffer insertLine(String string, int n) {
            TextBuffer textBuffer = new TextBuffer(string);
            textBuffer.setMetrics(this.fm, TextArea.this.tabWidth);
            this.rows.insertElementAt(textBuffer, n);
            return textBuffer;
        }

        void insertText(String string, int n) {
            Point point = this.get2D(n);
            this.setCursorPos(point.x, point.y, true, true);
            this.insert(string, false);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.parent.keyListener != null) {
                this.redirectKeyEvent(keyEvent);
            }
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            boolean bl = keyEvent.isShiftDown();
            if (n2 != 0 && n2 != 1) {
                return;
            }
            switch (n) {
                case 37: {
                    this.cursorLeft(1, bl);
                    break;
                }
                case 39: {
                    this.cursorRight(1, bl);
                    break;
                }
                case 38: {
                    this.cursorUp(1, bl);
                    break;
                }
                case 40: {
                    this.cursorDown(1, bl);
                    break;
                }
                case 9: {
                    if (bl) {
                        return;
                    }
                    if (!TextArea.this.isEditable) break;
                    this.insertChar('\t');
                    break;
                }
                case 10: {
                    if (!TextArea.this.isEditable) break;
                    this.newline();
                    break;
                }
                case 8: {
                    if (!TextArea.this.isEditable) break;
                    if (this.hasSel()) {
                        this.replaceSelectionWith("");
                        break;
                    }
                    this.backspace();
                    break;
                }
                case 127: {
                    if (!TextArea.this.isEditable) break;
                    if (this.hasSel()) {
                        this.replaceSelectionWith("");
                        break;
                    }
                    this.del();
                    break;
                }
                case 36: {
                    this.cursorHome(bl);
                    break;
                }
                case 35: {
                    this.cursorEnd(bl);
                    break;
                }
                case 33: {
                    this.pageUp(bl);
                    break;
                }
                case 34: {
                    this.pageDown(bl);
                    break;
                }
                case 27: {
                    this.resetSel(true);
                    break;
                }
                default: {
                    return;
                }
            }
            keyEvent.consumed = true;
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.redirectKeyEvent(keyEvent);
            keyEvent.consumed = true;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (!TextArea.this.isEditable || !TextArea.this.isPrintableTyped(keyEvent)) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (this.hasSel()) {
                Character c2 = new Character(c);
                this.replaceSelectionWith(c2.toString());
            } else {
                this.insertChar(c);
            }
            if (this.parent.keyListener != null) {
                this.redirectKeyEvent(keyEvent);
            }
            if (TextArea.this.textListener != null || ((long)this.eventMask & 0x400L) != 0L) {
                Toolkit.eventQueue.postEvent(TextEvt.getEvent(TextArea.this, 900));
            }
            keyEvent.consumed = true;
        }

        @Override
        int maxRowWidth() {
            int n = this.rows.size();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4 = ((TextBuffer)this.rows.elementAt(n3)).getWidth();
                if (n4 > n2) {
                    n2 = n4;
                }
                ++n3;
            }
            return n2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.parent.mouseListener != null) {
                this.parent.process(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.getRowIdx(mouseEvent.getY());
            int n2 = this.getCol(n, mouseEvent.getX());
            this.updateSel(n2, n, true);
            if (this.parent.motionListener != null) {
                this.redirectMotionEvent(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.redirectMouseEvent(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.redirectMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.parent.motionListener != null) {
                this.redirectMotionEvent(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if (mouseEvent.isPopupTrigger() && this.triggerPopup(mouseEvent.getX(), mouseEvent.getY()) != null) {
                return;
            }
            switch (n) {
                case 16: {
                    TextArea.this.tp.requestFocus();
                    this.resetSel(true);
                    int n2 = this.getRowIdx(mouseEvent.getY());
                    int n3 = this.getCol(n2, mouseEvent.getX());
                    this.setCursorPos(n3, n2, true, true);
                    break;
                }
                case 8: {
                    TextArea.this.pasteFromClipboard();
                }
            }
            this.redirectMouseEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.redirectMouseEvent(mouseEvent);
        }

        void newline() {
            String string = "";
            TextBuffer textBuffer = this.getCursorLine();
            if (textBuffer.len > this.tCursor.index) {
                int n = textBuffer.len - this.tCursor.index;
                string = textBuffer.getString(this.tCursor.index, n);
                textBuffer.remove(this.tCursor.index, n);
            }
            TextBuffer textBuffer2 = this.insertLine(string, this.tCursor.yindex + 1);
            textBuffer2.copyLevelFrom(textBuffer);
            this.updateScrolls();
            this.setCursorPos(textBuffer2.getLevel(), this.tCursor.yindex + 1, true, true);
            this.repaintRows(this.tCursor.yindex - 1, this.getVisibleRows());
        }

        void pageDown(boolean bl) {
            int n = this.getVisibleRows();
            int n2 = Math.min(this.tCursor.yindex + n, this.rows.size() - 1);
            if (bl) {
                this.updateSel(this.tCursor.index, n2, true);
                return;
            }
            this.setCursorPos(this.tCursor.index, n2, true, true);
        }

        void pageUp(boolean bl) {
            int n = this.getVisibleRows();
            int n2 = Math.max(this.tCursor.yindex - n, 0);
            if (bl) {
                this.updateSel(this.tCursor.index, n2, true);
                return;
            }
            this.setCursorPos(this.tCursor.index, n2, true, true);
        }

        @Override
        public void paint(Graphics graphics) {
            this.repaintRows(graphics, this.first, this.rows.size() - this.first);
            this.kaffePaintBorder(graphics);
        }

        void paintInactiveCursor() {
            if (this.rgr != null) {
                this.paintInactiveCursor(this.rgr);
            }
        }

        void paintInactiveCursor(Graphics graphics) {
            graphics.setColor(Defaults.TextCursorInactiveClr);
            this.tCursor.blank(graphics, this.xOffs, this.getRowYPos(this.tCursor.yindex));
        }

        void repaintCursor() {
            this.repaintCursor(this.rgr);
        }

        void repaintCursor(Graphics graphics) {
            if (graphics != null) {
                if (AWTEvent.keyTgt == this) {
                    this.tCursor.paint(graphics, this.xOffs, this.getRowYPos(this.tCursor.yindex));
                    return;
                }
                this.paintInactiveCursor(graphics);
            }
        }

        void repaintLine(Graphics graphics, int n, int n2, TextBuffer textBuffer) {
            int n3 = 2;
            if (graphics == null) {
                return;
            }
            if (textBuffer == null) {
                textBuffer = (TextBuffer)this.rows.elementAt(n);
            }
            int n4 = this.selXStart(n);
            int n5 = this.selXEnd(n, textBuffer);
            int n6 = n3 + (n - this.first) * this.rowHeight;
            if (n4 == n5) {
                int n7 = n2 == 0 ? 0 : textBuffer.getPos(n2) + this.xOffs;
                int n8 = this.width - n7;
                graphics.setColor(this.bgClr);
                graphics.fillRect(n7, n6, n8 - n3, this.rowHeight);
                graphics.setColor(this.fgClr);
                textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n2);
            } else {
                int n9;
                int n10;
                if (n4 > n2) {
                    n10 = textBuffer.getPos(n2) + this.xOffs;
                    n9 = textBuffer.getWidth(n2, n4);
                    graphics.setColor(this.bgClr);
                    graphics.fillRect(n10, n6, n9, this.rowHeight);
                    graphics.setColor(this.fgClr);
                    textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n2, n4 - n2);
                }
                if (n5 > n2) {
                    n10 = textBuffer.getPos(n4) + this.xOffs;
                    n9 = textBuffer.getWidth(n4, n5);
                    graphics.setColor(Defaults.TextAreaSelBgClr);
                    graphics.fill3DRect(n10, n6, n9, this.rowHeight, true);
                    graphics.setColor(Defaults.TextAreaSelTxtClr);
                    textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n4, n5 - n4);
                }
                n10 = textBuffer.getPos(n5) + this.xOffs;
                n9 = this.width - n10;
                graphics.setColor(this.bgClr);
                graphics.fillRect(n10, n6, n9, this.rowHeight);
                if (n5 < textBuffer.len) {
                    graphics.setColor(this.fgClr);
                    textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n5);
                }
            }
            if (this.tCursor.yindex == n) {
                this.repaintCursor(graphics);
            }
        }

        void repaintLine(int n, int n2, TextBuffer textBuffer) {
            this.repaintLine(this.rgr, n, n2, textBuffer);
        }

        @Override
        void repaintRow(Graphics graphics, int n) {
            this.repaintLine(graphics, n, 0, null);
        }

        void replaceRange(String string, int n, int n2) {
            this.sSel = this.get2D(n);
            this.eSel = this.get2D(n2);
            if (this.sSel.y > -1 && this.eSel.y > -1) {
                this.deleteSel();
            } else {
                this.resetSel(false);
            }
            this.insert(string, true);
        }

        void replaceSelectionWith(String string) {
            this.deleteSel();
            this.insert(string, false);
        }

        void resetSel(boolean bl) {
            boolean bl2 = this.hasSel();
            int n = Math.min(this.sSel.y, this.eSel.y);
            int n2 = Math.max(this.sSel.y, this.eSel.y);
            this.sSel.x = this.tCursor.index;
            this.sSel.y = this.tCursor.yindex;
            this.eSel.x = this.sSel.x;
            this.eSel.y = this.sSel.y;
            if (bl2 && bl) {
                this.repaintRows(n, n2 - n);
            }
        }

        int selXEnd(int n, TextBuffer textBuffer) {
            Point point = this.getSelStart();
            Point point2 = this.getSelEnd();
            if (n > point2.y) {
                return -1;
            }
            if (n < point.y) {
                return -1;
            }
            if (n == point2.y) {
                return point2.x;
            }
            return textBuffer.len;
        }

        int selXStart(int n) {
            Point point = this.getSelStart();
            Point point2 = this.getSelEnd();
            if (n > point2.y) {
                return -1;
            }
            if (n < point.y) {
                return -1;
            }
            if (n == point.y) {
                return point.x;
            }
            return 0;
        }

        synchronized void setContents(String string) {
            String[] stringArray = this.breakLines(string);
            this.rows.removeAllElements();
            int n = 0;
            while (n < stringArray.length) {
                this.insertLine(stringArray[n], n);
                ++n;
            }
            this.setCursorPos(0, 0, false, true);
            this.updateScrolls();
            this.repaint();
        }

        void setCursorPos(int n, int n2, boolean bl, boolean bl2) {
            int n3 = this.tCursor.index;
            if (bl2) {
                this.resetSel(bl);
            }
            if (bl) {
                this.blankCursor();
            }
            this.makeVisible(n2);
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n2);
            this.tCursor.setYIndex(n2, this.getRowYPos(n2));
            if (n > textBuffer.len) {
                n = textBuffer.len;
            }
            int n4 = textBuffer.getPos(n);
            this.tCursor.setIndex(n, n4);
            this.repaintCursor();
            if (bl2) {
                this.resetSel(false);
            }
            if (this.width > 0) {
                int n5 = 10;
                if (n > n3 && n4 - this.xOffs > this.width - n5) {
                    this.xOffs = this.width - n4 - n5;
                    if (this.hScroll != null) {
                        if (this.updateHScroll()) {
                            this.rearrange();
                        }
                        this.hScroll.setValue(-this.xOffs);
                    }
                    this.repaint();
                    return;
                }
                if (n4 + this.xOffs < this.xOffsInit) {
                    this.xOffs = -n4 + this.xOffsInit;
                    if (this.hScroll != null) {
                        if (this.updateHScroll()) {
                            this.rearrange();
                        }
                        this.hScroll.setValue(-this.xOffs);
                    }
                    this.repaint();
                }
            }
        }

        @Override
        public void setFont(Font font) {
            TextBuffer textBuffer;
            int n = this.rows.size();
            super.setFont(font);
            this.fm = this.getFontMetrics(font);
            if (this.rgr != null) {
                this.rgr.setFont(font);
            }
            TextArea.this.tabWidth = 3 * this.fm.charWidth('x');
            this.rowHeight = this.fm.getHeight() + 2;
            int n2 = 0;
            while (n2 < n) {
                textBuffer = (TextBuffer)this.rows.elementAt(n2);
                textBuffer.setMetrics(this.fm, TextArea.this.tabWidth);
                ++n2;
            }
            textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            this.tCursor.setHeight(this.rowHeight - 1);
            this.tCursor.setYIndex(this.tCursor.yindex, this.getRowYPos(this.tCursor.yindex));
            this.tCursor.setIndex(this.tCursor.index, textBuffer.getPos(this.tCursor.index));
            if (this.isShowing()) {
                this.repaint();
            }
        }

        boolean updateSel(int n, int n2, boolean bl) {
            if (n == this.eSel.x && n2 == this.eSel.y) {
                return false;
            }
            this.eSel.x = n;
            this.eSel.y = n2;
            int n3 = Math.min(this.sSel.y, this.eSel.y);
            int n4 = Math.max(this.sSel.y, this.eSel.y);
            this.setCursorPos(n, n2, false, false);
            if (bl) {
                this.repaintRows(n3, n4 - n3 + 1);
            }
            return true;
        }

        @Override
        void vPosChange(int n) {
            this.tCursor.setYIndex(this.tCursor.yindex, this.getRowYPos(this.tCursor.yindex));
        }

        private /* synthetic */ void Block$() {
            this.tCursor = new TextCursor();
            this.sSel = new Point();
            this.eSel = new Point();
        }
    }
}

