/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICC_ColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 3455889114070431483L;
    private ICC_Profile thisProfile;
    private float[] minVal;
    private float[] maxVal;
    private float[] diffMinMax;
    private float[] invDiffMinMax;
    private boolean needScaleInit;

    public ICC_ColorSpace(ICC_Profile iCC_Profile) {
        super(1000, iCC_Profile.getNumComponents());
        this.thisProfile = iCC_Profile;
    }

    public ICC_Profile getProfile() {
        return this.thisProfile;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        if (fArray.length < this.numComponents) {
            throw new IllegalArgumentException();
        }
        return fArray;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        if (fArray.length < 3) {
            throw new IllegalArgumentException();
        }
        return fArray;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getMinValue(int n) {
        if (this.type == 1 && (n == 1 || n == 2)) {
            return -128.0f;
        }
        if (n < 0 || n >= this.numComponents) {
            throw new IllegalArgumentException();
        }
        return 0.0f;
    }

    @Override
    public float getMaxValue(int n) {
        if (this.type == 0 && n >= 0 && n <= 2) {
            return 1.9999695f;
        }
        if (this.type == 1) {
            if (n == 0) {
                return 100.0f;
            }
            if (n == 1 || n == 2) {
                return 127.0f;
            }
        }
        if (n < 0 || n >= this.numComponents) {
            throw new IllegalArgumentException();
        }
        return 1.0f;
    }
}

